/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDependencies
extends Task {
    private List<Input> inputs = new ArrayList<Input>();
    private List<Output> outputs = new ArrayList<Output>();
    private Set<ModuleInfo> modules;
    private Pattern regexp;

    public void setGenerate(String regexpList) {
        this.regexp = Pattern.compile(regexpList);
    }

    public Input createInput() throws BuildException {
        Input input = new Input();
        this.inputs.add(input);
        return input;
    }

    public Output createOutput() throws BuildException {
        Output output = new Output();
        this.outputs.add(output);
        return output;
    }

    public void execute() throws BuildException {
        if (this.outputs.size() == 0) {
            throw new BuildException("At least one <output> tag has to be specified");
        }
        try {
            this.readModuleInfo();
            for (Output o : this.outputs) {
                if (o.type == null) {
                    throw new BuildException("<output> needs attribute type");
                }
                if (o.file == null) {
                    throw new BuildException("<output> needs attribute file");
                }
                this.getProject().log("Generating " + (Object)((Object)o.type) + " to " + o.file);
                if ("public-packages".equals(o.type.getValue())) {
                    this.generatePublicPackages(o.file, true, false);
                    continue;
                }
                if ("friend-packages".equals(o.type.getValue())) {
                    this.generatePublicPackages(o.file, false, false);
                    continue;
                }
                if ("shared-packages".equals(o.type.getValue())) {
                    this.generateSharedPackages(o.file);
                    continue;
                }
                if ("modules".equals(o.type.getValue())) {
                    this.generateListOfModules(o.file);
                    continue;
                }
                if ("dependencies".equals(o.type.getValue())) {
                    this.generateDependencies(o.file, false);
                    continue;
                }
                if ("implementation-dependencies".equals(o.type.getValue())) {
                    this.generateDependencies(o.file, true);
                    continue;
                }
                if ("group-dependencies".equals(o.type.getValue())) {
                    this.generateGroupDependencies(o.file, false);
                    continue;
                }
                if ("group-implementation-dependencies".equals(o.type.getValue())) {
                    this.generateGroupDependencies(o.file, true);
                    continue;
                }
                if ("group-friend-packages".equals(o.type.getValue())) {
                    this.generatePublicPackages(o.file, false, true);
                    continue;
                }
                if ("kits".equals(o.type.getValue())) {
                    this.generateKits(o.file);
                    continue;
                }
                if (!"kit-dependencies".equals(o.type.getValue())) continue;
                this.generateKitDependencies(o.file);
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void readModuleInfo() throws IOException {
        this.modules = new TreeSet<ModuleInfo>();
        if (this.inputs.isEmpty()) {
            throw new BuildException("At least one <input> tag is needed");
        }
        for (Input input : this.inputs) {
            if (input.jars == null) {
                throw new BuildException("<input> needs a subelement <jars>");
            }
            if (input.name == null) {
                throw new BuildException("<input> needs attribute name");
            }
            Project p = this.getProject();
            DirectoryScanner scan = input.jars.getDirectoryScanner(p);
            for (String incl : scan.getIncludedFiles()) {
                String essential;
                int majorVersion;
                String codebasename;
                String module;
                File f = new File(scan.getBasedir(), incl);
                this.getProject().log("Processing " + f, 3);
                JarFile file = new JarFile(f);
                Manifest manifest = file.getManifest();
                if (manifest == null || (module = manifest.getMainAttributes().getValue("OpenIDE-Module")) == null) continue;
                int slash = module.indexOf(47);
                if (slash == -1) {
                    codebasename = module;
                    majorVersion = -1;
                } else {
                    codebasename = module.substring(0, slash);
                    majorVersion = Integer.valueOf(module.substring(slash + 1));
                }
                ModuleInfo m = new ModuleInfo(input.name, f, codebasename);
                m.majorVersion = majorVersion;
                String showInAutoUpdate = file.getManifest().getMainAttributes().getValue("AutoUpdate-Show-In-Client");
                m.showInAutoupdate = showInAutoUpdate == null ? true : Boolean.parseBoolean(showInAutoUpdate);
                m.publicPackages = file.getManifest().getMainAttributes().getValue("OpenIDE-Module-Public-Packages");
                m.specificationVersion = file.getManifest().getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                m.implementationVersion = file.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
                TreeSet<Dependency> depends = new TreeSet<Dependency>();
                TreeSet<Dependency> provides = new TreeSet<Dependency>();
                ModuleDependencies.addDependencies(depends, file.getManifest(), 2, "OpenIDE-Module-Requires");
                ModuleDependencies.addDependencies(provides, file.getManifest(), 1, "OpenIDE-Module-Provides");
                String ideDeps = file.getManifest().getMainAttributes().getValue("OpenIDE-Module-IDE-Dependencies");
                if (ideDeps != null) {
                    throw new BuildException("OpenIDE-Module-IDE-Dependencies is obsolete in " + f);
                }
                ModuleDependencies.addDependencies(depends, file.getManifest(), 2, "OpenIDE-Module-Module-Dependencies");
                m.depends = depends;
                m.provides = provides;
                String friends = file.getManifest().getMainAttributes().getValue("OpenIDE-Module-Friends");
                if (friends != null) {
                    TreeSet<String> set = new TreeSet<String>();
                    StringTokenizer tok = new StringTokenizer(friends, ", ");
                    while (tok.hasMoreElements()) {
                        set.add(tok.nextToken());
                    }
                    m.friends = set;
                }
                m.isEssential = (essential = file.getManifest().getMainAttributes().getValue("AutoUpdate-Essential-Module")) == null ? false : Boolean.parseBoolean(file.getManifest().getMainAttributes().getValue("AutoUpdate-Essential-Module"));
                m.isAutoload = this.determineParameter(f, "autoload");
                m.isEager = this.determineParameter(f, "eager");
                this.modules.add(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean determineParameter(File moduleFile, String parameter) throws IOException {
        String name = moduleFile.getName();
        name = name.substring(0, name.length() - 3) + "xml";
        File configFile = new File(moduleFile.getParentFile().getParentFile(), "config/Modules/" + name);
        this.log("config " + configFile, 4);
        if (!configFile.exists()) {
            return true;
        }
        String fragment = "<param name=\"" + parameter + "\">true</param>";
        BufferedReader br = new BufferedReader(new FileReader(configFile));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(fragment) == -1) continue;
                this.log("autoload module: " + moduleFile, 4);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            br.close();
        }
        return false;
    }

    private void generatePublicPackages(File output, boolean justPublic, boolean justInterCluster) throws BuildException, IOException {
        TreeSet<String> packages = new TreeSet<String>();
        TreeMap<ModuleInfo, TreeSet<String>> friendExports = new TreeMap<ModuleInfo, TreeSet<String>>();
        for (ModuleInfo m : this.modules) {
            if (justPublic && m.friends != null || this.regexp != null && !this.regexp.matcher(m.group).matches()) continue;
            String s = m.publicPackages;
            HashMap<String, Boolean> pkgs = null;
            if (s != null) {
                pkgs = new HashMap<String, Boolean>();
                StringTokenizer tok = new StringTokenizer(s, ",");
                while (tok.hasMoreElements()) {
                    String p = tok.nextToken().trim();
                    if (p.equals("-")) continue;
                    if (p.endsWith(".*")) {
                        pkgs.put(p.substring(0, p.length() - 2).replace('.', '/'), Boolean.FALSE);
                        continue;
                    }
                    if (p.endsWith(".**")) {
                        pkgs.put(p.substring(0, p.length() - 3).replace('.', '/'), Boolean.TRUE);
                        continue;
                    }
                    throw new BuildException("Unknown package format: " + p + " in " + m.file);
                }
            }
            if (justPublic) {
                this.iterateThruPackages(m.file, pkgs, packages);
                if (pkgs == null || packages.size() >= pkgs.size()) continue;
                throw new BuildException("Not enough packages found. The declared packages are: " + s + " but only " + packages + " were found in " + m.file);
            }
            TreeSet<String> modulePkgs = new TreeSet<String>();
            this.iterateThruPackages(m.file, pkgs, modulePkgs);
            friendExports.put(m, modulePkgs);
        }
        PrintWriter w = new PrintWriter(new FileWriter(output));
        if (justPublic) {
            for (String out : packages) {
                w.println(out.replace('/', '.'));
            }
        } else {
            String maxFriendsString;
            int maxFriends = Integer.MAX_VALUE;
            if (justInterCluster && (maxFriendsString = this.getProject().getProperty("deps.max.friends")) != null) {
                maxFriends = Integer.parseInt(maxFriendsString);
            }
            for (Map.Entry entry : friendExports.entrySet()) {
                ModuleInfo info = (ModuleInfo)entry.getKey();
                if (info.friends == null) continue;
                this.log("Friends for " + info.getName(false), 4);
                int cntFriends = 0;
                boolean printed = false;
                for (String n : info.friends) {
                    ModuleInfo friend = this.findModuleInfo(n);
                    if (justInterCluster && friend != null && friend.group.equals(info.group)) continue;
                    if (!printed) {
                        w.print("MODULE ");
                        w.println(info.getName(false));
                        printed = true;
                    }
                    if (friend != null) {
                        w.print("  FRIEND ");
                        w.println(friend.getName(false));
                    } else {
                        w.print("  EXTERNAL ");
                        w.println(n);
                    }
                    ++cntFriends;
                }
                if (cntFriends > maxFriends) {
                    throw new BuildException("Too many intercluster friends (" + cntFriends + ") for module " + info.getName(false));
                }
                if (cntFriends <= 0) continue;
                for (String out : (TreeSet)entry.getValue()) {
                    w.print("  PACKAGE ");
                    w.println(out.replace('/', '.'));
                }
            }
        }
        w.close();
    }

    private void iterateThruPackages(File f, HashMap pkgs, TreeSet<String> packages) throws IOException {
        String value;
        JarFile file = new JarFile(f);
        Enumeration<JarEntry> en = file.entries();
        block0: while (en.hasMoreElements()) {
            int last;
            JarEntry e = en.nextElement();
            if (!e.getName().endsWith(".class") || (last = e.getName().lastIndexOf(47)) == -1) continue;
            String p = e.getName().substring(0, last);
            if (pkgs == null) {
                packages.add(p);
                continue;
            }
            Boolean b = (Boolean)pkgs.get(p);
            if (b != null) {
                packages.add(p);
                continue;
            }
            String parent = p;
            while (parent.length() > 0) {
                int prev = parent.lastIndexOf(47);
                b = (Boolean)pkgs.get(parent = prev == -1 ? "" : parent.substring(0, prev));
                if (!Boolean.TRUE.equals(b)) continue;
                packages.add(p);
                continue block0;
            }
        }
        Manifest m = file.getManifest();
        if (m != null && (value = m.getMainAttributes().getValue("Class-Path")) != null) {
            StringTokenizer tok = new StringTokenizer(value, " ");
            while (tok.hasMoreElements()) {
                File sub = new File(f.getParentFile(), tok.nextToken());
                if (!sub.isFile()) continue;
                this.iterateThruPackages(sub, pkgs, packages);
            }
        }
        file.close();
    }

    private void generateListOfModules(File output) throws BuildException, IOException {
        PrintWriter w = new PrintWriter(new FileWriter(output));
        for (ModuleInfo m : this.modules) {
            if (this.regexp != null && !this.regexp.matcher(m.group).matches()) continue;
            w.print("MODULE ");
            w.print(m.getName(true));
            w.println();
        }
        w.close();
    }

    private void generateKits(File output) throws BuildException, IOException {
        PrintWriter w = new PrintWriter(new FileWriter(output));
        TreeMap<String, TreeSet<String>> allKitDeps = this.transitiveClosureOfKits();
        TreeMap<String, TreeSet<String>> allModuleDeps = this.transitiveClosureOfModules();
        TreeMap<ModuleInfo, Set<String>> dependingKits = new TreeMap<ModuleInfo, Set<String>>();
        for (ModuleInfo m : this.modules) {
            if (this.regexp != null && !this.regexp.matcher(m.group).matches() || !m.showInAutoupdate) continue;
            Set dep = allModuleDeps.get(m.codebasename);
            for (String ds : dep) {
                if (this.regexp != null && !this.regexp.matcher(m.group).matches()) continue;
                ModuleInfo theModuleOneIsDependingOn = this.findModuleInfo(ds);
                if (theModuleOneIsDependingOn.showInAutoupdate || theModuleOneIsDependingOn.isAutoload || theModuleOneIsDependingOn.isEager || theModuleOneIsDependingOn.isEssential) continue;
                TreeSet<String> kits = (TreeSet<String>)dependingKits.get(theModuleOneIsDependingOn);
                if (kits == null) {
                    kits = new TreeSet<String>();
                    dependingKits.put(theModuleOneIsDependingOn, kits);
                }
                kits.add(m.getName(false));
            }
        }
        TreeMap<String, TreeSet<String>> allKits = new TreeMap<String, TreeSet<String>>();
        for (ModuleInfo module : dependingKits.keySet()) {
            Set kits = (Set)dependingKits.get(module);
            String lowestKitCandidate = null;
            for (String kit : kits) {
                if (lowestKitCandidate == null) {
                    lowestKitCandidate = kit;
                    this.log("  initial lowest kit candidate for " + module.getName(false) + " : " + lowestKitCandidate, 4);
                    continue;
                }
                if (!this.dependsOnTransitively(lowestKitCandidate, kit, allKitDeps)) continue;
                lowestKitCandidate = kit;
                this.log("  new lowest kit candidate for " + module.getName(false) + " : " + lowestKitCandidate, 4);
            }
            boolean passed = true;
            for (String kit : kits) {
                if (kit.equals(lowestKitCandidate) || this.dependsOnTransitively(kit, lowestKitCandidate, allKitDeps)) continue;
                this.log("lowest kit not found for " + module.getName(false) + " : " + lowestKitCandidate + ", " + kit + " do not have a dependency", 3);
                passed = false;
                break;
            }
            if (passed) {
                dependingKits.put(module, Collections.singleton(lowestKitCandidate));
                ModuleDependencies.registerModuleInKit(module, lowestKitCandidate, allKits);
                continue;
            }
            w.print("Warning: ambiguous module ownership - module ");
            w.print(module.getName(false));
            w.print(" is contained in kits ");
            w.println();
            for (String kit : kits) {
                ModuleDependencies.registerModuleInKit(module, kit, allKits);
                w.print("  " + kit);
                w.println();
            }
            w.println("No dependency between ");
            for (String kit : kits) {
                if (kit.equals(lowestKitCandidate) || this.dependsOnTransitively(kit, lowestKitCandidate, allKitDeps)) continue;
                w.println("  " + lowestKitCandidate + ", " + kit);
            }
        }
        for (String kit : allKits.keySet()) {
            w.print("KIT ");
            w.print(kit);
            w.println();
            for (String m : (TreeSet)allKits.get(kit)) {
                w.print("  CONTAINS " + m);
                w.println();
            }
        }
        w.close();
    }

    private boolean dependsOnTransitively(String kit1, String kit2, TreeMap<String, TreeSet<String>> dependingKits) {
        TreeSet<String> kits = dependingKits.get(kit1);
        if (kits == null) {
            return false;
        }
        return kits.contains(kit2);
    }

    private static void registerModuleInKit(ModuleInfo module, String kit, TreeMap<String, TreeSet<String>> allKits) {
        TreeSet<String> modules = allKits.get(kit);
        if (modules == null) {
            modules = new TreeSet();
            allKits.put(kit, modules);
        }
        modules.add(module.getName(false));
    }

    private TreeMap<String, TreeSet<String>> transitiveClosureOfModules() {
        TreeMap<String, TreeSet<String>> moduleDepsAll = new TreeMap<String, TreeSet<String>>();
        for (ModuleInfo m : this.modules) {
            TreeSet<String> deps = new TreeSet<String>();
            moduleDepsAll.put(m.codebasename, deps);
            for (Dependency d : m.depends) {
                if (d.isSpecial()) continue;
                ModuleInfo theModuleOneIsDependingOn = this.findModuleInfo(d, m);
                deps.add(theModuleOneIsDependingOn.codebasename);
            }
        }
        this.transitiveClosure(moduleDepsAll);
        return moduleDepsAll;
    }

    private TreeMap<String, TreeSet<String>> transitiveClosureOfKits() {
        TreeMap<String, TreeSet<String>> kitDepsAll = new TreeMap<String, TreeSet<String>>();
        for (ModuleInfo m : this.modules) {
            if (!m.showInAutoupdate) continue;
            TreeSet<String> deps = new TreeSet<String>();
            kitDepsAll.put(m.getName(false), deps);
            for (Dependency d : m.depends) {
                if (d.isSpecial()) continue;
                ModuleInfo theModuleOneIsDependingOn = this.findModuleInfo(d, m);
                if (!theModuleOneIsDependingOn.showInAutoupdate) continue;
                deps.add(theModuleOneIsDependingOn.getName(false));
            }
        }
        this.transitiveClosure(kitDepsAll);
        return kitDepsAll;
    }

    private void transitiveClosure(TreeMap<String, TreeSet<String>> allDeps) {
        boolean needAnotherIteration = true;
        while (needAnotherIteration) {
            needAnotherIteration = false;
            for (String m : allDeps.keySet()) {
                TreeSet<String> deps = allDeps.get(m);
                for (String d : new TreeSet<String>((SortedSet<String>)deps)) {
                    for (String d2 : allDeps.get(d)) {
                        if (deps.contains(d2)) continue;
                        this.log("transitive closure: need to add " + d2 + " to " + m, 4);
                        deps.add(d2);
                        needAnotherIteration = true;
                    }
                }
            }
        }
    }

    private void generateKitDependencies(File output) throws BuildException, IOException {
        PrintWriter w = new PrintWriter(new FileWriter(output));
        for (ModuleInfo m : this.modules) {
            if (this.regexp != null && !this.regexp.matcher(m.group).matches() || !m.showInAutoupdate) continue;
            w.print("KIT ");
            w.print(m.getName(false));
            w.println();
            for (Dependency d : m.depends) {
                if (this.regexp != null && !this.regexp.matcher(m.group).matches() || d.isSpecial()) continue;
                ModuleInfo theModuleOneIsDependingOn = this.findModuleInfo(d, m);
                if (!theModuleOneIsDependingOn.showInAutoupdate) continue;
                w.print("  REQUIRES " + theModuleOneIsDependingOn.getName(false));
                w.println();
            }
        }
        w.close();
    }

    private void generateSharedPackages(File output) throws BuildException, IOException {
        TreeMap<String, ArrayList<ModuleInfo>> packages = new TreeMap<String, ArrayList<ModuleInfo>>();
        for (ModuleInfo m : this.modules) {
            HashSet<String> pkgs = new HashSet<String>();
            this.iterateSharedPackages(m.file, pkgs);
            for (String s : pkgs) {
                ArrayList<ModuleInfo> l = (ArrayList<ModuleInfo>)packages.get(s);
                if (l == null) {
                    l = new ArrayList<ModuleInfo>();
                    packages.put(s, l);
                }
                l.add(m);
            }
        }
        PrintWriter w = new PrintWriter(new FileWriter(output));
        for (Map.Entry entry : packages.entrySet()) {
            String out = (String)entry.getKey();
            List cnt = (List)entry.getValue();
            if (cnt.size() <= 1) continue;
            this.log("Package " + out + " is shared between:", 3);
            boolean doPrint = this.regexp == null;
            for (ModuleInfo m : cnt) {
                this.log("   " + m.codebasename, 3);
                if (this.regexp == null || !this.regexp.matcher(m.group).matches()) continue;
                doPrint = true;
            }
            if (!doPrint) continue;
            w.println(out.replace('/', '.'));
        }
        w.close();
    }

    private void iterateSharedPackages(File f, Set<String> myPkgs) throws IOException {
        String value;
        JarFile file = new JarFile(f);
        Enumeration<JarEntry> en = file.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (e.getName().endsWith("/") || e.getName().startsWith("META-INF/")) continue;
            int last = e.getName().lastIndexOf(47);
            String pkg = last == -1 ? "" : e.getName().substring(0, last);
            myPkgs.add(pkg);
            this.log("Found package " + pkg + " in " + f, 4);
        }
        Manifest m = file.getManifest();
        if (m != null && (value = m.getMainAttributes().getValue("Class-Path")) != null) {
            StringTokenizer tok = new StringTokenizer(value, " ");
            while (tok.hasMoreElements()) {
                File sub = new File(f.getParentFile(), tok.nextToken());
                if (!sub.isFile()) continue;
                this.iterateSharedPackages(sub, myPkgs);
            }
        }
        file.close();
    }

    private void generateDependencies(File output, boolean implementationOnly) throws BuildException, IOException {
        PrintWriter w = new PrintWriter(new FileWriter(output));
        for (ModuleInfo m : this.modules) {
            boolean first = true;
            for (Dependency d : m.depends) {
                if (d.getName().startsWith("org.openide.modules.ModuleFormat")) continue;
                String print = "  REQUIRES ";
                if ((!d.exact || d.compare == null) && implementationOnly || this.regexp != null && !this.regexp.matcher(m.group).matches()) continue;
                if (first) {
                    w.print("MODULE ");
                    w.print(m.getName(false));
                    w.println();
                    first = false;
                }
                w.print(print);
                if (d.isSpecial()) {
                    w.print(d.getName());
                } else {
                    ModuleInfo theModuleOneIsDependingOn = this.findModuleInfo(d, m);
                    w.print(theModuleOneIsDependingOn.getName(false));
                }
                w.println();
            }
        }
        w.close();
    }

    private void generateGroupDependencies(File output, boolean implementationOnly) throws BuildException, IOException {
        PrintWriter w = new PrintWriter(new FileWriter(output));
        HashMap<Dependency, HashSet<ModuleInfo>> referrers = new HashMap<Dependency, HashSet<ModuleInfo>>();
        TreeMap<String, TreeSet<Dependency>> groups = new TreeMap<String, TreeSet<Dependency>>();
        for (ModuleInfo moduleInfo : this.modules) {
            if (this.regexp != null && !this.regexp.matcher(moduleInfo.group).matches()) continue;
            TreeSet<Dependency> l = (TreeSet<Dependency>)groups.get(moduleInfo.group);
            if (l == null) {
                l = new TreeSet<Dependency>();
                groups.put(moduleInfo.group, l);
            }
            l.addAll(moduleInfo.depends);
            for (Dependency d : moduleInfo.depends) {
                HashSet<ModuleInfo> r = (HashSet<ModuleInfo>)referrers.get(d);
                if (r == null) {
                    r = new HashSet<ModuleInfo>();
                    referrers.put(d, r);
                }
                r.add(moduleInfo);
            }
        }
        for (Map.Entry entry : groups.entrySet()) {
            String groupName = (String)entry.getKey();
            Set depends = (Set)entry.getValue();
            boolean first = true;
            for (Dependency d : depends) {
                String print = "  REQUIRES ";
                if ((!d.exact || d.compare == null) && implementationOnly || d.isSpecial()) continue;
                Set r = (Set)referrers.get(d);
                ModuleInfo ref = this.findModuleInfo(d, r.size() == 1 ? (ModuleInfo)r.iterator().next() : null);
                if (groupName.equals(ref.group)) continue;
                if (first) {
                    w.print("GROUP ");
                    w.print(groupName);
                    w.println();
                    first = false;
                }
                w.print(print);
                w.print(ref.getName(false));
                w.println();
            }
        }
        w.close();
    }

    private ModuleInfo findModuleInfo(Dependency dep, ModuleInfo referrer) throws BuildException {
        for (ModuleInfo info : this.modules) {
            if (!dep.isDependingOn(info)) continue;
            return info;
        }
        throw new BuildException("Cannot find module that satisfies dependency: " + dep + (referrer != null ? " from: " + referrer : ""));
    }

    private ModuleInfo findModuleInfo(String cnb) throws BuildException {
        for (ModuleInfo info : this.modules) {
            if (!info.codebasename.equals(cnb)) continue;
            return info;
        }
        return null;
    }

    private static void addDependencies(TreeSet<Dependency> addTo, Manifest man, int dependencyType, String attrName) throws BuildException {
        String value = man.getMainAttributes().getValue(attrName);
        if (value == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(value, ",");
        while (tok.hasMoreElements()) {
            String nextDep = tok.nextToken();
            StringTokenizer dep = new StringTokenizer(nextDep, "=>", true);
            if (dep.countTokens() == 1) {
                addTo.add(new Dependency(dep.nextToken().trim(), dependencyType, false, null));
                continue;
            }
            if (dep.countTokens() == 3) {
                String name = dep.nextToken().trim();
                String equal = dep.nextToken().trim();
                String comp = dep.nextToken().trim();
                addTo.add(new Dependency(name, dependencyType, equal.equals("="), comp));
                continue;
            }
            throw new BuildException("Cannot parse dependency: " + value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Dependency
    implements Comparable<Dependency> {
        public static final int PROVIDES = 1;
        public static final int REQUIRES = 2;
        public final String token;
        public final int majorVersionFrom;
        public final int majorVersionTo;
        public final int type;
        public final boolean exact;
        public final String compare;

        public Dependency(String token, int type, boolean exact, String compare) {
            int slash = token.indexOf(47);
            if (slash == -1) {
                this.token = token;
                this.majorVersionFrom = -1;
                this.majorVersionTo = -1;
            } else {
                this.token = token.substring(0, slash);
                String major = token.substring(slash + 1);
                int range = major.indexOf(45);
                if (range == -1) {
                    this.majorVersionTo = this.majorVersionFrom = Integer.valueOf(major).intValue();
                } else {
                    this.majorVersionFrom = Integer.valueOf(major.substring(0, range));
                    this.majorVersionTo = Integer.valueOf(major.substring(range + 1));
                }
            }
            this.type = type;
            this.exact = exact;
            this.compare = compare;
        }

        @Override
        public int compareTo(Dependency m) {
            return this.token.compareTo(m.token);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Dependency) {
                return this.token.equals(((Dependency)obj).token);
            }
            return false;
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public boolean isSpecial() {
            return this.token.startsWith("org.openide.modules.os") || this.token.startsWith("org.openide.modules.ModuleFormat");
        }

        public boolean isDependingOn(ModuleInfo info) {
            if (info.codebasename.equals(this.token)) {
                return !(this.majorVersionFrom != -1 && this.majorVersionFrom > info.majorVersion || this.majorVersionTo != -1 && info.majorVersion > this.majorVersionTo);
            }
            for (Dependency d : info.provides) {
                if (!d.equals(this)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.token;
        }

        public String toString() {
            String t;
            switch (this.type) {
                case 2: {
                    t = "requires ";
                    break;
                }
                case 1: {
                    t = "provides ";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + this.type);
                }
            }
            return "Dependency[" + t + this.getName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ModuleInfo
    implements Comparable<ModuleInfo> {
        public final String group;
        public final File file;
        public final String codebasename;
        public String publicPackages;
        public Set<String> friends;
        public int majorVersion;
        public String specificationVersion;
        public String implementationVersion;
        public Set<Dependency> depends;
        public Set<Dependency> provides;
        public boolean showInAutoupdate;
        public boolean isEssential;
        public boolean isAutoload;
        public boolean isEager;

        public ModuleInfo(String g, File f, String a) {
            this.group = g;
            this.file = f;
            this.codebasename = a;
        }

        @Override
        public int compareTo(ModuleInfo m) {
            return this.codebasename.compareTo(m.codebasename);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModuleInfo) {
                return this.codebasename.equals(((ModuleInfo)obj).codebasename);
            }
            return false;
        }

        public int hashCode() {
            return this.codebasename.hashCode();
        }

        public String getName(boolean includeMajorVersion) {
            if (!includeMajorVersion || this.majorVersion == -1) {
                return this.codebasename + " (" + this.group + ")";
            }
            return this.codebasename + "/" + this.majorVersion + " (" + this.group + ")";
        }

        public String toString() {
            return "ModuleInfo[" + this.getName(false) + "]";
        }
    }

    public static final class OutputType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"public-packages", "friend-packages", "shared-packages", "modules", "dependencies", "implementation-dependencies", "group-dependencies", "group-implementation-dependencies", "group-friend-packages", "external-libraries", "kits", "kit-dependencies"};
        }
    }

    public static final class Output {
        public OutputType type;
        public File file;

        public void setType(OutputType type) {
            this.type = type;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    public static final class Input {
        public FileSet jars;
        public String name;

        public FileSet createJars() {
            if (this.jars != null) {
                throw new BuildException();
            }
            this.jars = new FileSet();
            return this.jars;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

