/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.ModuleListParser;
import org.netbeans.nbbuild.ParseProjectXml;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ModuleTestDependencies
extends Task {
    private File output;

    public void setOutput(File output) {
        this.output = output;
    }

    public void execute() throws BuildException {
        try {
            Hashtable props = this.getProject().getProperties();
            ModuleListParser mlp = new ModuleListParser(props, 0, this.getProject());
            TreeMap deps = new TreeMap();
            File nball = new File((String)props.get("nb_all"));
            for (ModuleListParser.Entry entry : mlp.findAll()) {
                Document pDoc;
                String myCnb = entry.getCnb();
                String myCluster = entry.getClusterName().replaceFirst("\\d+$", "");
                if (myCluster.equals("extra")) continue;
                String myCnbAndCluster = myCnb + " (" + myCluster + ")";
                File projectXml = new File(nball, (entry.getNetbeansOrgPath() + "/nbproject/project.xml").replace('/', File.separatorChar));
                Element config = this.getConfig(projectXml, pDoc = XMLUtil.parse(new InputSource(projectXml.toURI().toString()), false, true, null, null));
                Element td = ParseProjectXml.findNBMElement(config, "test-dependencies");
                if (td == null) continue;
                for (Element depGroup : XMLUtil.findSubElements(td)) {
                    String testType = ParseProjectXml.findTextOrNull(depGroup, "name");
                    if (testType != null && !testType.equals("unit")) continue;
                    for (Element dep : XMLUtil.findSubElements(depGroup)) {
                        String targetCnb;
                        if (ParseProjectXml.findNBMElement(dep, "test") == null || ParseProjectXml.findNBMElement(dep, "compile-dependency") == null || (targetCnb = ParseProjectXml.findTextOrNull(dep, "code-name-base")).equals(myCnb)) continue;
                        TreeSet<String> target = (TreeSet<String>)deps.get(myCnbAndCluster);
                        if (target == null) {
                            target = new TreeSet<String>();
                            deps.put(myCnbAndCluster, target);
                        }
                        String targetCluster = mlp.findByCodeNameBase(targetCnb).getClusterName().replaceFirst("\\d+$", "");
                        target.add(targetCnb + " (" + targetCluster + ")");
                    }
                }
            }
            this.log("Generating test dependencies to " + this.output);
            PrintWriter pw = new PrintWriter(this.output);
            for (Map.Entry entry : deps.entrySet()) {
                pw.printf("MODULE %s\n", entry.getKey());
                for (String dep : (SortedSet)entry.getValue()) {
                    pw.printf("  REQUIRES %s\n", dep);
                }
            }
            pw.flush();
            pw.close();
        }
        catch (Exception x) {
            throw new BuildException((Throwable)x);
        }
    }

    private Element getConfig(File projectXml, Document pDoc) throws BuildException {
        Element e = pDoc.getDocumentElement();
        Element c = XMLUtil.findElement(e, "configuration", "http://www.netbeans.org/ns/project/1");
        if (c == null) {
            throw new BuildException("No <configuration>", this.getLocation());
        }
        Element d = ParseProjectXml.findNBMElement(c, "data");
        if (d == null) {
            throw new BuildException("No <data> in " + projectXml, this.getLocation());
        }
        return d;
    }
}

