/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.UpdateTracking;

public class NbMerge
extends Task {
    private File dest;
    private Vector<String> modules = new Vector();
    private Vector<String> buildmodules = new Vector();
    private Vector<String> fixedmodules = new Vector();
    private Vector<String> buildfixedmodules = new Vector();
    private Vector<String> failedmodules = new Vector();
    private Vector<String> builtmodules = new Vector();
    private Vector<String> mergemodules = new Vector();
    private Vector<String> builttargets = new Vector();
    private String targetprefix = "all-";
    private List<File> topdirs = new ArrayList<File>();
    private List<Suppress> suppress = new LinkedList<Suppress>();
    private boolean failonerror = true;
    private boolean mergedependentmodules = false;
    private String dummyName;
    private Target dummy;
    private Hashtable targets;
    private String builtmodulesproperty = "";

    public void setDest(File f) {
        this.dest = f;
    }

    public void setFailOnError(boolean b) {
        this.failonerror = b;
    }

    public void setBuiltModulesProperty(String s) {
        this.builtmodulesproperty = s;
    }

    public void setMergeDependentModules(boolean b) {
        this.mergedependentmodules = b;
    }

    public void setFixedModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.fixedmodules = new Vector();
        while (tok.hasMoreTokens()) {
            this.fixedmodules.addElement(tok.nextToken());
        }
    }

    public void setModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.modules = new Vector();
        while (tok.hasMoreTokens()) {
            this.modules.addElement(tok.nextToken());
        }
    }

    public void setTargetprefix(String s) {
        this.targetprefix = s;
    }

    public void setTopdir(File t) {
        this.topdirs.add(t);
    }

    public Topdir createTopdir() {
        return new Topdir();
    }

    public Suppress createSuppress() {
        Suppress s = new Suppress();
        this.suppress.add(s);
        return s;
    }

    private void fixedModulesBuild() throws BuildException {
        this.dummy = new Target();
        this.dummyName = "nbmerge-" + this.getOwningTarget().getName();
        this.targets = this.getProject().getTargets();
        while (this.targets.contains(this.dummyName)) {
            this.dummyName = this.dummyName + "-x";
        }
        this.dummy.setName(this.dummyName);
        for (String fixedmodule : this.buildfixedmodules) {
            this.dummy.addDependency(this.targetprefix + fixedmodule);
        }
        this.getProject().addTarget(this.dummy);
        this.getProject().setProperty("fixedmodules-built", "1");
        Vector fullList = this.getProject().topoSort(this.dummyName, this.targets);
        Vector doneList = this.getProject().topoSort(this.getOwningTarget().getName(), this.targets);
        ArrayList todo = new ArrayList(fullList.subList(0, fullList.indexOf(this.dummy)));
        todo.removeAll(doneList.subList(0, doneList.indexOf(this.getOwningTarget())));
        this.log("Going to execute targets " + todo);
        for (Target nexttargit : todo) {
            String targetname = nexttargit.getName();
            if (this.builttargets.indexOf(targetname) >= 0) continue;
            System.out.println("");
            System.out.println(targetname + ":");
            try {
                nexttargit.execute();
            }
            catch (BuildException ex) {
                this.log("Failed to build target: " + targetname, 0);
                throw ex;
            }
            this.builttargets.addElement(targetname);
        }
        this.builtmodules.addAll(this.buildfixedmodules);
        this.log("fixedmodules=" + this.buildfixedmodules, 4);
        this.log("builtmodules=" + this.builtmodules, 3);
    }

    private void modulesBuild() throws BuildException {
        if (!this.failonerror) {
            for (String module : this.buildmodules) {
                this.dummy = new Target();
                this.dummyName = "nbmerge-" + this.getOwningTarget().getName() + "-" + module;
                while (this.targets.contains(this.dummyName)) {
                    this.dummyName = this.dummyName + "-x";
                }
                this.dummy.setName(this.dummyName);
                this.dummy.addDependency(this.targetprefix + module);
                this.getProject().addTarget(this.dummy);
                Vector fullList = this.getProject().topoSort(this.dummyName, this.targets);
                Vector doneList = this.getProject().topoSort(this.getOwningTarget().getName(), this.targets);
                ArrayList todo = new ArrayList(fullList.subList(0, fullList.indexOf(this.dummy)));
                todo.removeAll(doneList.subList(0, doneList.indexOf(this.getOwningTarget())));
                Iterator targit = todo.iterator();
                try {
                    while (targit.hasNext()) {
                        Target nexttargit = (Target)targit.next();
                        String targetname = nexttargit.getName();
                        if (this.builttargets.indexOf(targetname) >= 0) continue;
                        System.out.println();
                        System.out.println(targetname + ":");
                        nexttargit.execute();
                        this.builttargets.addElement(targetname);
                    }
                    this.builtmodules.addElement(module);
                }
                catch (BuildException BE) {
                    this.log(BE.toString(), 1);
                    BE.printStackTrace();
                    this.failedmodules.addElement(module);
                }
            }
            this.log("builtmodules=" + this.builtmodules, 3);
            this.log("failedmodules=" + this.failedmodules, 3);
        }
    }

    public void execute() throws BuildException {
        if (this.topdirs.isEmpty()) {
            throw new BuildException("You must set at least one topdir attribute", this.getLocation());
        }
        this.buildfixedmodules.addAll(this.fixedmodules);
        this.buildmodules.addAll(this.modules);
        if (this.modules.size() > 0 && this.fixedmodules.size() == 0 && !this.failonerror) {
            this.log("Unable to build without fixedmodules set", 1);
            this.log("Swapping modules list with fixedmodules list", 1);
            this.buildfixedmodules.addAll(this.modules);
            this.buildmodules.removeAllElements();
        }
        if (this.failonerror && this.modules.size() > 0) {
            this.buildfixedmodules.addAll(this.modules);
            this.buildmodules.removeAllElements();
        }
        this.fixedModulesBuild();
        this.modulesBuild();
        this.dataMerge();
        if (this.builtmodules.size() > 0) {
            this.log("builtmodules=" + this.builtmodules);
            this.log("builttargets=" + this.builttargets);
            if (this.failedmodules.size() > 0) {
                this.log("SOME MODULES FAILED TO BUILD, BUT THEIR BuildException WAS CAUGHT.", 1);
                this.log("failedmodules=" + this.failedmodules, 1);
            }
            if (this.mergemodules.size() > 0 && this.builtmodulesproperty.length() > 0) {
                Vector<String> setmodules = new Vector<String>();
                setmodules.addAll(this.mergemodules);
                setmodules.removeAll(this.fixedmodules);
                if (!this.modules.containsAll(setmodules) || !setmodules.containsAll(this.modules)) {
                    String bm = setmodules.toString();
                    if ((bm = bm.substring(1, bm.length() - 1)).length() > 0) {
                        this.log("Setting property \"" + this.builtmodulesproperty + "\" to new value " + bm);
                        this.getProject().setUserProperty(this.builtmodulesproperty, bm);
                    }
                }
            }
        } else {
            throw new BuildException("No modules were built", this.getLocation());
        }
    }

    private void dataMerge() throws BuildException {
        LinkedList<String> suppressedlocales = new LinkedList<String>();
        Iterator<Suppress> it = this.suppress.iterator();
        while (it.hasNext()) {
            Suppress s = it.next();
            if (s.iftest != null && this.getProject().getProperty(s.iftest) == null || s.unlesstest != null && this.getProject().getProperty(s.unlesstest) != null) continue;
            this.log("Suppressing locale: " + s.locale);
            suppressedlocales.add(s.locale);
        }
        UpdateTracking tr = new UpdateTracking(this.dest.getAbsolutePath());
        this.log(this.dest.getAbsolutePath());
        while (it.hasNext()) {
            String locale = (String)((Object)it.next());
            tr.removeLocalized(locale);
        }
    }

    public class Suppress {
        String locale;
        String iftest;
        String unlesstest;

        public void setLocale(String l) {
            this.locale = l;
        }

        public void setIf(String p) {
            this.iftest = p;
        }

        public void setUnless(String p) {
            this.unlesstest = p;
        }
    }

    public class Topdir {
        public void setPath(File t) {
            NbMerge.this.topdirs.add(t);
        }
    }
}

