/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintIcon
extends Task {
    private FileSet first;
    private FileSet second;
    private File duplicates;
    private File difference;

    public void setDuplicates(File f) {
        this.duplicates = f;
    }

    public void setDifference(File f) {
        this.difference = f;
    }

    public FileSet createFirstPool() {
        if (this.first != null) {
            throw new BuildException();
        }
        this.first = new FileSet();
        return this.first;
    }

    public FileSet createSecondPool() {
        if (this.second != null) {
            throw new BuildException();
        }
        this.second = new FileSet();
        return this.second;
    }

    public void execute() throws BuildException {
        if (this.first == null) {
            throw new BuildException("You need to specify firstpool element for this task!");
        }
        try {
            TreeSet<IconInfo> firstSet = new TreeSet<IconInfo>();
            for (String f : this.first.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                File baseDir = this.first.getDir(this.getProject());
                File file = new File(baseDir, f);
                firstSet.add(new IconInfo(file.toURI().toURL(), this.getProject()));
            }
            TreeSet<IconInfo> sndSet = new TreeSet<IconInfo>();
            if (this.second != null) {
                for (String f : this.second.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                    File baseDir = this.second.getDir(this.getProject());
                    File file = new File(baseDir, f);
                    sndSet.add(new IconInfo(file.toURI().toURL(), this.getProject()));
                }
            }
            if (this.duplicates != null) {
                TreeSet<IconInfo> both = new TreeSet<IconInfo>((SortedSet<IconInfo>)firstSet);
                both.addAll(sndSet);
                BufferedWriter os = new BufferedWriter(new FileWriter(this.duplicates));
                IconInfo prev = null;
                boolean prevPrinted = false;
                for (IconInfo info : both) {
                    IconInfo p = prev;
                    prev = info;
                    if (p == null || p.hash != info.hash) {
                        prevPrinted = false;
                        continue;
                    }
                    if (!prevPrinted) {
                        os.write(p.toString());
                        os.newLine();
                        prevPrinted = true;
                    }
                    os.write(info.toString());
                    os.newLine();
                }
                os.close();
            }
            if (this.difference != null) {
                TreeSet<IconInfo> union = new TreeSet<IconInfo>((SortedSet<IconInfo>)firstSet);
                union.addAll(sndSet);
                BufferedWriter os = new BufferedWriter(new FileWriter(this.difference));
                for (IconInfo info : union) {
                    if (!PrintIcon.contains(firstSet, info.hash)) {
                        os.write(43);
                        os.write(info.toString());
                        os.newLine();
                        continue;
                    }
                    if (PrintIcon.contains(sndSet, info.hash)) continue;
                    os.write(45);
                    os.write(info.toString());
                    os.newLine();
                }
                os.close();
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private static boolean contains(SortedSet<IconInfo> set, int hashCode) {
        IconInfo fake = new IconInfo("", "", hashCode);
        SortedSet<IconInfo> greaterOrEqual = set.tailSet(fake);
        if (greaterOrEqual.isEmpty()) {
            return false;
        }
        IconInfo first = (IconInfo)greaterOrEqual.iterator().next();
        return hashCode == first.hash;
    }

    static final int hash(Throwable t) {
        String msg = t.getMessage();
        if (msg != null) {
            return 7 + msg.hashCode();
        }
        return 5 + t.getClass().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IconInfo
    implements Comparable<IconInfo> {
        final String name;
        final String path;
        final int hash;

        public IconInfo(URL from, Project p) throws IOException {
            int hash;
            this.path = from.toExternalForm();
            int last = this.path.lastIndexOf(47);
            assert (last >= 0);
            this.name = this.path.substring(last + 1);
            p.log("Parsing " + from, 3);
            try {
                InputStream is = from.openStream();
                BufferedImage image = ImageIO.read(is);
                is.close();
                int w = image.getWidth();
                int h = image.getHeight();
                hash = w * 3 + h * 7;
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < h; ++j) {
                        int rgb = image.getRGB(i, j);
                        hash += rgb >> 2;
                    }
                }
            }
            catch (IOException e) {
                p.log("Broken icon at " + from, 1);
                hash = PrintIcon.hash(e);
            }
            catch (IndexOutOfBoundsException ex) {
                p.log("Broken icon at " + from, 1);
                hash = PrintIcon.hash(ex);
            }
            this.hash = hash;
        }

        public IconInfo(String name, String path, int hash) {
            this.name = name;
            this.path = path;
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IconInfo other = (IconInfo)obj;
            if (!(this.path == other.path || this.path != null && this.path.equals(other.path))) {
                return false;
            }
            return this.hash == other.hash;
        }

        @Override
        public int compareTo(IconInfo another) {
            if (this.hash != another.hash) {
                return this.hash - another.hash;
            }
            return this.path.compareTo(another.path);
        }

        public String toString() {
            String n;
            String h = Integer.toHexString(this.hash);
            if (h.length() < 8) {
                h = "00000000".substring(h.length()) + h;
            }
            if ((n = this.name).length() < 30) {
                n = n + "                              ".substring(n.length());
            }
            return MessageFormat.format("{0} {1} {2}", h, n, this.path);
        }
    }
}

