/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.ModuleListParser;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RefreshDependencyVersions
extends Task {
    private File nbroot;
    private String codenameBase;
    private String release;
    private String specification;
    private boolean dryRun = false;
    private final Set<Dep> injectDeps = new HashSet<Dep>();

    public void setNbroot(File f) {
        this.nbroot = f;
    }

    public void setModule(String codenameBase) {
        this.codenameBase = codenameBase;
    }

    public void setRelease(String release) {
        this.release = release == null || release.length() == 0 ? null : release;
    }

    public void setSpecification(String specification) {
        this.specification = specification == null || specification.length() == 0 ? null : specification;
    }

    public void setDryRun(boolean b) {
        this.dryRun = b;
    }

    public Dep createInject() {
        Dep dep = new Dep();
        this.injectDeps.add(dep);
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        String path;
        ModuleListParser listParser;
        if (this.nbroot == null || this.codenameBase == null) {
            throw new BuildException("Missing params 'nbroot' or 'modules'", this.getLocation());
        }
        this.log("RefreshDependencyVersions parameters: nbroot = '" + this.nbroot.getAbsolutePath() + "'" + ", module = " + this.codenameBase + ", dryrun = " + this.dryRun + ", inject = " + this.injectDeps, 3);
        this.validateInjectedDependencies(this.injectDeps);
        Hashtable properties = this.getProject().getProperties();
        try {
            listParser = new ModuleListParser(properties, 0, this.getProject());
        }
        catch (IOException ioe) {
            throw new BuildException("Can't read module list!", (Throwable)ioe, this.getLocation());
        }
        Set<ModuleListParser.Entry> allModules = listParser.findAll();
        Dep sourceModuleVersion = null;
        for (ModuleListParser.Entry moduleEntry : allModules) {
            path = moduleEntry.getNetbeansOrgPath();
            File projectDir = new File(this.nbroot, path.replace('/', File.separatorChar));
            if (!projectDir.isDirectory()) {
                this.log("No such directory " + projectDir + "; skipping", 1);
                continue;
            }
            Dep mv = this.loadDepFrom(projectDir);
            if (mv == null) {
                this.log("Not a module: " + projectDir + ", skipping!", 1);
                continue;
            }
            this.log("Loading module versions: " + mv.getCodenameBase() + ", release = " + mv.getRelease() + ", spec = " + mv.getSpecification(), 3);
            if (!this.codenameBase.equals(mv.getCodenameBase())) continue;
            if (mv.getRelease() == null) {
                throw new BuildException("Unknown release version of '" + this.codenameBase + "'.", this.getLocation());
            }
            if (mv.getSpecification() == null) {
                throw new BuildException("Unknown specification version of '" + this.codenameBase + "'.", this.getLocation());
            }
            if (this.release != null && RefreshDependencyVersions.compare(mv.getRelease(), this.release) < 0) {
                throw new BuildException("Release version of '" + this.codenameBase + "' is " + mv.getRelease() + ". Requested to update to " + this.release, this.getLocation());
            }
            if (this.specification != null && RefreshDependencyVersions.compare(mv.getSpecification(), this.specification) < 0) {
                throw new BuildException("Specification version of '" + this.codenameBase + "' is " + mv.getSpecification() + ". Requested to update to " + this.specification, this.getLocation());
            }
            sourceModuleVersion = mv;
            break;
        }
        if (sourceModuleVersion == null) {
            throw new BuildException("Can't find '" + this.codenameBase + "' module!", this.getLocation());
        }
        block13: for (ModuleListParser.Entry moduleEntry : allModules) {
            StringBuilder injectMsg;
            StringBuilder refreshMsg;
            File projectFile;
            block36: {
                path = moduleEntry.getNetbeansOrgPath();
                projectFile = new File(new File(this.nbroot, path.replace('/', File.separatorChar)), "nbproject" + File.separatorChar + "project.xml");
                if (!projectFile.exists()) {
                    this.log("Non-existent project.xml: " + path + ", skipping!", 1);
                }
                Document nbprj = null;
                try {
                    FileInputStream is = new FileInputStream(projectFile);
                    try {
                        nbprj = XMLUtil.parse(new InputSource(is), false, true, null, null);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception ioe) {
                    throw new BuildException("Can't parse " + projectFile, (Throwable)ioe, this.getLocation());
                }
                Node cnb = RefreshDependencyVersions.findChild(RefreshDependencyVersions.findChild(RefreshDependencyVersions.findChild(nbprj.getDocumentElement(), "configuration"), "data"), "code-name-base");
                if (cnb.getTextContent().equals(this.codenameBase)) {
                    this.log("Won't touch dependencies of the source module (" + this.codenameBase + ")", 3);
                    continue;
                }
                for (Dep inject : this.injectDeps) {
                    if (!cnb.getTextContent().equals(inject.getCodenameBase())) continue;
                    this.log("Won't touch dependencies of the injected module (" + inject.getCodenameBase() + ")", 3);
                    continue block13;
                }
                boolean updated = false;
                refreshMsg = new StringBuilder();
                injectMsg = new StringBuilder();
                Node sourceDep = RefreshDependencyVersions.findDependencyFor(nbprj, this.codenameBase);
                if (sourceDep != null) {
                    Node sourceImplementation;
                    Node sourceSpecification;
                    Node sourceRelease;
                    boolean compareSpecification = true;
                    if (this.release != null && (sourceRelease = RefreshDependencyVersions.findChild(RefreshDependencyVersions.findChild(sourceDep, "run-dependency"), "release-version")) != null && sourceRelease.getTextContent().length() > 0) {
                        int c = RefreshDependencyVersions.compare(sourceRelease.getTextContent(), this.release);
                        if (c > 0) continue;
                        if (c < 0) {
                            compareSpecification = false;
                        }
                    }
                    if (compareSpecification && this.specification != null && ((sourceSpecification = RefreshDependencyVersions.findChild(RefreshDependencyVersions.findChild(sourceDep, "run-dependency"), "specification-version")) != null && sourceSpecification.getTextContent().length() > 0 ? RefreshDependencyVersions.compare(sourceSpecification.getTextContent(), this.specification) >= 0 : (sourceImplementation = RefreshDependencyVersions.findChild(RefreshDependencyVersions.findChild(sourceDep, "run-dependency"), "implementation-version")) != null)) continue;
                    updated |= RefreshDependencyVersions.updateVersions(sourceDep, sourceModuleVersion, false, refreshMsg);
                    for (Dep inject : this.injectDeps) {
                        Node injectedDep;
                        if (injectMsg.length() > 0) {
                            injectMsg.append(", ");
                        }
                        if ((injectedDep = RefreshDependencyVersions.findDependencyFor(nbprj, inject.getCodenameBase())) != null) {
                            updated |= RefreshDependencyVersions.updateVersions(injectedDep, inject, true, injectMsg);
                            continue;
                        }
                        this.addDependency(sourceDep.getParentNode(), inject, injectMsg);
                        updated = true;
                    }
                }
                if (updated) {
                    try {
                        if (!this.dryRun) {
                            FileOutputStream os = new FileOutputStream(projectFile);
                            try {
                                XMLUtil.write(nbprj, (OutputStream)os);
                                break block36;
                            }
                            finally {
                                ((OutputStream)os).close();
                            }
                        }
                        if (!projectFile.canWrite()) {
                            this.log("Would need to update " + projectFile + ", but it's readonly!", 0);
                        }
                    }
                    catch (IOException ioe) {
                        throw new BuildException("Can't write " + projectFile, (Throwable)ioe, this.getLocation());
                    }
                }
            }
            if (refreshMsg.length() > 0) {
                this.log("Dependencies refreshed in " + projectFile.getAbsolutePath() + ": " + refreshMsg.toString(), 2);
            }
            if (injectMsg.length() <= 0) continue;
            this.log("Dependencies injected to " + projectFile.getAbsolutePath() + ": " + injectMsg.toString(), 2);
        }
    }

    private static Node findChild(Node node, String childName) {
        NodeList kids = node.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            if (!kids.item(i).getNodeName().equals(childName)) continue;
            return kids.item(i);
        }
        return null;
    }

    private static Node findDependencyFor(Document nbprj, String codenameBase) {
        NodeList allDeps = nbprj.getElementsByTagName("dependency");
        for (int i = 0; i < allDeps.getLength(); ++i) {
            Node dep = allDeps.item(i);
            Node cnb = RefreshDependencyVersions.findChild(dep, "code-name-base");
            if (!cnb.getTextContent().equals(codenameBase)) continue;
            return dep;
        }
        return null;
    }

    private static boolean updateVersions(Node dep, Dep sourceDep, boolean injecting, StringBuilder log) {
        StringBuilder s = new StringBuilder();
        Node runDep = RefreshDependencyVersions.findChild(dep, "run-dependency");
        if (injecting) {
            Node compileDep;
            Node buildPrerequisite = RefreshDependencyVersions.findChild(dep, "build-prerequisite");
            if (buildPrerequisite == null) {
                buildPrerequisite = dep.getOwnerDocument().createElement("build-prerequisite");
                dep.appendChild(buildPrerequisite);
                s.append(" adding <build-prerequisite/>");
            }
            if ((compileDep = RefreshDependencyVersions.findChild(dep, "compile-dependency")) == null) {
                compileDep = dep.getOwnerDocument().createElement("compile-dependency");
                dep.appendChild(compileDep);
                s.append(" adding <compile-dependency/>");
            }
            if (runDep == null) {
                runDep = dep.getOwnerDocument().createElement("run-dependency");
                dep.appendChild(runDep);
                s.append(" adding <run-dependency/>");
            }
        }
        if (runDep != null) {
            Node releaseVersion = RefreshDependencyVersions.findChild(runDep, "release-version");
            if (releaseVersion != null && sourceDep.getRelease() != null) {
                String nue = RefreshDependencyVersions.checkReleaseVersion(sourceDep.getRelease());
                if (!releaseVersion.getTextContent().equals(nue)) {
                    releaseVersion.setTextContent(nue);
                    s.append(" release = ").append(nue);
                }
            }
            Node specVersion = RefreshDependencyVersions.findChild(runDep, "specification-version");
            if (!injecting) {
                Node implVersion;
                assert (sourceDep.getSpecification() != null) : "Need specification version when refreshing dependencies";
                if (specVersion == null && (implVersion = RefreshDependencyVersions.findChild(runDep, "implementation-version")) == null) {
                    specVersion = dep.getOwnerDocument().createElement("specification-version");
                    specVersion.setTextContent("");
                    runDep.appendChild(specVersion);
                }
                if (specVersion != null) {
                    String nue = RefreshDependencyVersions.checkSpecificationVersion(sourceDep.getSpecification());
                    if (!specVersion.getTextContent().equals(nue)) {
                        specVersion.setTextContent(nue);
                        s.append(" spec = ").append(nue);
                    }
                }
            } else {
                Node implVersion = RefreshDependencyVersions.findChild(runDep, "implementation-version");
                if (sourceDep.isImplementation()) {
                    if (specVersion != null) {
                        runDep.removeChild(specVersion);
                        s.append(" removing spec = " + specVersion.getTextContent());
                    }
                    if (implVersion == null) {
                        implVersion = dep.getOwnerDocument().createElement("implementation-version");
                        runDep.appendChild(implVersion);
                        s.append(" adding impl");
                    }
                } else {
                    if (sourceDep.getSpecification() != null) {
                        String nue = RefreshDependencyVersions.checkSpecificationVersion(sourceDep.getSpecification());
                        if (specVersion == null) {
                            specVersion = dep.getOwnerDocument().createElement("specification-version");
                            specVersion.setTextContent(nue);
                            runDep.appendChild(specVersion);
                            s.append(" adding spec = ").append(nue);
                        } else if (!specVersion.getTextContent().equals(nue)) {
                            specVersion.setTextContent(nue);
                            s.append(" updating spec = ").append(nue);
                        }
                    }
                    if (implVersion != null) {
                        runDep.removeChild(implVersion);
                        s.append(" removing impl");
                    }
                }
            }
        }
        log.append(sourceDep.getCodenameBase()).append(':');
        if (s.length() > 0) {
            log.append((CharSequence)s);
            return true;
        }
        log.append(" up-to-date");
        return false;
    }

    private void addDependency(Node moduleDependencies, Dep inject, StringBuilder log) {
        Document nbprj = moduleDependencies.getOwnerDocument();
        Element nueDep = nbprj.createElement("dependency");
        moduleDependencies.appendChild(nueDep);
        Element nueCnb = nbprj.createElement("code-name-base");
        nueCnb.setTextContent(inject.getCodenameBase());
        nueDep.appendChild(nueCnb);
        log.append(inject.getCodenameBase());
        Element nueBuildPrerequisite = nbprj.createElement("build-prerequisite");
        nueDep.appendChild(nueBuildPrerequisite);
        Element nueCompileDep = nbprj.createElement("compile-dependency");
        nueDep.appendChild(nueCompileDep);
        Element nueRunDep = nbprj.createElement("run-dependency");
        nueDep.appendChild(nueRunDep);
        Element nueRelease = nbprj.createElement("release-version");
        String nue = RefreshDependencyVersions.checkReleaseVersion(inject.getRelease());
        nueRelease.setTextContent(nue);
        nueRunDep.appendChild(nueRelease);
        log.append('/').append(nue);
        if (inject.isImplementation()) {
            nueRunDep.appendChild(nbprj.createElement("implementation-version"));
            log.append(" = impl");
        } else {
            Element nueSpec = nbprj.createElement("specification-version");
            nue = RefreshDependencyVersions.checkSpecificationVersion(inject.getSpecification());
            nueSpec.setTextContent(nue);
            nueRunDep.appendChild(nueSpec);
            log.append(" >= " + nue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] gulp(File file, String enc) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, enc));
            ArrayList<String> l = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                l.add(line);
            }
            String[] stringArray = l.toArray(new String[l.size()]);
            return stringArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void validateInjectedDependencies(Set<Dep> deps) throws BuildException {
        for (Dep dep : deps) {
            if (dep.getCodenameBase() == null || dep.getCodenameBase().length() == 0) {
                throw new BuildException("The 'codenamebase' attribute of injected dependency can't be empty.", this.getLocation());
            }
            if (dep.getRelease() == null || dep.getRelease().length() == 0) {
                throw new BuildException("The 'release' attribute of injected dependency can't be empty.", this.getLocation());
            }
            if (dep.isImplementation() || dep.getSpecification() != null && dep.getSpecification().length() != 0) continue;
            throw new BuildException("The 'specification' attribute of injected dependency can't be empty. Or implementation='true' must be specified.", this.getLocation());
        }
    }

    private static String checkReleaseVersion(String v) {
        if (v.equals("0")) {
            return "0-1";
        }
        return v;
    }

    private static String checkSpecificationVersion(String v) {
        if (v.endsWith(".0") && v.indexOf(46) != v.length() - 2) {
            v = v.substring(0, v.length() - 2);
        }
        return v;
    }

    private Dep loadDepFrom(File projectDir) throws BuildException {
        Dep dep = new Dep();
        try {
            File mf;
            File pp = new File(projectDir, "nbproject" + File.separatorChar + "project.properties");
            if (pp.isFile()) {
                String[] lines = RefreshDependencyVersions.gulp(pp, "ISO-8859-1");
                for (int i = 0; i < lines.length; ++i) {
                    Matcher m1 = Pattern.compile("(spec\\.version\\.base=)(.+)").matcher(lines[i]);
                    if (!m1.matches()) continue;
                    dep.setSpecification(m1.group(2));
                }
            } else if (!new File(projectDir, "nbproject" + File.separatorChar + "project.xml").isFile()) {
                this.log("No such file " + pp + "; unprojectized module?", 3);
                return null;
            }
            if ((mf = new File(projectDir, "manifest.mf")).isFile()) {
                String[] lines = RefreshDependencyVersions.gulp(mf, "UTF-8");
                for (int i = 0; i < lines.length; ++i) {
                    Matcher m1 = Pattern.compile("(OpenIDE-Module: )(.+)").matcher(lines[i]);
                    if (m1.matches()) {
                        String fullName = m1.group(2);
                        int idx = fullName.lastIndexOf(47);
                        if (idx != -1) {
                            dep.setCodenameBase(fullName.substring(0, idx));
                            dep.setRelease(fullName.substring(idx + 1));
                        } else {
                            dep.setCodenameBase(fullName);
                            dep.setCodenameBase("0");
                        }
                    }
                    if (!(m1 = Pattern.compile("(OpenIDE-Module-Specification-Version: )(.+)").matcher(lines[i])).matches()) continue;
                    dep.setSpecification(m1.group(2));
                }
                return dep;
            }
            this.log("No such file " + mf + "; not a real module?", 3);
            return null;
        }
        catch (IOException e) {
            throw new BuildException("While processing project files in " + projectDir + ": " + e, (Throwable)e, this.getLocation());
        }
    }

    private static int compare(String v1, String v2) {
        String[] v1arr = v1.split("\\.");
        String[] v2arr = v2.split("\\.");
        int len = Math.min(v1arr.length, v2arr.length);
        for (int i = 0; i < len; ++i) {
            int v2int;
            int v1int = RefreshDependencyVersions.str2ver(v1arr[i]);
            int result = v1int - (v2int = RefreshDependencyVersions.str2ver(v2arr[i]));
            if (result == 0) continue;
            return result;
        }
        return v1arr.length - v2arr.length;
    }

    private static int str2ver(String s) {
        int i = s.indexOf(45);
        if (i == -1) {
            return Integer.parseInt(s);
        }
        return Integer.parseInt(s.substring(0, i));
    }

    public static final class Dep {
        private String codenameBase;
        private String release;
        private String specification;
        private boolean implementation;

        public String getCodenameBase() {
            return this.codenameBase;
        }

        public void setCodenameBase(String codenameBase) {
            this.codenameBase = codenameBase == null || codenameBase.length() == 0 ? null : codenameBase;
        }

        public boolean isImplementation() {
            return this.implementation;
        }

        public void setImplementation(boolean implementation) {
            if (implementation && this.specification != null) {
                throw new IllegalArgumentException("Can't use implementation dependency when specification version is set.");
            }
            this.implementation = implementation;
        }

        public String getRelease() {
            return this.release;
        }

        public void setRelease(String release) {
            this.release = release == null || release.length() == 0 ? null : release;
        }

        public String getSpecification() {
            return this.specification;
        }

        public void setSpecification(String specification) {
            if (this.implementation && specification != null && specification.length() > 0) {
                throw new IllegalArgumentException("Can't specification version is set when using implementation dependency.");
            }
            this.specification = specification == null || specification.length() == 0 ? null : specification;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dep other = (Dep)obj;
            if (!(this.codenameBase == other.codenameBase || this.codenameBase != null && this.codenameBase.equals(other.codenameBase))) {
                return false;
            }
            if (!(this.release == other.release || this.release != null && this.release.equals(other.release))) {
                return false;
            }
            if (!(this.specification == other.specification || this.specification != null && this.specification.equals(other.specification))) {
                return false;
            }
            return this.implementation == other.implementation;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.codenameBase != null ? this.codenameBase.hashCode() : 0);
            hash = 79 * hash + (this.release != null ? this.release.hashCode() : 0);
            hash = 79 * hash + (this.specification != null ? this.specification.hashCode() : 0);
            hash = 79 * hash + (this.implementation ? 1 : 0);
            return hash;
        }

        public String toString() {
            if (this.specification != null) {
                return this.codenameBase + "/" + this.release + " >= " + this.specification;
            }
            return this.codenameBase + "/" + this.release + " = impl";
        }
    }
}

