/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SetCluster
extends Task {
    private String name = null;
    private String cluster;
    private String thisModuleName = null;
    private String defaultLocation = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public void setModule(String module) {
        this.thisModuleName = module;
    }

    public void setDefaultLocation(String defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("Name of property to set have to be specified", this.getLocation());
        }
        if (this.cluster != null) {
            String clusterDir = this.getProject().getProperty(this.cluster + ".dir");
            if (clusterDir == null) {
                throw new BuildException("Property: " + this.cluster + ".dir have to be defined", this.getLocation());
            }
            this.getProject().setProperty(this.name, clusterDir);
            return;
        }
        if (this.thisModuleName == null) {
            throw new BuildException("The name of current module have to be set", this.getLocation());
        }
        HashMap<String, String> clusterByModule = new HashMap<String, String>();
        for (Object key : this.getProject().getProperties().keySet()) {
            String property = (String)key;
            String clusterDir = this.getProject().getProperty(property + ".dir");
            if (clusterDir == null) continue;
            String list = this.getProject().getProperty(property);
            assert (list != null) : property;
            HashSet<String> modules = new HashSet<String>();
            StringTokenizer modTokens = new StringTokenizer(list, " \t\n\f\r,");
            while (modTokens.hasMoreTokens()) {
                String module = modTokens.nextToken();
                if (module.equals(this.thisModuleName)) {
                    this.log("Property: " + this.name + " will be set to " + clusterDir, 3);
                    this.getProject().setProperty(this.name, clusterDir);
                    return;
                }
                String otherCluster = clusterByModule.put(module, clusterDir);
                if (otherCluster != null && !otherCluster.equals(clusterDir)) {
                    throw new BuildException("Module " + module + " found in two clusters: " + otherCluster + " and " + clusterDir, this.getLocation());
                }
                if (modules.add(module)) continue;
                throw new BuildException("Module " + module + " repeated in cluster definition " + property, this.getLocation());
            }
        }
        this.log("No cluster list with this module: " + this.thisModuleName + " was found. Using default cluster location: " + this.defaultLocation, 1);
        if (this.defaultLocation == null) {
            throw new BuildException("No default cluster location defined", this.getLocation());
        }
        this.log("Property: " + this.name + " will be set to " + this.defaultLocation, 3);
        this.getProject().setProperty(this.name, this.defaultLocation);
    }
}

