/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sigtest
extends Task {
    File fileName;
    Path classpath;
    String packages;
    ActionType action;
    File sigtestJar;
    File report;
    boolean failOnError = true;
    String version;

    public void setFileName(File f) {
        this.fileName = f;
    }

    public void setReport(File f) {
        this.report = f;
    }

    public void setPackages(String s) {
        this.packages = s;
    }

    public void setAction(ActionType s) {
        this.action = s;
    }

    public void setClasspath(Path p) {
        if (this.classpath == null) {
            this.classpath = p;
        } else {
            this.classpath.append(p);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void setSigtestJar(File f) {
        this.sigtestJar = f;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void execute() throws BuildException {
        if (this.fileName == null) {
            throw new BuildException("FileName has to filed", this.getLocation());
        }
        if (this.packages == null) {
            throw new BuildException("Packages has to filed", this.getLocation());
        }
        if (this.action == null) {
            throw new BuildException("Action has to filed", this.getLocation());
        }
        if (this.classpath == null) {
            throw new BuildException("Classpath has to filed", this.getLocation());
        }
        if (this.sigtestJar == null) {
            throw new BuildException("SigtestJar has to filed", this.getLocation());
        }
        if (this.packages.equals("-")) {
            this.log("No public packages, skipping");
            return;
        }
        if (!this.sigtestJar.exists()) {
            throw new BuildException("Cannot find JAR with testing infrastructure: " + this.sigtestJar);
        }
        try {
            ZipFile zip = new ZipFile(this.sigtestJar);
            String c2 = "org/netbeans/apitest/Sigtest.class";
            if (zip.getEntry(c2) != null) {
                this.log("Using " + c2 + " found in " + this.sigtestJar, 4);
                zip.close();
                try {
                    this.apitest();
                }
                catch (Exception ex) {
                    throw new BuildException((Throwable)ex);
                }
                return;
            }
            String c1 = "com/sun/tdk/signaturetest/Setup.class";
            if (zip.getEntry(c1) != null) {
                this.log("Using " + c1 + " found in " + this.sigtestJar, 4);
                zip.close();
                this.tdk();
                return;
            }
            zip.close();
            throw new BuildException("Cannot find " + c1 + " nor " + c2 + " in " + this.sigtestJar);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void tdk() {
        Java java = new Java();
        java.setProject(this.getProject());
        Path sigtestPath = new Path(this.getProject());
        sigtestPath.setLocation(this.sigtestJar);
        java.setClasspath(sigtestPath);
        String a = null;
        if ("strictcheck".equals(this.action.getValue())) {
            a = "SignatureTest";
        }
        if ("generate".equals(this.action.getValue())) {
            a = "Setup";
        }
        if (a == null) {
            throw new BuildException("Unsupported action " + (Object)((Object)this.action) + " use: strictcheck or generate");
        }
        java.setClassname("com.sun.tdk.signaturetest." + a);
        Commandline.Argument arg = java.createArg();
        arg.setValue("-FileName");
        arg = java.createArg();
        arg.setValue(this.fileName.getAbsolutePath());
        arg = java.createArg();
        arg.setValue("-Classpath");
        arg = java.createArg();
        Path extracp = new Path(this.getProject());
        extracp.add(this.classpath);
        FileSet jdk = new FileSet();
        jdk.setDir(new File(new File(System.getProperty("java.home")), "lib"));
        jdk.setIncludes("*.jar");
        extracp.addFileset(jdk);
        arg.setPath(extracp);
        File outputFile = null;
        String s = this.getProject().getProperty("sigtest.output.dir");
        if (s != null) {
            File dir = this.getProject().resolveFile(s);
            dir.mkdirs();
            outputFile = new File(dir, this.fileName.getName().replace(".sig", "").replace("-", "."));
            this.log(outputFile.toString());
            String email = this.getProject().getProperty("sigtest.mail");
            if (email != null) {
                try {
                    FileWriter w = new FileWriter(outputFile);
                    w.write("email: ");
                    w.write(email);
                    w.write("\n");
                    w.close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            java.setAppend(true);
            java.setOutput(outputFile);
            java.setFork(true);
        }
        arg = java.createArg();
        arg.setLine("-static");
        this.log("Packages: " + this.packages);
        StringTokenizer packagesTokenizer = new StringTokenizer(this.packages, ",");
        while (packagesTokenizer.hasMoreTokens()) {
            String p = packagesTokenizer.nextToken().trim();
            String prefix = "-PackageWithoutSubpackages ";
            int idx = p.lastIndexOf(".*");
            if (idx > 0) {
                p = p.substring(0, idx);
            } else {
                idx = p.lastIndexOf(".**");
                if (idx > 0) {
                    prefix = "-Package ";
                    p = p.substring(0, idx);
                }
            }
            arg = java.createArg();
            arg.setLine(prefix + p);
        }
        int returnCode = java.executeJava();
        if (returnCode != 95) {
            if (this.failOnError && outputFile == null) {
                throw new BuildException("Signature tests return code is wrong (" + returnCode + "), check the messages above. For more info see http://wiki.netbeans.org/wiki/view/SignatureTest", this.getLocation());
            }
            this.log("Signature tests return code is wrong (" + returnCode + "), check the messages above");
        } else if (outputFile != null) {
            outputFile.delete();
        }
    }

    private <T> void setM(Task task, String name, Class<? extends T> type, T value) throws Exception {
        this.log("Delegating " + name + " value: " + value, 4);
        task.getClass().getMethod(name, type).invoke((Object)task, value);
    }

    private <T> void setM(Task task, String string, T instance) throws Exception {
        this.setM(task, string, instance.getClass(), instance);
    }

    private <T> T getM(Task task, String name, Class<T> type) throws Exception {
        return type.cast(task.getClass().getMethod(name, new Class[0]).invoke((Object)task, new Object[0]));
    }

    private void apitest() throws Exception {
        URLClassLoader url = new URLClassLoader(new URL[]{this.sigtestJar.toURI().toURL()}, Sigtest.class.getClassLoader());
        Class<?> clazz = url.loadClass("org.netbeans.apitest.Sigtest");
        Task task = (Task)clazz.newInstance();
        task.setProject(this.getProject());
        task.setTaskName(this.getTaskName());
        this.setM(task, "setFailOnError", Boolean.TYPE, this.failOnError);
        this.setM(task, "setFileName", File.class, this.fileName);
        this.setM(task, "setReport", File.class, this.report);
        this.setM(task, "setPackages", String.class, this.packages);
        this.setM(task, "setVersion", String.class, this.version);
        Class<?> actionType = url.loadClass("org.netbeans.apitest.Sigtest$ActionType");
        this.setM(task, "setAction", EnumeratedAttribute.getInstance(actionType, (String)this.action.getValue()));
        Path path = this.getM(task, "createClasspath", Path.class);
        path.add(this.classpath);
        File outputFile = null;
        String s = this.getProject().getProperty("sigtest.output.dir");
        if (s != null) {
            File dir = this.getProject().resolveFile(s);
            dir.mkdirs();
            outputFile = new File(dir, this.fileName.getName().replace(".sig", "").replace("-", "."));
            this.log(outputFile.toString());
        }
        task.execute();
        if (outputFile != null) {
            outputFile.delete();
        }
    }

    public static final class ActionType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"generate", "check", "strictcheck", "binarycheck"};
        }
    }
}

