/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

public class SimpleMerge
extends Task {
    private File dest;
    private List<String> modules = new ArrayList<String>();
    private List<File> topdirs = new ArrayList<File>();
    private List<String> subdirs = new ArrayList<String>();

    public void setDest(File f) {
        this.dest = f;
    }

    public void setModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.modules = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            this.modules.add(tok.nextToken());
        }
    }

    public void setTopdir(File t) {
        this.topdirs.add(t);
    }

    public Topdir createTopdir() {
        return new Topdir();
    }

    public void setSubdir(String t) {
        this.subdirs.add(t);
    }

    public Subdir createSubdir() {
        return new Subdir();
    }

    public void execute() throws BuildException {
        if (this.topdirs.isEmpty()) {
            throw new BuildException("You must set at least one topdir attribute", this.getLocation());
        }
        if (this.subdirs.isEmpty()) {
            throw new BuildException("You must set at least one subdir attribute", this.getLocation());
        }
        this.log("Starting merge to " + this.dest.getAbsolutePath());
        for (File topdir : this.topdirs) {
            for (String module : this.modules) {
                for (String sdir : this.subdirs) {
                    File subdir = new File(new File(topdir, module), sdir);
                    if (!subdir.exists()) {
                        this.log("Dir " + subdir + " does not exist, skipping...", 1);
                        continue;
                    }
                    Copy copy = (Copy)this.getProject().createTask("copy");
                    FileSet fs = new FileSet();
                    fs.setDir(subdir);
                    copy.addFileset(fs);
                    copy.setTodir(this.dest);
                    copy.setIncludeEmptyDirs(true);
                    copy.init();
                    copy.setLocation(this.getLocation());
                    copy.execute();
                }
            }
        }
        this.log("Merge finished");
    }

    public class Subdir {
        public void setPath(String t) {
            SimpleMerge.this.subdirs.add(t);
        }
    }

    public class Topdir {
        public void setPath(File t) {
            SimpleMerge.this.topdirs.add(t);
        }
    }
}

