/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.ParseProjectXml;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortSuiteModules
extends Task {
    private boolean sortTests;
    private Path unsortedModules;
    private String sortedModulesProperty;

    public void setUnsortedModules(Path unsortedModules) {
        this.unsortedModules = unsortedModules;
    }

    public void setSortedModulesProperty(String sortedModulesProperty) {
        this.sortedModulesProperty = sortedModulesProperty;
    }

    public boolean isSortTests() {
        return this.sortTests;
    }

    public void setSortTests(boolean sortTests) {
        this.sortTests = sortTests;
    }

    public void execute() throws BuildException {
        List<String> cnbs;
        if (this.unsortedModules == null) {
            throw new BuildException("Must set unsortedModules");
        }
        if (this.sortedModulesProperty == null) {
            throw new BuildException("Must set sortedModulesProperty");
        }
        TreeMap<String, File> basedirsByCNB = new TreeMap<String, File>();
        HashMap buildDeps = new HashMap();
        for (String piece : this.unsortedModules.list()) {
            Element testDepsEl;
            Document doc;
            File d = new File(piece);
            File projectXml = new File(d, "nbproject" + File.separatorChar + "project.xml");
            if (!projectXml.isFile()) {
                throw new BuildException("Cannot open " + projectXml, this.getLocation());
            }
            try {
                doc = XMLUtil.parse(new InputSource(projectXml.toURI().toString()), false, true, null, null);
            }
            catch (IOException e) {
                throw new BuildException("Error parsing " + projectXml + ": " + e, (Throwable)e, this.getLocation());
            }
            catch (SAXException e) {
                throw new BuildException("Error parsing " + projectXml + ": " + e, (Throwable)e, this.getLocation());
            }
            Element config = XMLUtil.findElement(doc.getDocumentElement(), "configuration", "http://www.netbeans.org/ns/project/1");
            if (config == null) {
                throw new BuildException("Malformed project file " + projectXml, this.getLocation());
            }
            Element data = ParseProjectXml.findNBMElement(config, "data");
            if (data == null) {
                this.log("Skipping " + projectXml + " as it does not look like a module project", 1);
                continue;
            }
            Element cnbEl = ParseProjectXml.findNBMElement(data, "code-name-base");
            if (cnbEl == null) {
                throw new BuildException("Malformed project file " + projectXml, this.getLocation());
            }
            String cnb = XMLUtil.findText(cnbEl);
            basedirsByCNB.put(cnb, d);
            LinkedList<String> deps = new LinkedList<String>();
            Element depsEl = ParseProjectXml.findNBMElement(data, "module-dependencies");
            if (depsEl == null) {
                throw new BuildException("Malformed project file " + projectXml, this.getLocation());
            }
            for (Element dep : XMLUtil.findSubElements(depsEl)) {
                if (ParseProjectXml.findNBMElement(dep, "build-prerequisite") == null) continue;
                Element cnbEl2 = ParseProjectXml.findNBMElement(dep, "code-name-base");
                if (cnbEl2 == null) {
                    throw new BuildException("Malformed project file " + projectXml, this.getLocation());
                }
                String cnb2 = XMLUtil.findText(cnbEl2);
                deps.add(cnb2);
            }
            buildDeps.put(cnb, deps);
            if (!this.isSortTests() || (testDepsEl = ParseProjectXml.findNBMElement(data, "test-dependencies")) == null) continue;
            Iterator<Element> itTType = XMLUtil.findSubElements(testDepsEl).iterator();
            while (itTType.hasNext()) {
                for (Element dep : XMLUtil.findSubElements(itTType.next())) {
                    if (ParseProjectXml.findNBMElement(dep, "test") == null) continue;
                    Element cnbEl2 = ParseProjectXml.findNBMElement(dep, "code-name-base");
                    if (cnbEl2 == null) {
                        throw new BuildException("No cobase found for test-dependency");
                    }
                    String cnb2 = XMLUtil.findText(cnbEl2);
                    deps.add(cnb2);
                }
            }
        }
        for (List deps : buildDeps.values()) {
            deps.retainAll(basedirsByCNB.keySet());
        }
        HashMap<String, ArrayList<String>> reversedDeps = new HashMap<String, ArrayList<String>>();
        for (Map.Entry entry : buildDeps.entrySet()) {
            for (String from : (List)entry.getValue()) {
                String to = (String)entry.getKey();
                ArrayList<String> tos = (ArrayList<String>)reversedDeps.get(from);
                if (tos == null) {
                    tos = new ArrayList<String>();
                    reversedDeps.put(from, tos);
                }
                tos.add(to);
            }
        }
        try {
            cnbs = SortSuiteModules.topologicalSort(basedirsByCNB.keySet(), reversedDeps);
        }
        catch (TopologicalSortException x) {
            throw new BuildException(x.getMessage(), (Throwable)x, this.getLocation());
        }
        StringBuffer path = new StringBuffer();
        for (String cnb : cnbs) {
            assert (basedirsByCNB.containsKey(cnb));
            if (path.length() > 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(((File)basedirsByCNB.get(cnb)).getAbsolutePath());
        }
        this.getProject().setNewProperty(this.sortedModulesProperty, path.toString());
    }

    private static <T> List<T> topologicalSort(Collection<T> c, Map<? super T, ? extends Collection<? extends T>> edges) throws TopologicalSortException {
        HashMap finished = new HashMap();
        ArrayList r = new ArrayList(Math.max(c.size(), 1));
        ArrayList<T> cRev = new ArrayList<T>(c);
        Collections.reverse(cRev);
        Iterator it = cRev.iterator();
        while (it.hasNext()) {
            List<? super T> cycle = SortSuiteModules.visit(it.next(), edges, finished, r);
            if (cycle == null) continue;
            throw new TopologicalSortException(cRev, edges);
        }
        Collections.reverse(r);
        if (r.size() != c.size()) {
            r.retainAll(c);
        }
        return r;
    }

    private static <T> List<T> visit(T node, Map<? super T, ? extends Collection<? extends T>> edges, Map<T, Boolean> finished, List<T> r) {
        Boolean b = finished.get(node);
        if (b != null) {
            if (b.booleanValue()) {
                return null;
            }
            ArrayList<T> cycle = new ArrayList<T>();
            cycle.add(node);
            finished.put(node, null);
            return cycle;
        }
        Collection<T> e = edges.get(node);
        if (e != null) {
            finished.put(node, Boolean.FALSE);
            Iterator<T> it = e.iterator();
            while (it.hasNext()) {
                List<T> cycle = SortSuiteModules.visit(it.next(), edges, finished, r);
                if (cycle == null) continue;
                if (cycle instanceof ArrayList) {
                    if (Boolean.FALSE == finished.get(node)) {
                        cycle.add(node);
                    } else {
                        Collections.reverse(cycle);
                        cycle = Collections.unmodifiableList(cycle);
                    }
                }
                finished.put(node, Boolean.TRUE);
                return cycle;
            }
        }
        finished.put(node, Boolean.TRUE);
        r.add(node);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TopologicalSortException
    extends Exception {
        private Collection vertexes;
        private Map edges;
        private Set[] result;
        private int counter;
        private Stack<Vertex> dualGraph = new Stack();

        TopologicalSortException(Collection vertexes, Map edges) {
            this.vertexes = vertexes;
            this.edges = edges;
        }

        public final List partialSort() {
            Set[] all = this.topologicalSets();
            ArrayList res = new ArrayList(this.vertexes.size());
            for (int i = 0; i < all.length; ++i) {
                for (Object e : all[i]) {
                    res.add(e);
                }
            }
            return res;
        }

        public final Set[] unsortableSets() {
            Set[] all = this.topologicalSets();
            ArrayList<Set> unsort = new ArrayList<Set>();
            for (int i = 0; i < all.length; ++i) {
                if (all[i].size() <= 1 && all[i] instanceof HashSet) continue;
                unsort.add(all[i]);
            }
            return unsort.toArray(new Set[0]);
        }

        @Override
        public String getMessage() {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            this.printDebug(pw);
            pw.close();
            return w.toString();
        }

        @Override
        public String toString() {
            String s = this.getClass().getName();
            return s;
        }

        private void printDebug(PrintWriter w) {
            w.print("TopologicalSortException - Collection: ");
            w.print(this.vertexes);
            w.print(" with edges ");
            w.print(this.edges);
            w.println(" cannot be sorted");
            Set[] bad = this.unsortableSets();
            for (int i = 0; i < bad.length; ++i) {
                w.print(" Conflict #");
                w.print(i);
                w.print(": ");
                w.println(bad[i]);
            }
        }

        @Override
        public final void printStackTrace(PrintWriter w) {
            this.printDebug(w);
            super.printStackTrace(w);
        }

        @Override
        public final void printStackTrace(PrintStream s) {
            PrintWriter w = new PrintWriter(s);
            this.printStackTrace(w);
            w.flush();
        }

        /*
         * WARNING - void declaration
         */
        public final Set[] topologicalSets() {
            if (this.result != null) {
                return this.result;
            }
            HashMap<Object, Vertex> vertexInfo = new HashMap<Object, Vertex>();
            this.counter = 0;
            Iterator<Object> it = this.vertexes.iterator();
            while (it.hasNext()) {
                this.constructDualGraph(this.counter, it.next(), vertexInfo);
            }
            HashMap<Object, void> objectsToSets = new HashMap<Object, void>();
            ArrayList<void> sets = new ArrayList<void>();
            while (!this.dualGraph.isEmpty()) {
                void var6_6;
                Vertex v = this.dualGraph.pop();
                if (v.visited) continue;
                HashSet<Object> hashSet = new HashSet<Object>();
                this.visitDualGraph(v, hashSet);
                if (hashSet.size() == 1 && v.edgesFrom.contains(v)) {
                    Set<Object> set = Collections.singleton(v.object);
                }
                sets.add(var6_6);
                it = var6_6.iterator();
                while (it.hasNext()) {
                    objectsToSets.put(it.next(), var6_6);
                }
            }
            HashMap edgesBetweenSets = new HashMap();
            for (Map.Entry entry : this.edges.entrySet()) {
                Collection leadsTo = (Collection)entry.getValue();
                if (leadsTo == null || leadsTo.isEmpty()) continue;
                Set from = (Set)objectsToSets.get(entry.getKey());
                ArrayList<Set> setsTo = (ArrayList<Set>)edgesBetweenSets.get(from);
                if (setsTo == null) {
                    setsTo = new ArrayList<Set>();
                    edgesBetweenSets.put(from, setsTo);
                }
                Iterator convert = leadsTo.iterator();
                while (convert.hasNext()) {
                    Set to = (Set)objectsToSets.get(convert.next());
                    if (from == to) continue;
                    setsTo.add(to);
                }
            }
            try {
                List list = SortSuiteModules.topologicalSort(sets, edgesBetweenSets);
                this.result = list.toArray(new Set[0]);
            }
            catch (TopologicalSortException topologicalSortException) {
                throw new IllegalStateException("Cannot happen");
            }
            return this.result;
        }

        private Vertex constructDualGraph(int counter, Object vertex, HashMap<Object, Vertex> vertexInfo) {
            Vertex info = vertexInfo.get(vertex);
            if (info != null) {
                return info;
            }
            info = new Vertex(vertex, counter++);
            vertexInfo.put(vertex, info);
            Collection c = (Collection)this.edges.get(vertex);
            if (c != null) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    Vertex next = this.constructDualGraph(counter, it.next(), vertexInfo);
                    next.edgesFrom.add(info);
                }
            }
            info.y = counter++;
            this.dualGraph.push(info);
            return info;
        }

        private void visitDualGraph(Vertex vertex, Collection<Object> visited) {
            if (vertex.visited) {
                return;
            }
            visited.add(vertex.object);
            vertex.visited = true;
            Iterator it = vertex.edges();
            while (it.hasNext()) {
                Vertex v = (Vertex)it.next();
                this.visitDualGraph(v, visited);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Vertex
        implements Comparable<Vertex> {
            public Object object;
            public List<Vertex> edgesFrom = new ArrayList<Vertex>();
            public final int x;
            public int y;
            public boolean sorted;
            public boolean visited;

            public Vertex(Object obj, int x) {
                this.x = x;
                this.object = obj;
            }

            public Iterator edges() {
                if (!this.sorted) {
                    Collections.sort(this.edgesFrom);
                    this.sorted = true;
                }
                return this.edgesFrom.iterator();
            }

            @Override
            public int compareTo(Vertex o) {
                return o.y - this.y;
            }
        }
    }
}

