/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.JUnitReportWriter;

public class SubAntJUnitReport
extends Task {
    private Path buildPath;
    private String targetToRun;
    private boolean failOnError;
    private File report;

    public void setBuildPath(Path buildPath) {
        this.buildPath = buildPath;
    }

    public void setTarget(String target) {
        this.targetToRun = target;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setReport(File report) {
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        HashMap<String, String> pseudoTests = new HashMap<String, String>();
        for (String path : this.buildPath.list()) {
            this.log("Entering: " + path);
            File dir = new File(path);
            Ant ant = new Ant((Task)this);
            ant.init();
            ant.setTarget(this.targetToRun);
            ant.setDir(dir);
            final StringBuilder errors = new StringBuilder();
            BuildListener listener = new BuildListener(){
                String task = null;

                public void messageLogged(BuildEvent ev) {
                    if (this.task != null && ev.getPriority() <= 1) {
                        errors.append('\n').append(ev.getMessage());
                    }
                }

                public void taskStarted(BuildEvent ev) {
                    this.task = ev.getTask().getTaskName();
                }

                public void taskFinished(BuildEvent ev) {
                    this.task = null;
                }

                public void buildStarted(BuildEvent ev) {
                }

                public void buildFinished(BuildEvent ev) {
                }

                public void targetStarted(BuildEvent ev) {
                }

                public void targetFinished(BuildEvent ev) {
                }
            };
            String msg = null;
            this.getProject().addBuildListener(listener);
            try {
                ant.execute();
            }
            catch (BuildException x) {
                if (this.failOnError) {
                    throw x;
                }
                msg = x.getMessage().replaceFirst("(?s).*The following error occurred while executing this line:\r?\n", "") + errors;
            }
            catch (Throwable x) {
                if (this.failOnError) {
                    throw new BuildException(x, this.getLocation());
                }
                StringWriter sw = new StringWriter();
                x.printStackTrace(new PrintWriter(sw));
                msg = sw.toString();
            }
            finally {
                this.getProject().removeBuildListener(listener);
            }
            pseudoTests.put(path, msg);
            if (msg != null) {
                this.log("Failed to build " + path + ": " + msg, 1);
                continue;
            }
            this.log("Exiting: " + path);
        }
        JUnitReportWriter.writeReport(this, this.report, pseudoTests);
    }
}

