/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.JUnitReportWriter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateAllBySchema
extends Task {
    private List<FileSet> documents = new ArrayList<FileSet>();
    private List<FileSet> schemas = new ArrayList<FileSet>();
    private File report;

    public void addConfiguredDocuments(FileSet fs) {
        this.documents.add(fs);
    }

    public void addConfiguredSchemas(FileSet fs) {
        this.schemas.add(fs);
    }

    public void setReport(File r) {
        this.report = r;
    }

    public void execute() throws BuildException {
        SAXParser p;
        ArrayList<String> schemaUris = new ArrayList<String>();
        for (FileSet fs : this.schemas) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File basedir = scanner.getBasedir();
            for (String file : scanner.getIncludedFiles()) {
                File f = new File(basedir, file);
                schemaUris.add(f.toURI().toString());
            }
        }
        this.log("Validating against " + schemaUris);
        try {
            SAXParserFactory factory = (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            p = factory.newSAXParser();
            p.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            p.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaUris.toArray(new String[0]));
        }
        catch (Exception x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        TreeMap<String, String> tests = new TreeMap<String, String>();
        for (FileSet fs : this.documents) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File basedir = scanner.getBasedir();
            for (String file : scanner.getIncludedFiles()) {
                File f = new File(basedir, file);
                this.log("Parsing: " + f);
                try {
                    p.parse(f.toURI().toString(), (DefaultHandler)new Handler());
                    tests.put(file, null);
                }
                catch (SAXParseException x) {
                    String error = x.getSystemId() + ":" + x.getLineNumber() + ": " + x.getLocalizedMessage();
                    this.log(error, 0);
                    tests.put(file, error);
                }
                catch (Exception x) {
                    throw new BuildException("While parsing: " + f + " got: " + x, (Throwable)x, this.getLocation());
                }
            }
        }
        this.log("All files validated.");
        JUnitReportWriter.writeReport(this, this.report, tests);
    }

    private static final class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

