/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.HgExec;

public class ValidateHgConfiguration
extends Task {
    private File root;

    public void setRoot(File root) {
        this.root = root;
    }

    public void execute() throws BuildException {
        File dotHg = new File(this.root, ".hg");
        if (!dotHg.isDirectory()) {
            this.log(this.root + " is not a Mercurial repository", 3);
            return;
        }
        List<String> hgExecutable = HgExec.hgExecutable();
        try {
            String line;
            ArrayList<String> commandAndArgs = new ArrayList<String>(hgExecutable);
            commandAndArgs.add("--config");
            commandAndArgs.add("extensions.churn=");
            commandAndArgs.add("showconfig");
            Process p = new ProcessBuilder(commandAndArgs).directory(this.root).start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean foundUserName = false;
            boolean foundCrlfHook = false;
            while ((line = r.readLine()) != null) {
                if (line.matches("hooks\\.pretxncommit\\..+=python:(hgext\\.)?win32text\\.forbidcrlf")) {
                    foundCrlfHook = true;
                    continue;
                }
                if (!line.matches("ui\\.username=(.+ <)?\\w+@netbeans\\.org>?")) continue;
                foundUserName = true;
            }
            if (!foundUserName) {
                this.log("======== WARNING ========\nYou need to configure a Mercurial username\nif you intend to push changes to NetBeans repositories.\nFormat (in ~/.hgrc or Mercurial.ini):\n[ui]\nusername = Robert Q. Hacker <rhacker@netbeans.org>\n=========================", 1);
            }
            if (!foundCrlfHook) {
                this.log("======== WARNING ========\nYou need to guard against committing carriage returns into Mercurial\nif you intend to push changes to NetBeans repositories.\nFormat (in ~/.hgrc or Mercurial.ini, Hg 1.0+ required):\n[hooks]\npretxncommit.crlf = python:hgext.win32text.forbidcrlf\n=========================", 1);
            }
            r = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = r.readLine()) != null) {
                if (!line.contains("failed to import extension churn")) continue;
                this.log("======== WARNING ========\nYou seem to be using a version of Mercurial older than 1.0.\nPlease upgrade as your version may have serious bugs fixed in later versions.\n=========================", 1);
            }
        }
        catch (IOException x) {
            this.log("Could not verify Hg configuration: " + x, 1);
        }
    }
}

