/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.JUnitReportWriter;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VerifyUpdateCenter
extends Task {
    private URI updates;
    private URI oldUpdates;
    private Set<String> disabledAutoloads;
    private boolean checkAutoUpdateVisibility;
    private Path classpath = new Path(this.getProject());
    private File reportFile;

    public void setUpdates(File f) {
        this.updates = f.toURI();
    }

    public void setUpdatesURL(URI u) {
        this.updates = u;
    }

    public void setOldUpdates(File f) {
        if (f.isFile()) {
            this.oldUpdates = f.toURI();
        } else {
            this.log("No such file: " + f, 1);
        }
    }

    public void setOldUpdatesURL(URI u) {
        if (u.toString().length() > 0) {
            this.oldUpdates = u;
        }
    }

    public void setDisabledAutoloads(String s) {
        this.disabledAutoloads = new HashSet<String>(Arrays.asList(s.split("[, ]+")));
    }

    public void setCheckAutoUpdateVisibility(boolean checkAutoUpdateVisibility) {
        this.checkAutoUpdateVisibility = checkAutoUpdateVisibility;
    }

    public void addConfiguredClasspath(Path p) {
        this.classpath.append(p);
    }

    public void setReport(File report) {
        this.reportFile = report;
    }

    public void execute() throws BuildException {
        String cnb;
        if (this.updates == null) {
            throw new BuildException("you must specify updates");
        }
        LinkedHashMap<String, String> pseudoTests = new LinkedHashMap<String, String>();
        AntClassLoader loader = new AntClassLoader(this.getProject(), this.classpath);
        Set<Manifest> manifests = this.loadManifests(this.updates);
        if (this.checkAutoUpdateVisibility) {
            HashSet<String> requiredBySomeone = new HashSet<String>();
            for (Manifest m : manifests) {
                String deps = m.getMainAttributes().getValue("OpenIDE-Module-Module-Dependencies");
                if (deps == null) continue;
                String identifier = "[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*";
                Matcher match = Pattern.compile(identifier + "(\\." + identifier + ")*").matcher(deps);
                while (match.find()) {
                    requiredBySomeone.add(match.group());
                }
            }
            StringBuilder auVisibilityProblems = new StringBuilder();
            String[] markers = new String[]{"autoload", "eager", "AutoUpdate-Show-In-Client", "AutoUpdate-Essential-Module"};
            block2: for (Manifest m : manifests) {
                cnb = VerifyUpdateCenter.findCNB(m);
                if (requiredBySomeone.contains(cnb)) continue;
                Attributes attr = m.getMainAttributes();
                for (String marker : markers) {
                    if ("true".equals(attr.getValue(marker))) continue block2;
                }
                auVisibilityProblems.append("\n" + cnb);
            }
            pseudoTests.put("testAutoUpdateVisibility", auVisibilityProblems.length() > 0 ? "Some regular modules (that no one depends on) neither AutoUpdate-Show-In-Client nor AutoUpdate-Essential-Module" + auVisibilityProblems : null);
        }
        this.checkForProblems(this.findInconsistencies(manifests, (ClassLoader)loader, this.disabledAutoloads), "Inconsistency(ies) in " + this.updates, "synchronicConsistency", pseudoTests);
        if (pseudoTests.get("synchronicConsistency") == null) {
            this.log(this.updates + " is internally consistent", 2);
            if (this.oldUpdates != null) {
                HashMap<String, Manifest> updated = new HashMap<String, Manifest>();
                for (Manifest m : this.loadManifests(this.oldUpdates)) {
                    updated.put(VerifyUpdateCenter.findCNB(m), m);
                }
                if (!this.findInconsistencies(new HashSet<Manifest>(updated.values()), (ClassLoader)loader, null).isEmpty()) {
                    this.log(this.oldUpdates + " is already inconsistent, skipping update check", 1);
                    JUnitReportWriter.writeReport(this, this.reportFile, pseudoTests);
                    return;
                }
                TreeSet<String> updatedCNBs = new TreeSet<String>();
                HashSet<String> newCNBs = new HashSet<String>();
                for (Manifest m : manifests) {
                    cnb = VerifyUpdateCenter.findCNB(m);
                    newCNBs.add(cnb);
                    boolean doUpdate = true;
                    Manifest old = (Manifest)updated.get(cnb);
                    if (old != null) {
                        String oldspec = old.getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                        String newspec = m.getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                        doUpdate = VerifyUpdateCenter.specGreaterThan(newspec, oldspec);
                    }
                    if (!doUpdate) continue;
                    updated.put(cnb, m);
                    updatedCNBs.add(cnb);
                }
                SortedMap<String, SortedSet<String>> updateProblems = this.findInconsistencies(new HashSet<Manifest>(updated.values()), (ClassLoader)loader, null);
                updateProblems.keySet().retainAll(newCNBs);
                this.checkForProblems(updateProblems, "Inconsistency(ies) in " + this.updates + " relative to " + this.oldUpdates, "diachronicConsistency", pseudoTests);
                if (pseudoTests.get("diachronicConsistency") == null) {
                    this.log(this.oldUpdates + " after updating " + updatedCNBs + " from " + this.updates + " remains consistent");
                }
            }
        }
        JUnitReportWriter.writeReport(this, this.reportFile, pseudoTests);
    }

    private SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> manifests, ClassLoader loader, Set<String> disabledAutoloads) throws BuildException {
        try {
            return (SortedMap)loader.loadClass("org.netbeans.core.startup.ConsistencyVerifier").getMethod("findInconsistencies", Set.class, Set.class).invoke(null, manifests, disabledAutoloads);
        }
        catch (Exception x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
    }

    private Set<Manifest> loadManifests(URI u) throws BuildException {
        try {
            Document doc = XMLUtil.parse(new InputSource(u.toString()), false, false, null, new EntityResolver(){

                public InputSource resolveEntity(String pub, String sys) throws SAXException, IOException {
                    if (pub.contains("DTD Autoupdate Catalog")) {
                        return new InputSource(new StringReader(""));
                    }
                    return null;
                }
            });
            HashSet<Manifest> manifests = new HashSet<Manifest>();
            NodeList nl = doc.getElementsByTagName("manifest");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element m = (Element)nl.item(i);
                Manifest mani = new Manifest();
                NamedNodeMap map = m.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    Attr a = (Attr)map.item(j);
                    mani.getMainAttributes().putValue(a.getName(), a.getValue());
                }
                Element module = (Element)m.getParentNode();
                for (String pseudoAttr : new String[]{"autoload", "eager"}) {
                    if (!module.getAttribute(pseudoAttr).equals("true")) continue;
                    mani.getMainAttributes().putValue(pseudoAttr, "true");
                }
                manifests.add(mani);
            }
            return manifests;
        }
        catch (Exception x) {
            throw new BuildException("Could not load " + u, (Throwable)x, this.getLocation());
        }
    }

    private static String findCNB(Manifest m) {
        String name = m.getMainAttributes().getValue("OpenIDE-Module");
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return name.replaceFirst("/\\d+$", "");
    }

    private static boolean specGreaterThan(String newspec, String oldspec) {
        if (newspec == null) {
            return false;
        }
        if (oldspec == null) {
            return true;
        }
        String[] olddigits = oldspec.split("\\.");
        String[] newdigits = newspec.split("\\.");
        int oldlen = olddigits.length;
        int newlen = newdigits.length;
        int max = Math.max(oldlen, newlen);
        for (int i = 0; i < max; ++i) {
            int newd;
            int oldd = i < oldlen ? Integer.parseInt(olddigits[i]) : 0;
            int n = newd = i < newlen ? Integer.parseInt(newdigits[i]) : 0;
            if (oldd == newd) continue;
            return newd > oldd;
        }
        return false;
    }

    private void checkForProblems(SortedMap<String, SortedSet<String>> problems, String msg, String testName, Map<String, String> pseudoTests) {
        if (!problems.isEmpty()) {
            StringBuffer message = new StringBuffer(msg);
            for (Map.Entry<String, SortedSet<String>> entry : problems.entrySet()) {
                message.append("\nProblems found for module " + entry.getKey() + ": " + entry.getValue());
            }
            pseudoTests.put(testName, message.toString());
        } else {
            pseudoTests.put(testName, null);
        }
    }
}

