/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.netbeans.nbbuild.JUnitReportWriter;
import org.netbeans.nbbuild.extlibs.VerifyLibsAndLicenses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLicenseSummary
extends Task {
    private File nball;
    private File build;
    private File summary;
    private File reportFile;
    private Map<String, String> pseudoTests;

    public void setNball(File nball) {
        this.nball = nball;
    }

    public void setBuild(File build) {
        this.build = build;
    }

    public void setSummary(File summary) {
        this.summary = summary;
    }

    public void setReport(File report) {
        this.reportFile = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.pseudoTests = new LinkedHashMap<String, String>();
        try {
            Map<Long, Map<String, String>> crc2License = this.findCrc2LicenseHeaderMapping();
            TreeMap<String, Map<String, String>> binaries2LicenseHeaders = new TreeMap<String, Map<String, String>>();
            StringBuilder testBinariesAreUnique = new StringBuilder();
            List<String> ignoredPatterns = VerifyLibsAndLicenses.loadPatterns("ignored-binary-overlaps");
            this.findBinaries(this.build, binaries2LicenseHeaders, crc2License, new HashMap<Long, String>(), "", testBinariesAreUnique, ignoredPatterns);
            this.pseudoTests.put("testBinariesAreUnique", testBinariesAreUnique.length() > 0 ? "Some binaries are duplicated" + testBinariesAreUnique : null);
            FileOutputStream os = new FileOutputStream(this.summary);
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                pw.println("DO NOT TRANSLATE OR LOCALIZE.");
                pw.println();
                TreeSet<String> licenseNames = new TreeSet<String>();
                pw.printf("%-60s %10s %-40s %s\n", "NAME", "SIZE", "SHA-1 HASH", "LICENSE");
                for (Map.Entry entry : binaries2LicenseHeaders.entrySet()) {
                    MessageDigest digest;
                    String binary = (String)entry.getKey();
                    File f = new File(this.build, binary.replace('/', File.separatorChar));
                    try {
                        digest = MessageDigest.getInstance("SHA-1");
                    }
                    catch (NoSuchAlgorithmException x) {
                        throw new BuildException((Throwable)x, this.getLocation());
                    }
                    FileInputStream is = new FileInputStream(f);
                    try {
                        digest.update(is.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, f.length()));
                    }
                    finally {
                        is.close();
                    }
                    Map headers = (Map)entry.getValue();
                    pw.printf("%-60s %10d %040X %s\n", binary, f.length(), new BigInteger(1, digest.digest()), this.getMaybeMissing(headers, "License"));
                    String license = (String)headers.get("License");
                    if (license == null) continue;
                    licenseNames.add(license);
                }
                String[] otherHeaders = new String[]{"Name", "Version", "Description", "OSR", "Origin"};
                LinkedHashMap licenseHeaders2Binaries = new LinkedHashMap();
                for (Map.Entry entry : binaries2LicenseHeaders.entrySet()) {
                    HashMap headers = new HashMap((Map)entry.getValue());
                    headers.keySet().retainAll(Arrays.asList(otherHeaders));
                    TreeSet binaries = (TreeSet)licenseHeaders2Binaries.get(headers);
                    if (binaries == null) {
                        binaries = new TreeSet();
                        licenseHeaders2Binaries.put(headers, binaries);
                    }
                    binaries.add(entry.getKey());
                }
                for (Map.Entry entry : licenseHeaders2Binaries.entrySet()) {
                    pw.println();
                    for (String binary : (Set)entry.getValue()) {
                        pw.println(binary);
                    }
                    for (String header : otherHeaders) {
                        pw.printf("%s: %s\n", header, this.getMaybeMissing((Map)entry.getKey(), header));
                    }
                }
                File licenses = new File(new File(this.nball, "nbbuild"), "licenses");
                for (String licenseName : licenseNames) {
                    File license;
                    if (licenseName == null || !(license = new File(licenses, licenseName)).isFile()) continue;
                    pw.println();
                    pw.println("=========== " + licenseName + " ===========");
                    FileInputStream is = new FileInputStream(license);
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((line = r.readLine()) != null) {
                            pw.println(line);
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                pw.flush();
            }
            finally {
                ((OutputStream)os).close();
            }
            this.log(this.summary + ": written");
        }
        catch (IOException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        JUnitReportWriter.writeReport(this, this.reportFile, this.pseudoTests);
    }

    private String getMaybeMissing(Map<String, String> headers, String headerName) {
        if (headers.containsKey(headerName)) {
            return headers.get(headerName);
        }
        return "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Map<String, String>> findCrc2LicenseHeaderMapping() throws IOException {
        HashMap<Long, Map<String, String>> crc2LicenseHeaders = new HashMap<Long, Map<String, String>>();
        for (String cluster : this.getProject().getProperty("nb.clusters.list").split("[, ]+")) {
            for (String module : this.getProject().getProperty(cluster).split("[, ]+")) {
                File d = new File(new File(this.nball, module), "external");
                Set<String> hgFiles = VerifyLibsAndLicenses.findHgControlledFiles(d);
                Map<String, Map<String, String>> binary2License = this.findBinary2LicenseHeaderMapping(hgFiles, d);
                for (String n : hgFiles) {
                    Map<String, String> headers;
                    if (!n.endsWith(".jar") && !n.endsWith(".zip") || (headers = binary2License.get(n)) == null) continue;
                    File f = new File(d, n);
                    InputStream is = new FileInputStream(f);
                    try {
                        crc2LicenseHeaders.put(this.computeCRC32(is), headers);
                    }
                    finally {
                        is.close();
                    }
                    ZipFile zf = new ZipFile(f);
                    try {
                        Enumeration<? extends ZipEntry> entries = zf.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            String innerName = entry.getName();
                            if (!innerName.endsWith(".jar") && !innerName.endsWith(".zip")) continue;
                            is = zf.getInputStream(entry);
                            try {
                                crc2LicenseHeaders.put(this.computeCRC32(is), headers);
                            }
                            finally {
                                is.close();
                            }
                        }
                    }
                    finally {
                        zf.close();
                    }
                }
            }
        }
        return crc2LicenseHeaders;
    }

    private long computeCRC32(InputStream is) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        CRC32 crc32 = new CRC32();
        while ((read = is.read(buf)) != -1) {
            crc32.update(buf, 0, read);
        }
        return crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> findBinary2LicenseHeaderMapping(Set<String> cvsFiles, File d) throws IOException {
        HashMap<String, Map<String, String>> binary2LicenseHeaders = new HashMap<String, Map<String, String>>();
        for (String n : cvsFiles) {
            if (!n.endsWith("-license.txt")) continue;
            HashMap<String, String> headers = new HashMap<String, String>();
            FileInputStream is = new FileInputStream(new File(d, n));
            try {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                while ((line = r.readLine()) != null && line.length() > 0) {
                    Matcher m = Pattern.compile("([a-zA-Z]+): (.+)").matcher(line);
                    if (!m.matches()) continue;
                    headers.put(m.group(1), m.group(2));
                }
            }
            finally {
                ((InputStream)is).close();
            }
            String files = (String)headers.remove("Files");
            if (files != null) {
                for (String file : files.split("[, ]+")) {
                    binary2LicenseHeaders.put(file, headers);
                }
                continue;
            }
            binary2LicenseHeaders.put(n.replaceFirst("-license\\.txt$", ".jar"), headers);
            binary2LicenseHeaders.put(n.replaceFirst("-license\\.txt$", ".zip"), headers);
        }
        return binary2LicenseHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findBinaries(File d, Map<String, Map<String, String>> binaries2LicenseHeaders, Map<Long, Map<String, String>> crc2LicenseHeaders, Map<Long, String> crc2Binary, String prefix, StringBuilder testBinariesAreUnique, List<String> ignoredPatterns) throws IOException {
        Object[] kids = d.list();
        Arrays.sort(kids);
        for (Object n : kids) {
            File f = new File(d, (String)n);
            if (f.isDirectory()) {
                this.findBinaries(f, binaries2LicenseHeaders, crc2LicenseHeaders, crc2Binary, prefix + (String)n + "/", testBinariesAreUnique, ignoredPatterns);
                continue;
            }
            if (!((String)n).endsWith(".jar") && !((String)n).endsWith(".zip")) continue;
            FileInputStream is = new FileInputStream(f);
            try {
                long crc = this.computeCRC32(is);
                Map<String, String> headers = crc2LicenseHeaders.get(crc);
                if (headers == null) continue;
                String path = prefix + (String)n;
                binaries2LicenseHeaders.put(path, headers);
                String otherPath = crc2Binary.put(crc, path);
                if (otherPath == null) continue;
                boolean ignored = false;
                for (String pattern : ignoredPatterns) {
                    String[] parts = pattern.split(" ");
                    assert (parts.length == 2) : pattern;
                    if (!SelectorUtils.matchPath((String)parts[0], (String)otherPath) || !SelectorUtils.matchPath((String)parts[1], (String)path)) continue;
                    ignored = true;
                    break;
                }
                if (ignored) continue;
                testBinariesAreUnique.append("\n" + otherPath + " and " + path + " are identical");
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }
}

