/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class DownloadBinaries
extends Task {
    private File cache;
    private String server;
    private final List<FileSet> manifests = new ArrayList<FileSet>();
    private boolean clean;

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void addManifest(FileSet manifest) {
        this.manifests.add(manifest);
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        for (FileSet fs : this.manifests) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File basedir = scanner.getBasedir();
            for (String include : scanner.getIncludedFiles()) {
                File manifest = new File(basedir, include);
                this.log("Scanning: " + manifest, 3);
                try {
                    FileInputStream is = new FileInputStream(manifest);
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((line = r.readLine()) != null) {
                            String actualHash;
                            if (line.startsWith("#") || line.trim().length() == 0) continue;
                            String[] hashAndFile = line.split(" ", 2);
                            if (hashAndFile.length < 2) {
                                throw new BuildException("Bad line '" + line + "' in " + manifest, this.getLocation());
                            }
                            File f = new File(manifest.getParentFile(), hashAndFile[1]);
                            if (!this.clean) {
                                if (!f.exists() || !this.hash(f).equals(hashAndFile[0])) {
                                    this.log("Creating " + f);
                                    String cacheName = hashAndFile[0] + "-" + f.getName();
                                    if (this.cache != null) {
                                        this.cache.mkdirs();
                                        File cacheFile = new File(this.cache, cacheName);
                                        if (!cacheFile.exists()) {
                                            this.download(cacheName, cacheFile);
                                        }
                                        if (f.isFile() && !f.delete()) {
                                            throw new BuildException("Could not delete " + f);
                                        }
                                        try {
                                            FileUtils.getFileUtils().copyFile(cacheFile, f);
                                        }
                                        catch (IOException x) {
                                            throw new BuildException("Could not copy " + cacheFile + " to " + f + ": " + x, (Throwable)x, this.getLocation());
                                        }
                                    } else {
                                        this.download(cacheName, f);
                                    }
                                }
                                if (!(actualHash = this.hash(f)).equals(hashAndFile[0])) {
                                    throw new BuildException("File " + f + " requested by " + manifest + " to have hash " + hashAndFile[0] + " actually had hash " + actualHash, this.getLocation());
                                }
                                this.log("Have " + f + " with expected hash", 3);
                                continue;
                            }
                            if (!f.exists()) continue;
                            actualHash = this.hash(f);
                            if (!actualHash.equals(hashAndFile[0])) {
                                throw new BuildException("File " + f + " requested by " + manifest + " to have hash " + hashAndFile[0] + " actually had hash " + actualHash, this.getLocation());
                            }
                            this.log("Deleting " + f);
                            f.delete();
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException x) {
                    throw new BuildException("Could not open " + manifest + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String cacheName, File destination) {
        if (this.server == null) {
            throw new BuildException("Must specify a server to download files from", this.getLocation());
        }
        for (String prefix : this.server.split(" ")) {
            URL url;
            try {
                url = new URL(prefix + cacheName);
            }
            catch (MalformedURLException x) {
                throw new BuildException((Throwable)x, this.getLocation());
            }
            try {
                URLConnection conn = url.openConnection();
                conn.connect();
                int code = 200;
                if (conn instanceof HttpURLConnection) {
                    code = ((HttpURLConnection)conn).getResponseCode();
                }
                if (code != 200) {
                    this.log("Skipping download from " + url + " due to response code " + code, 3);
                }
                this.log("Downloading: " + url);
                InputStream is = conn.getInputStream();
                try {
                    FileOutputStream os = new FileOutputStream(destination);
                    try {
                        int read;
                        byte[] buf = new byte[4096];
                        while ((read = is.read(buf)) != -1) {
                            ((OutputStream)os).write(buf, 0, read);
                        }
                        ((OutputStream)os).close();
                    }
                    catch (IOException x) {
                        destination.delete();
                        throw x;
                    }
                }
                finally {
                    is.close();
                }
                return;
            }
            catch (IOException x) {
                this.log("Could not download " + url + " to " + destination + ": " + x, 1);
            }
        }
        throw new BuildException("Could not download " + cacheName + " from " + this.server, this.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hash(File f) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        try {
            FileInputStream is = new FileInputStream(f);
            try {
                int r;
                byte[] buf = new byte[4096];
                while ((r = is.read(buf)) != -1) {
                    digest.update(buf, 0, r);
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException x) {
            throw new BuildException("Could not get hash for " + f + ": " + x, (Throwable)x, this.getLocation());
        }
        return String.format("%040X", new BigInteger(1, digest.digest()));
    }
}

