/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ReleaseFilesLicense
extends Task {
    private File license;
    private File standardLicense;
    private String extraLicenseFiles;

    public void setLicense(File license) {
        this.license = license;
    }

    public void setStandardLicense(File standardLicense) {
        this.standardLicense = standardLicense;
    }

    public void setExtraLicenseFiles(String extraLicenseFiles) {
        this.extraLicenseFiles = extraLicenseFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            FileOutputStream os = new FileOutputStream(this.license);
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                pw.println("License for NetBeans module:");
                pw.println();
                this.append(pw, this.standardLicense);
                for (String name : this.extraLicenseFiles.split("[, ]+")) {
                    File f = this.getProject().resolveFile(name);
                    if (!f.isFile()) {
                        this.log("No such license: " + f, 1);
                        continue;
                    }
                    pw.println();
                    pw.println();
                    pw.println("==================================================");
                    pw.println("Additional license (" + f.getName() + "):");
                    pw.println();
                    FileInputStream is = new FileInputStream(f);
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((line = r.readLine()) != null && line.length() > 0) {
                        }
                        while ((line = r.readLine()) != null) {
                            pw.println(line);
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                TreeMap<File, TreeSet<String>> inferredLicenses = new TreeMap<File, TreeSet<String>>();
                block17: for (Map.Entry entry : this.getProject().getProperties().entrySet()) {
                    String k = (String)entry.getKey();
                    if (!k.startsWith("release.external/")) continue;
                    String binary = k.substring("release.external/".length()).replaceFirst("!/.+$", "");
                    File d = this.getProject().resolveFile("external");
                    for (File possibleLicense : d.listFiles()) {
                        if (!possibleLicense.getName().endsWith("-license.txt")) continue;
                        FileInputStream is = new FileInputStream(possibleLicense);
                        try {
                            String line;
                            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                            String files = possibleLicense.getName().replaceFirst("-license\\.txt$", ".jar") + " " + possibleLicense.getName().replaceFirst("-license\\.txt$", ".zip");
                            while ((line = r.readLine()) != null && line.length() > 0) {
                                Matcher m = Pattern.compile("Files: (.+)").matcher(line);
                                if (!m.matches()) continue;
                                files = m.group(1);
                                break;
                            }
                            if (!Arrays.asList(files.split("[, ]+")).contains(binary)) continue;
                            TreeSet<String> binaries = (TreeSet<String>)inferredLicenses.get(possibleLicense);
                            if (binaries == null) {
                                binaries = new TreeSet<String>();
                                inferredLicenses.put(possibleLicense, binaries);
                            }
                            binaries.add((String)entry.getValue());
                            continue block17;
                        }
                        finally {
                            ((InputStream)is).close();
                            continue block17;
                        }
                    }
                }
                for (Map.Entry entry : inferredLicenses.entrySet()) {
                    pw.println();
                    pw.println();
                    pw.println("==================================================");
                    pw.println("Additional license (" + ((File)entry.getKey()).getName() + ") associated with the following files:");
                    for (String binary : (Set)entry.getValue()) {
                        pw.println(binary);
                    }
                    pw.println();
                    FileInputStream is = new FileInputStream((File)entry.getKey());
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((line = r.readLine()) != null && line.length() > 0) {
                        }
                        while ((line = r.readLine()) != null) {
                            pw.println(line);
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                pw.flush();
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(PrintWriter pw, File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((line = r.readLine()) != null) {
                pw.println(line);
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

