/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.netbeans.nbbuild.JUnitReportWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyLibsAndLicenses
extends Task {
    private File nball;
    private File reportFile;
    private Map<String, String> pseudoTests;
    private Set<String> modules;
    private static final Map<File, List<Pattern>> hgignores = new HashMap<File, List<Pattern>>();

    public void setNball(File nball) {
        this.nball = nball;
    }

    public void setReport(File report) {
        this.reportFile = report;
    }

    public void execute() throws BuildException {
        try {
            this.pseudoTests = new LinkedHashMap<String, String>();
            this.modules = new TreeSet<String>();
            for (String cluster : this.getProject().getProperty("nb.clusters.list").split("[, ]+")) {
                this.modules.addAll(Arrays.asList(this.getProject().getProperty(cluster).split("[, ]+")));
            }
            try {
                this.testNoStrayThirdPartyBinaries();
                this.testLicenseFilesAreProperlyFormattedPhysically();
                this.testLicenses();
                this.testBinaryUniqueness();
            }
            catch (IOException x) {
                throw new BuildException((Throwable)x, this.getLocation());
            }
            JUnitReportWriter.writeReport(this, this.reportFile, this.pseudoTests);
        }
        catch (NullPointerException x) {
            x.printStackTrace();
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBinaryUniqueness() throws IOException {
        List<String> ignoredPatterns = VerifyLibsAndLicenses.loadPatterns("ignored-overlaps");
        StringBuffer msg = new StringBuffer();
        HashMap<Long, String> binaries = new HashMap<Long, String>();
        for (String module : this.modules) {
            File d = new File(new File(this.nball, module), "external");
            Set<String> hgFiles = VerifyLibsAndLicenses.findHgControlledFiles(d);
            for (String n : hgFiles) {
                if (!n.endsWith(".jar") && !n.endsWith(".zip")) continue;
                File f = new File(d, n);
                String path = module + "/external/" + n;
                InputStream is = new FileInputStream(f);
                try {
                    int read;
                    byte[] buf = new byte[4096];
                    CRC32 crc = new CRC32();
                    while ((read = is.read(buf)) != -1) {
                        crc.update(buf, 0, read);
                    }
                    VerifyLibsAndLicenses.maybeAppendDuplicateMessage(msg, binaries.put(crc.getValue(), path), path, ignoredPatterns);
                }
                finally {
                    is.close();
                }
                ZipFile zf = new ZipFile(f);
                try {
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String innerName = entry.getName();
                        if (!innerName.endsWith(".jar") && !innerName.endsWith(".zip")) continue;
                        String innerPath = innerName + " in " + path;
                        is = zf.getInputStream(entry);
                        try {
                            int read;
                            byte[] buf = new byte[4096];
                            CRC32 crc = new CRC32();
                            while ((read = is.read(buf)) != -1) {
                                crc.update(buf, 0, read);
                            }
                            VerifyLibsAndLicenses.maybeAppendDuplicateMessage(msg, binaries.put(crc.getValue(), innerPath), innerPath, ignoredPatterns);
                        }
                        finally {
                            is.close();
                        }
                    }
                }
                finally {
                    zf.close();
                }
            }
        }
        this.pseudoTests.put("testBinaryUniqueness", msg.length() > 0 ? "Some binaries are duplicated" + msg : null);
    }

    private static void maybeAppendDuplicateMessage(StringBuffer msg, String path1, String path2, List<String> ignoredPatterns) {
        if (path1 == null || path2 == null) {
            return;
        }
        for (String pattern : ignoredPatterns) {
            String[] parts = pattern.split(" ");
            assert (parts.length == 2) : pattern;
            if (!SelectorUtils.matchPath((String)parts[0], (String)path1.replaceFirst("^.+ in ", "")) || !SelectorUtils.matchPath((String)parts[1], (String)path2.replaceFirst("^.+ in ", ""))) continue;
            return;
        }
        msg.append("\n" + path1 + " and " + path2 + " are identical");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLicenseFilesAreProperlyFormattedPhysically() throws IOException {
        StringBuffer msg = new StringBuffer();
        for (String module : this.modules) {
            File d = new File(new File(this.nball, module), "external");
            block9: for (String n : VerifyLibsAndLicenses.findHgControlledFiles(d)) {
                String path = module + "/external/" + n;
                if (!n.endsWith("-license.txt")) continue;
                File f = new File(d, n);
                FileInputStream is = new FileInputStream(f);
                int line = 1;
                try {
                    int c;
                    CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    InputStreamReader r = new InputStreamReader((InputStream)is, decoder);
                    int column = 0;
                    boolean pastHeader = false;
                    boolean trailingSpace = false;
                    while ((c = ((Reader)r).read()) != -1) {
                        if (trailingSpace && (c == 13 || c == 10)) {
                            msg.append("\n" + path + " has a trailing space on line #" + line);
                            continue block9;
                        }
                        if (c == 13) {
                            column = 0;
                            continue;
                        }
                        if (c == 10) {
                            if (column == 0 && line > 1 && !pastHeader) {
                                pastHeader = true;
                            }
                            column = 0;
                            ++line;
                            continue;
                        }
                        if (c == 12) {
                            msg.append("\n" + path + " uses a form feed (^L) on line #" + line);
                            continue block9;
                        }
                        trailingSpace = c == 32;
                        if (!pastHeader || ++column <= 80) continue;
                        msg.append("\n" + path + " has line #" + line + " longer than 80 characters");
                        continue block9;
                    }
                    if (column <= 0) continue;
                    msg.append("\n" + path + " must end in a newline");
                }
                catch (IOException x) {
                    msg.append("\n" + path + " at line #" + line + ": " + x);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        }
        this.pseudoTests.put("testLicenseFilesAreProperlyFormattedPhysically", msg.length() > 0 ? "Some license files were badly formatted" + msg : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLicenses() throws IOException {
        File licenses = new File(new File(this.nball, "nbbuild"), "licenses");
        TreeSet<String> requiredHeaders = new TreeSet<String>(Arrays.asList("Name", "Version", "Description", "License", "OSR", "Origin"));
        HashSet<String> optionalHeaders = new HashSet<String>(Arrays.asList("Files", "Source", "Comment"));
        StringBuffer msg = new StringBuffer();
        for (String module : this.modules) {
            File d = new File(new File(this.nball, module), "external");
            Set<String> hgFiles = VerifyLibsAndLicenses.findHgControlledFiles(d);
            HashSet<String> referencedBinaries = new HashSet<String>();
            for (String n : hgFiles) {
                String license;
                if (!n.endsWith("-license.txt")) continue;
                File f = new File(d, n);
                String path = module + "/external/" + n;
                Map headers = new HashMap<String, String>();
                FileInputStream is = new FileInputStream(f);
                StringBuffer body = new StringBuffer();
                try {
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    while ((line = r.readLine()) != null && line.length() > 0) {
                        Matcher m = Pattern.compile("([a-zA-Z]+): (.+)").matcher(line);
                        if (!m.matches()) {
                            msg.append("\n" + path + " has a non-header line in the header block: \"" + line + "\"");
                            headers = null;
                            break;
                        }
                        headers.put(m.group(1), m.group(2));
                    }
                    while ((line = r.readLine()) != null) {
                        body.append(line).append('\n');
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
                if (headers == null) {
                    headers = Collections.emptyMap();
                } else if (headers.isEmpty()) {
                    msg.append("\n" + path + " has no headers");
                } else {
                    for (String header : requiredHeaders) {
                        if (headers.containsKey(header) || header.equals("OSR") && headers.get("License") != null && (((String)headers.get("License")).startsWith("CDDL") || ((String)headers.get("License")).startsWith("SLA"))) continue;
                        msg.append("\n" + path + " is missing a required header: " + header);
                    }
                }
                for (String header : headers.keySet()) {
                    if (requiredHeaders.contains(header) || optionalHeaders.contains(header)) continue;
                    msg.append("\n" + path + " has an unrecognized header: " + header);
                }
                String version = (String)headers.get("Version");
                if (version != null && !n.contains(version)) {
                    msg.append("\n" + path + " does not contain the version " + version + " in its name");
                }
                if ((license = (String)headers.get("License")) != null) {
                    File licenseFile;
                    if (license.contains("GPL") && !headers.containsKey("Source")) {
                        msg.append("\n" + path + " has a GPL-family license but is missing the Source header");
                    }
                    if ((licenseFile = new File(licenses, license)).isFile()) {
                        StringBuffer masterBody = new StringBuffer();
                        is = new FileInputStream(licenseFile);
                        try {
                            int c;
                            BufferedReader r = new BufferedReader(new InputStreamReader(is));
                            while ((c = r.read()) != -1) {
                                masterBody.append((char)c);
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                        String master = masterBody.toString().replaceAll("[ \n\t]+", " ").trim();
                        String actual = body.toString().replaceAll("[ \n\t]+", " ").trim();
                        String problem = VerifyLibsAndLicenses.templateMatch(actual, master, false);
                        if (problem != null) {
                            msg.append("\n" + path + " contains a license body which does not match that in nbbuild/licenses/" + license + ": " + problem);
                        }
                    } else {
                        msg.append("\n" + path + " refers to nonexistent nbbuild/licenses/" + license);
                    }
                }
                for (String urlHeader : new String[]{"Source", "Origin"}) {
                    String value = (String)headers.get("Source");
                    if (value == null) continue;
                    try {
                        new URL(value);
                    }
                    catch (MalformedURLException x) {
                        msg.append("\n" + path + " has malformed " + urlHeader + " value: " + value);
                    }
                }
                String files = (String)headers.get("Files");
                if (files != null) {
                    for (String file : files.split("[, ]+")) {
                        referencedBinaries.add(file);
                        if (hgFiles.contains(file)) continue;
                        msg.append("\n" + path + " mentions a nonexistent binary in Files: " + file);
                    }
                    continue;
                }
                String matchingJar = n.replaceFirst("-license\\.txt$", ".jar");
                String matchingZip = n.replaceFirst("-license\\.txt$", ".zip");
                referencedBinaries.add(matchingJar);
                referencedBinaries.add(matchingZip);
                if (hgFiles.contains(matchingJar) || hgFiles.contains(matchingZip)) continue;
                msg.append("\n" + path + " has no Files header and no corresponding " + matchingJar + " or " + matchingZip + " could be found");
            }
            for (String n : hgFiles) {
                if (!n.endsWith(".jar") && !n.endsWith(".zip")) continue;
                String path = module + "/external/" + n;
                if (!n.matches(".+[0-9].+")) {
                    msg.append("\n" + path + " does not appear to include a version number");
                }
                if (referencedBinaries.contains(n)) continue;
                msg.append("\n" + path + " is not associated with any license file");
            }
        }
        this.pseudoTests.put("testLicenses", msg.length() > 0 ? "Some license files have incorrect headers" + msg : null);
    }

    private static String templateMatch(String actual, String expected, boolean left) {
        String reason = null;
        boolean expectReason = false;
        String mismatch = null;
        while (true) {
            if (actual.matches(expected.replaceAll("([\\\\\\[\\].^$?*+{}()|])", "\\\\$1").replaceAll(" *__[A-Z_]+__ *", ".*"))) {
                reason = null;
                break;
            }
            if (expected.length() == 0) {
                reason = "unexpected extra content";
                break;
            }
            if (actual.length() == 0) {
                reason = "missing content";
                break;
            }
            if (!expected.startsWith("__")) {
                if (expected.charAt(0) != actual.charAt(0)) {
                    reason = VerifyLibsAndLicenses.mismatch(actual, expected, true);
                    break;
                }
                expectReason = true;
                mismatch = VerifyLibsAndLicenses.mismatch(actual, expected, true);
                actual = actual.substring(1);
                expected = expected.substring(1);
                continue;
            }
            if (!expected.endsWith("__")) {
                if (expected.charAt(expected.length() - 1) != actual.charAt(actual.length() - 1)) {
                    reason = VerifyLibsAndLicenses.mismatch(actual, expected, false);
                    break;
                }
                expectReason = true;
                mismatch = VerifyLibsAndLicenses.mismatch(actual, expected, false);
                actual = actual.substring(0, actual.length() - 1);
                expected = expected.substring(0, expected.length() - 1);
                continue;
            }
            String absorbed = expected.replaceFirst(left ? "^(__[A-Z_]+__)." : ".(__[A-Z_]+__)$", "$1");
            assert (!expected.equals(absorbed)) : expected;
            mismatch = VerifyLibsAndLicenses.mismatch(actual, expected, left);
            expected = absorbed;
            left = !left;
        }
        if (reason == null) {
            assert (!expectReason) : mismatch;
            return mismatch;
        }
        return reason;
    }

    private static String mismatch(String actual, String expected, boolean useHead) {
        return "mismatch around: '" + VerifyLibsAndLicenses.headOrTail(actual, useHead) + "' vs. '" + VerifyLibsAndLicenses.headOrTail(expected, useHead) + "'";
    }

    private static String headOrTail(String text, boolean useHead) {
        int context = 20;
        return text.length() > context ? (useHead ? text.substring(0, context) : text.substring(text.length() - context, text.length())) : text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> loadPatterns(String resource) throws IOException {
        ArrayList<String> patterns = new ArrayList<String>();
        InputStream is = VerifyLibsAndLicenses.class.getResourceAsStream(resource);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                patterns.add(line.replaceAll("/(?=( |$))", "/**"));
            }
        }
        finally {
            is.close();
        }
        return patterns;
    }

    private void testNoStrayThirdPartyBinaries() throws IOException {
        List<String> ignoredPatterns = VerifyLibsAndLicenses.loadPatterns("ignored-binaries");
        TreeSet<String> violations = new TreeSet<String>();
        this.findStrayThirdPartyBinaries(this.nball, "", violations, ignoredPatterns);
        if (violations.isEmpty()) {
            this.pseudoTests.put("testNoStrayThirdPartyBinaries", null);
        } else {
            StringBuffer msg = new StringBuffer("Some binaries were found outside of <module>/external/ directories");
            for (String v : violations) {
                msg.append("\n" + v);
            }
            this.pseudoTests.put("testNoStrayThirdPartyBinaries", msg.toString());
        }
    }

    private void findStrayThirdPartyBinaries(File dir, String prefix, Set<String> violations, List<String> ignoredPatterns) throws IOException {
        for (String n : VerifyLibsAndLicenses.findHgControlledFiles(dir)) {
            File f = new File(dir, n);
            if (f.isDirectory()) {
                this.findStrayThirdPartyBinaries(f, prefix + n + "/", violations, ignoredPatterns);
                continue;
            }
            if (!n.matches(".*\\.(jar|zip)")) continue;
            String path = prefix + n;
            boolean ignored = false;
            for (String pattern : ignoredPatterns) {
                if (!SelectorUtils.matchPath((String)pattern, (String)path)) continue;
                ignored = true;
                break;
            }
            if (!ignored && dir.getName().equals("external") && new File(new File(dir.getParentFile(), "nbproject"), "project.xml").isFile() && new File(dir.getParentFile(), "src").isDirectory()) {
                ignored = true;
            }
            if (ignored) continue;
            violations.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<String> findHgControlledFiles(File dir) throws IOException {
        List<Object> ignoredPatterns;
        File root;
        File[] kids = dir.listFiles();
        if (kids == null) {
            return Collections.emptySet();
        }
        String path = "";
        File hgignore = null;
        for (root = dir; root != null && !(hgignore = new File(root, ".hgignore")).isFile(); root = root.getParentFile()) {
            path = root.getName() + "/" + path;
        }
        Map<File, List<Pattern>> map = hgignores;
        synchronized (map) {
            if (root == null) {
                ignoredPatterns = Collections.emptyList();
            } else if (hgignores.containsKey(root)) {
                ignoredPatterns = hgignores.get(root);
            } else {
                ignoredPatterns = new ArrayList();
                FileReader r = new FileReader(hgignore);
                try {
                    String line;
                    BufferedReader br = new BufferedReader(r);
                    while ((line = br.readLine()) != null) {
                        ignoredPatterns.add(Pattern.compile(line));
                    }
                }
                finally {
                    ((Reader)r).close();
                }
                hgignores.put(root, ignoredPatterns);
            }
        }
        TreeSet<String> files = new TreeSet<String>();
        block11: for (File f : kids) {
            String n = f.getName();
            if (n.equals(".hg")) continue;
            String fullname = path + n;
            boolean isDir = f.isDirectory();
            if (isDir && new File(f, ".hg").isDirectory()) continue;
            for (Pattern pattern : ignoredPatterns) {
                if (!pattern.matcher(fullname).find() && (!isDir || !pattern.matcher(fullname + "/").find())) continue;
                continue block11;
            }
            files.add(n);
        }
        File list = new File(dir, "binaries-list");
        if (list.isFile()) {
            FileReader r = new FileReader(list);
            try {
                String line;
                BufferedReader br = new BufferedReader(r);
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().length() == 0) continue;
                    String[] hashAndFile = line.split(" ", 2);
                    if (hashAndFile.length < 2) {
                        throw new BuildException("Bad line '" + line + "' in " + list);
                    }
                    files.add(hashAndFile[1]);
                }
            }
            finally {
                ((Reader)r).close();
            }
        }
        return files;
    }
}

