/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ComparableConstant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassVisitor;

public class ConstantPoolSorter
implements ClassVisitor {
    private int[] constantIndexMap = new int[256];
    private ComparableConstant[] comparableConstantPool = new ComparableConstant[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        this.sortConstantPool(programClass, programClass.constantPool, programClass.u2constantPoolCount);
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private void sortConstantPool(Clazz clazz, Constant[] constantArray, int n) {
        if (this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
            this.comparableConstantPool = new ComparableConstant[n];
        }
        for (int i = 1; i < n; ++i) {
            Constant constant = constantArray[i];
            if (constant == null) {
                constant = constantArray[i - 1];
            }
            this.comparableConstantPool[i] = new ComparableConstant(clazz, i, constant);
        }
        Arrays.sort(this.comparableConstantPool, 1, n);
        Constant constant = null;
        for (int i = 1; i < n; ++i) {
            ComparableConstant comparableConstant = this.comparableConstantPool[i];
            int n2 = comparableConstant.getIndex();
            this.constantIndexMap[n2] = i;
            Constant constant2 = comparableConstant.getConstant();
            constantArray[i] = constant2 != constant ? constant2 : null;
            constant = constant2;
        }
    }
}

