/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ValueFactory;

final class SpecificFloatValue
extends FloatValue {
    private final float value;

    public SpecificFloatValue(float f) {
        this.value = f;
    }

    public float value() {
        return this.value;
    }

    public FloatValue generalize(FloatValue floatValue) {
        return floatValue.generalize(this);
    }

    public FloatValue add(FloatValue floatValue) {
        return floatValue.add(this);
    }

    public FloatValue subtract(FloatValue floatValue) {
        return floatValue.subtractFrom(this);
    }

    public FloatValue subtractFrom(FloatValue floatValue) {
        return floatValue.subtract(this);
    }

    public FloatValue multiply(FloatValue floatValue) {
        return floatValue.multiply(this);
    }

    public FloatValue divide(FloatValue floatValue) {
        return floatValue.divideOf(this);
    }

    public FloatValue divideOf(FloatValue floatValue) {
        return floatValue.divide(this);
    }

    public FloatValue remainder(FloatValue floatValue) {
        return floatValue.remainderOf(this);
    }

    public FloatValue remainderOf(FloatValue floatValue) {
        return floatValue.remainder(this);
    }

    public IntegerValue compare(FloatValue floatValue, ValueFactory valueFactory) {
        return floatValue.compareReverse(this, valueFactory);
    }

    public FloatValue negate() {
        return new SpecificFloatValue(-this.value);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return valueFactory.createIntegerValue((int)this.value);
    }

    public LongValue convertToLong(ValueFactory valueFactory) {
        return valueFactory.createLongValue((long)this.value);
    }

    public DoubleValue convertToDouble(ValueFactory valueFactory) {
        return valueFactory.createDoubleValue(this.value);
    }

    public FloatValue generalize(SpecificFloatValue specificFloatValue) {
        return this.value == specificFloatValue.value ? this : ValueFactory.FLOAT_VALUE;
    }

    public FloatValue add(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(this.value + specificFloatValue.value);
    }

    public FloatValue subtract(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(this.value - specificFloatValue.value);
    }

    public FloatValue subtractFrom(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(specificFloatValue.value - this.value);
    }

    public FloatValue multiply(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(this.value * specificFloatValue.value);
    }

    public FloatValue divide(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(this.value / specificFloatValue.value);
    }

    public FloatValue divideOf(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(specificFloatValue.value / this.value);
    }

    public FloatValue remainder(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(this.value % specificFloatValue.value);
    }

    public FloatValue remainderOf(SpecificFloatValue specificFloatValue) {
        return new SpecificFloatValue(specificFloatValue.value % this.value);
    }

    public IntegerValue compare(SpecificFloatValue specificFloatValue, ValueFactory valueFactory) {
        return this.value < specificFloatValue.value ? valueFactory.createIntegerValue(-1) : (this.value == specificFloatValue.value ? valueFactory.createIntegerValue(0) : valueFactory.createIntegerValue(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificFloatValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Float.floatToIntBits(this.value);
    }

    public String toString() {
        return "f:" + this.value;
    }
}

