/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.ImageLoaderUtil;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ImageLoader;
import com.sun.perseus.model.RasterImageConsumer;
import com.sun.perseus.platform.URLResolver;
import com.sun.perseus.util.RunnableQueue;
import java.util.Hashtable;

public class DefaultImageLoader
implements ImageLoader {
    protected Hashtable cache = new Hashtable();
    protected static RunnableQueue loadingQueue = RunnableQueue.createRunnableQueue(null);
    protected ImageLoaderUtil loaderUtil = new ImageLoaderUtil();

    public RasterImage getLoadingImage() {
        return this.loaderUtil.getLoadingImage();
    }

    public RasterImage getBrokenImage() {
        return this.loaderUtil.getBrokenImage();
    }

    public String resolveURI(String uri, String baseURI) {
        if (uri == null) {
            return null;
        }
        if (this.loaderUtil.isDataURI(uri)) {
            return uri;
        }
        try {
            return URLResolver.resolve(baseURI, uri);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void needsURI(String absoluteURI) {
        if (!this.loaderUtil.isDataURI(absoluteURI)) {
            Hashtable hashtable = this.cache;
            synchronized (hashtable) {
                if (this.cache.get(absoluteURI) == null) {
                    loadingQueue.invokeLater(new ImageLoadRunnable(absoluteURI), null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImage getImageAndWait(String uri) {
        if (this.loaderUtil.isDataURI(uri)) {
            return this.loaderUtil.getEmbededImage(uri);
        }
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            RasterImage img = (RasterImage)this.cache.get(uri);
            if (img != null) {
                return img;
            }
        }
        ImageLoadRunnable loader = new ImageLoadRunnable(uri);
        try {
            loadingQueue.preemptAndWait(loader, null);
        }
        catch (InterruptedException ie) {
            return this.loaderUtil.getBrokenImage();
        }
        Hashtable hashtable2 = this.cache;
        synchronized (hashtable2) {
            return (RasterImage)this.cache.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImageLater(String uri, RasterImageConsumer imageNode) {
        if (this.loaderUtil.isDataURI(uri)) {
            imageNode.setImage(this.loaderUtil.getEmbededImage(uri), uri);
            return;
        }
        RasterImage img = null;
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            img = (RasterImage)this.cache.get(uri);
        }
        if (img != null) {
            imageNode.setImage(img, uri);
            return;
        }
        ImageLoadRunnable loader = new ImageLoadRunnable(uri, imageNode);
        loadingQueue.invokeLater(loader, null);
    }

    public boolean allowsRelativeURI() {
        return false;
    }

    public void documentLoaded(DocumentNode doc) {
    }

    public void addRasterImageConsumer(String absoluteURI, RasterImageConsumer imageNode) {
    }

    public void removeRasterImageConsumer(String absoluteURI, RasterImageConsumer imageNode) {
    }

    public void waitForAll() throws InterruptedException {
        loadingQueue.invokeAndWait(new Runnable(){

            public void run() {
            }
        }, null);
    }

    static {
        loadingQueue.resumeExecution();
    }

    static class ImageSetter
    implements Runnable {
        private RasterImage img;
        private RasterImageConsumer node;
        private String uri;

        public ImageSetter(RasterImage img, RasterImageConsumer node, String uri) {
            this.img = img;
            this.node = node;
            this.uri = uri;
        }

        public void run() {
            this.node.setImage(this.img, this.uri);
        }
    }

    class ImageLoadRunnable
    implements Runnable {
        private String uri;
        private RasterImageConsumer node;

        public ImageLoadRunnable(String uri) {
            this.uri = uri;
        }

        public ImageLoadRunnable(String uri, RasterImageConsumer node) {
            this.uri = uri;
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RasterImage img = null;
            Hashtable hashtable = DefaultImageLoader.this.cache;
            synchronized (hashtable) {
                img = (RasterImage)DefaultImageLoader.this.cache.get(this.uri);
            }
            if (img == null) {
                img = DefaultImageLoader.this.loaderUtil.getExternalImage(this.uri);
                hashtable = DefaultImageLoader.this.cache;
                synchronized (hashtable) {
                    DefaultImageLoader.this.cache.put(this.uri, img);
                }
            }
            if (this.node != null) {
                if (this.node.getUpdateQueue() != null) {
                    ImageSetter setter = new ImageSetter(img, this.node, this.uri);
                    try {
                        this.node.getUpdateQueue().invokeAndWait(setter, this.node.getRunnableHandler());
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                } else {
                    this.node.setImage(img, this.uri);
                }
            }
        }
    }
}

