/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.FloatSegment;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.Segment;

public class FloatRefValues
implements RefValues {
    FloatSegment[] segments;
    float[][] w;
    float length;
    float[] segLength;

    public Segment getSegment(int i) {
        return this.segments[i];
    }

    public int getSegments() {
        return this.segments.length;
    }

    public int getComponents() {
        return this.segments[0].start.length;
    }

    public Object[] compute(int si, float p) {
        this.segments[si].compute(p, this.w);
        return this.w;
    }

    public void makeDiscrete() {
        FloatSegment[] tmpSegments = new FloatSegment[this.segments.length + 1];
        System.arraycopy(this.segments, 0, tmpSegments, 0, this.segments.length);
        FloatSegment lastSeg = this.segments[this.segments.length - 1];
        FloatSegment newSeg = new FloatSegment();
        newSeg.start = lastSeg.end;
        newSeg.end = lastSeg.end;
        tmpSegments[tmpSegments.length - 1] = newSeg;
        this.segments = tmpSegments;
    }

    public float getLength() {
        return this.length;
    }

    public float getLength(int si) {
        return this.segLength[si];
    }

    public void initialize() {
        int si;
        int nc = this.segments[0].start.length;
        this.w = new float[nc][];
        int ns = this.segments.length;
        for (si = 0; si < ns; ++si) {
            this.segments[si].initialize();
        }
        this.segLength = new float[ns];
        for (int ci = 0; ci < nc; ++ci) {
            this.w[ci] = new float[this.segments[0].start[ci].length];
        }
        this.length = 0.0f;
        for (si = 0; si < ns; ++si) {
            this.segLength[si] = this.segments[si].getLength();
            this.length += this.segLength[si];
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FloatRefValues[" + this.getSegments() + "]\n");
        for (int si = 0; si < this.getSegments(); ++si) {
            Segment seg = this.getSegment(si);
            sb.append("seg[" + si + "] : " + seg.toString() + "\n");
        }
        return sb.toString();
    }
}

