/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.support.ContextExposingHttpServletRequest;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

public class InternalResourceView
extends AbstractUrlBasedView {
    private boolean alwaysInclude = false;
    private boolean exposeContextBeansAsAttributes = false;

    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        super(url);
    }

    public InternalResourceView(String url, boolean alwaysInclude) {
        super(url);
        this.alwaysInclude = alwaysInclude;
    }

    public void setAlwaysInclude(boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
    }

    public void setExposeContextBeansAsAttributes(boolean exposeContextBeansAsAttributes) {
        this.exposeContextBeansAsAttributes = exposeContextBeansAsAttributes;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpServletRequest requestToExpose = this.getRequestToExpose(request);
        this.exposeModelAsRequestAttributes(model, requestToExpose);
        this.exposeHelpers(requestToExpose);
        String dispatcherPath = this.prepareForRendering(requestToExpose, response);
        RequestDispatcher rd = requestToExpose.getRequestDispatcher(dispatcherPath);
        if (rd == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: check that this file exists within your WAR");
        }
        if (this.useInclude(requestToExpose, response)) {
            response.setContentType(this.getContentType());
            rd.include((ServletRequest)requestToExpose, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Included resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
        } else {
            this.exposeForwardRequestAttributes(requestToExpose);
            rd.forward((ServletRequest)requestToExpose, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarded to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
        }
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getUrl();
    }

    protected HttpServletRequest getRequestToExpose(HttpServletRequest originalRequest) {
        if (this.exposeContextBeansAsAttributes && !(originalRequest instanceof ContextExposingHttpServletRequest)) {
            return new ContextExposingHttpServletRequest(originalRequest, this.getWebApplicationContext());
        }
        return originalRequest;
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return this.alwaysInclude || WebUtils.isIncludeRequest((ServletRequest)request) || response.isCommitted();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest request) {
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
    }
}

