/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.Assert;

public class TransactionAwareDataSourceProxy
extends DelegatingDataSource {
    public TransactionAwareDataSourceProxy() {
    }

    public TransactionAwareDataSourceProxy(DataSource targetDataSource) {
        super(targetDataSource);
    }

    public Connection getConnection() throws SQLException {
        Assert.state(this.getTargetDataSource() != null, "'targetDataSource' is required");
        Connection con = DataSourceUtils.doGetConnection(this.getTargetDataSource());
        return this.getTransactionAwareConnectionProxy(con, this.getTargetDataSource());
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target, DataSource dataSource) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new TransactionAwareInvocationHandler(target, dataSource));
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final DataSource dataSource;

        public TransactionAwareInvocationHandler(Connection target, DataSource dataSource) {
            this.target = target;
            this.dataSource = dataSource;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("toString")) {
                return "Transaction-aware proxy for target Connection [" + this.target.toString() + "]";
            }
            if (method.getName().equals("close")) {
                DataSourceUtils.doReleaseConnection(this.target, this.dataSource);
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Statement) {
                    DataSourceUtils.applyTransactionTimeout((Statement)retVal, this.dataSource);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

