/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.logger;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.shale.remoting.logger.AbstractLogger;

public final class JdkLogger
extends AbstractLogger {
    private Map loggers = new HashMap();

    public boolean isTraceEnabled(String name) {
        return this.logger(name).isLoggable(Level.FINEST);
    }

    public boolean isDebugEnabled(String name) {
        return this.logger(name).isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled(String name) {
        return this.logger(name).isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled(String name) {
        return this.logger(name).isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled(String name) {
        return this.logger(name).isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled(String name) {
        return this.logger(name).isLoggable(Level.SEVERE);
    }

    public void trace(String name, String message, Throwable exception, Object[] params) {
        if (exception == null) {
            this.logger(name).log(Level.FINEST, this.message(message, params));
        } else {
            this.logger(name).log(Level.FINEST, this.message(message, params), exception);
        }
    }

    public void debug(String name, String message, Throwable exception, Object[] params) {
        if (exception == null) {
            this.logger(name).log(Level.FINE, this.message(message, params));
        } else {
            this.logger(name).log(Level.FINE, this.message(message, params), exception);
        }
    }

    public void info(String name, String message, Throwable exception, Object[] params) {
        if (exception == null) {
            this.logger(name).log(Level.INFO, this.message(message, params));
        } else {
            this.logger(name).log(Level.INFO, this.message(message, params), exception);
        }
    }

    public void warn(String name, String message, Throwable exception, Object[] params) {
        if (exception == null) {
            this.logger(name).log(Level.WARNING, this.message(message, params));
        } else {
            this.logger(name).log(Level.WARNING, this.message(message, params), exception);
        }
    }

    public void error(String name, String message, Throwable exception, Object[] params) {
        if (exception == null) {
            this.logger(name).log(Level.SEVERE, this.message(message, params));
        } else {
            this.logger(name).log(Level.SEVERE, this.message(message, params), exception);
        }
    }

    public void fatal(String name, String message, Throwable exception, Object[] params) {
        if (exception == null) {
            this.logger(name).log(Level.SEVERE, this.message(message, params));
        } else {
            this.logger(name).log(Level.SEVERE, this.message(message, params), exception);
        }
    }

    private synchronized Logger logger(String name) {
        Logger logger = (Logger)this.loggers.get(name);
        if (logger == null) {
            logger = LogManager.getLogManager().getLogger(name);
            this.loggers.put(name, logger);
        }
        return logger;
    }
}

