/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.monitor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;

public abstract class MonitorTestCase
extends CommonProfilerTestCase {
    static final byte ST_UNKNOWN = 1;
    static final byte ST_ZOMBIE = 2;
    static final byte ST_RUNNING = 4;
    static final byte ST_SLEEPING = 8;
    static final byte ST_MONITOR = 16;
    static final byte ST_WAIT = 32;
    static final int MONITOR_ONLY = 0;
    static final int WITH_CPU = 1;
    static final int WITH_MEMORY = 2;
    static final int WITH_CODEREGION = 3;

    public MonitorTestCase(String name) {
        super(name);
    }

    protected char getState(byte state) {
        if (state == 1) {
            return 'U';
        }
        if (state == 2) {
            return 'Z';
        }
        if (state == 4) {
            return 'R';
        }
        if (state == 8) {
            return 'S';
        }
        if (state == 16) {
            return 'M';
        }
        if (state == 32) {
            return 'W';
        }
        return '-';
    }

    protected String getStates(byte[] states) {
        StringBuffer sb = new StringBuffer(states.length);
        for (int i = 0; i < states.length; ++i) {
            sb.append(this.getState(states[i]));
        }
        return sb.toString();
    }

    protected void detectStates(byte[] states, byte[] detectStates) {
        int detectionindex = 0;
        for (int i = 0; i < states.length; ++i) {
            if ((states[i] & detectStates[detectionindex]) != 0 || ++detectionindex < detectStates.length && (states[i] & detectStates[detectionindex]) != 0) continue;
            this.log("\n*********NOT MATCHING STATES");
            this.log(this.getStates(states));
            this.log("Matching states: " + this.getStates(detectStates));
            this.log("Wrong state " + this.getState(states[i]) + " index " + i);
            MonitorTestCase.assertTrue((String)"States do not match with pattern", (boolean)false);
        }
    }

    protected ProfilerEngineSettings initMonitorTest(String projectName, String className) {
        ProfilerEngineSettings settings = this.initTest(projectName, className, null);
        settings.setThreadCPUTimerOn(false);
        return settings;
    }

    protected void logLongs(long[] longs, int count) {
        double average = 0.0;
        long max = 0L;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            average += (double)longs[i];
            if (max < longs[i]) {
                max = longs[i];
            }
            if (min <= longs[i]) continue;
            min = longs[i];
        }
        this.log("Average = " + (average /= (double)count) + " Max = " + max + " Min = " + min + " Values = " + count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMonitorTest(ProfilerEngineSettings settings, int times, long delay, String[] detects, byte[][] detectstates, int profilingType) {
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)new TestProfilerAppHandler(this), (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        try {
            runner.readSavedCalibrationData();
            Process p = this.startTargetVM(runner);
            MonitorTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            if (profilingType == 1) {
                runner.getProfilerClient().initiateRecursiveCPUProfInstrumentation(settings.getInstrumentationRootMethods());
            } else if (profilingType == 2) {
                runner.getProfilerClient().initiateMemoryProfInstrumentation(5);
            } else if (profilingType == 3) {
                runner.getProfilerClient().initiateCodeRegionInstrumentation(settings.getInstrumentationRootMethods());
            }
            assert (runner.targetAppIsRunning());
            this.waitForStatus(1);
            VMTelemetryDataManager dataManager = new VMTelemetryDataManager();
            dataManager.setArrayBufferSize(10);
            ThreadsDataManager threadsManager = new ThreadsDataManager();
            for (int cntr = 0; cntr < times; ++cntr) {
                Thread.sleep(delay);
                if (this.isStatus(4) || !runner.targetJVMIsAlive()) break;
                runner.getProfilerClient().forceObtainedResultsDump();
                MonitoredData data = runner.getProfilerClient().getMonitoredData();
                dataManager.processData(data);
                threadsManager.processData(data);
            }
            this.setStatus(8);
            HashMap<String, byte[]> threads = new HashMap<String, byte[]>(32);
            HashMap<String, Long> timestamps = new HashMap<String, Long>(32);
            MonitorTestCase.assertTrue((String)"Threads manager has not data", (boolean)threadsManager.hasData());
            int statesNumber = 128;
            long deltat = threadsManager.getEndTime() - threadsManager.getStartTime();
            double tick = (double)deltat / (double)statesNumber;
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < threadsManager.getThreadsCount(); ++i) {
                ThreadData td = threadsManager.getThreadData(i);
                if (td.getName().equals("process reaper") || td.getName().equals("DestroyJavaVM")) continue;
                byte[] states = new byte[statesNumber];
                String n = td.getName() + ", class: " + td.getClassName();
                byte state = 1;
                long time = threadsManager.getStartTime();
                int tdindex = 0;
                for (int j = 0; j < states.length; ++j) {
                    if (tdindex < td.size() && time >= td.getTimeStampAt(tdindex)) {
                        state = this.toBinState(td.getStateAt(tdindex));
                        Color color = td.getThreadStateColorAt(tdindex);
                        MonitorTestCase.assertNotNull((String)"Threads state color is null", (Object)color);
                        ++tdindex;
                    }
                    states[j] = state;
                    time = (long)((double)j * tick + (double)threadsManager.getStartTime());
                }
                td.clearStates();
                MonitorTestCase.assertTrue((String)"Error in threadData.clearStates", (td.size() == 0 ? 1 : 0) != 0);
                names.add(td.getName());
                threads.put(n, states);
                timestamps.put(n, new Long(td.getFirstTimeStamp()));
            }
            Object[] keys = threads.keySet().toArray(new String[threads.size()]);
            Arrays.sort(keys);
            Collections.sort(names);
            for (int i = 0; i < names.size(); ++i) {
                this.ref(names.get(i));
            }
            Object ret = null;
            boolean maxindex = false;
            for (int i = 0; i < keys.length; ++i) {
                byte[] sts = (byte[])threads.get(keys[i]);
                this.log((String)keys[i]);
                this.log(this.getStates(sts));
                for (int j = 0; j < detects.length; ++j) {
                    if (!((String)keys[i]).startsWith(detects[j])) continue;
                    this.detectStates(sts, detectstates[j]);
                }
            }
            MonitorTestCase.assertEquals((String)"Some threads are multiple - issue 68266", (int)names.size(), (int)keys.length);
            this.log("\nDataManager item counts " + dataManager.getItemCount());
            this.log("Free Memory");
            this.logLongs(dataManager.freeMemory, dataManager.getItemCount());
            this.log("lastGCPauseInMS");
            this.logLongs(dataManager.lastGCPauseInMS, dataManager.getItemCount());
            this.log("nSurvivingGenerations");
            this.logLongs(dataManager.nSurvivingGenerations, dataManager.getItemCount());
            this.log("nSystemThreads");
            this.logLongs(dataManager.nSystemThreads, dataManager.getItemCount());
            this.log("nTotalThreads");
            this.logLongs(dataManager.nTotalThreads, dataManager.getItemCount());
            this.log("nUserThreads");
            this.logLongs(dataManager.nUserThreads, dataManager.getItemCount());
            this.log("relativeGCTimeInPerMil");
            this.logLongs(dataManager.relativeGCTimeInPerMil, dataManager.getItemCount());
            this.log("timeStamps");
            this.logLongs(dataManager.timeStamps, dataManager.getItemCount());
            this.log("totalMemory");
            this.logLongs(dataManager.totalMemory, dataManager.getItemCount());
            this.log("usedMemory");
            this.logLongs(dataManager.usedMemory, dataManager.getItemCount());
        }
        catch (Exception ex) {
            this.log(ex);
            MonitorTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            this.finalizeTest(runner);
        }
    }

    protected byte toBinState(byte state) {
        if (state == -1) {
            return 1;
        }
        if (state == 0) {
            return 2;
        }
        if (state == 1) {
            return 4;
        }
        if (state == 2) {
            return 8;
        }
        if (state == 3) {
            return 16;
        }
        if (state == 4) {
            return 32;
        }
        return 0;
    }
}

