/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.UploadFileSpec;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class URLEncodedString
implements ParameterProcessor {
    private StringBuffer _buffer = new StringBuffer(128);
    private boolean _haveParameters = false;

    URLEncodedString() {
    }

    public String getString() {
        return this._buffer.toString();
    }

    public void addParameter(String name, String value, String characterSet) {
        if (this._haveParameters) {
            this._buffer.append('&');
        }
        this._buffer.append(this.encode(name, characterSet));
        if (value != null) {
            this._buffer.append('=').append(this.encode(value, characterSet));
        }
        this._haveParameters = true;
    }

    public void addFile(String parameterName, UploadFileSpec fileSpec) {
        throw new RuntimeException("May not URL-encode a file upload request");
    }

    private String encode(String source, String characterSet) {
        if (characterSet.equalsIgnoreCase("iso-8859-1")) {
            return URLEncoder.encode(source);
        }
        try {
            byte[] rawBytes = source.getBytes(characterSet);
            StringBuffer result = new StringBuffer(3 * rawBytes.length);
            for (int i = 0; i < rawBytes.length; ++i) {
                int candidate = rawBytes[i] & 0xFF;
                if (candidate == 32) {
                    result.append('+');
                    continue;
                }
                if (candidate >= 65 && candidate <= 90 || candidate >= 97 && candidate <= 122 || candidate == 46 || candidate == 45 || candidate == 42 || candidate == 95 || candidate >= 48 && candidate <= 57) {
                    result.append((char)rawBytes[i]);
                    continue;
                }
                if (candidate < 16) {
                    result.append("%0").append(Integer.toHexString(candidate).toUpperCase());
                    continue;
                }
                result.append('%').append(Integer.toHexString(candidate).toUpperCase());
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            return "???";
        }
    }
}

