/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final AugmentVisitor augmentor;
    private final EnumSet<LintCategory> values;
    private final EnumSet<LintCategory> suppressedValues;
    private static Map<String, LintCategory> map = new HashMap<String, LintCategory>();

    public static Lint instance(Context context) {
        Lint instance = context.get(lintKey);
        if (instance == null) {
            instance = new Lint(context);
        }
        return instance;
    }

    public Lint augment(Attribute.Compound attr) {
        return this.augmentor.augment(this, attr);
    }

    public Lint augment(List<Attribute.Compound> attrs) {
        return this.augmentor.augment(this, attrs);
    }

    public Lint augment(List<Attribute.Compound> attrs, long flags) {
        Lint l = this.augmentor.augment(this, attrs);
        if ((flags & 0x20000L) != 0L) {
            if (l == this) {
                l = new Lint(this);
            }
            l.values.remove((Object)LintCategory.DEPRECATION);
            l.suppressedValues.add(LintCategory.DEPRECATION);
        }
        return l;
    }

    protected Lint(Context context) {
        Options options = Options.instance(context);
        this.values = EnumSet.noneOf(LintCategory.class);
        for (Map.Entry<String, LintCategory> e : map.entrySet()) {
            if (!options.lint(e.getKey())) continue;
            this.values.add(e.getValue());
        }
        this.suppressedValues = EnumSet.noneOf(LintCategory.class);
        context.put(lintKey, this);
        this.augmentor = new AugmentVisitor(context);
    }

    protected Lint(Lint other) {
        this.augmentor = other.augmentor;
        this.values = other.values.clone();
        this.suppressedValues = other.suppressedValues.clone();
    }

    public String toString() {
        return "Lint:[values" + this.values + " suppressedValues" + this.suppressedValues + "]";
    }

    public boolean isEnabled(LintCategory lc) {
        return this.values.contains((Object)lc);
    }

    public boolean isSuppressed(LintCategory lc) {
        return this.suppressedValues.contains((Object)lc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AugmentVisitor
    implements Attribute.Visitor {
        private final Context context;
        private Symtab syms;
        private Lint parent;
        private Lint lint;

        AugmentVisitor(Context context) {
            this.context = context;
        }

        Lint augment(Lint parent, Attribute.Compound attr) {
            this.initSyms();
            this.parent = parent;
            this.lint = null;
            attr.accept(this);
            return this.lint == null ? parent : this.lint;
        }

        Lint augment(Lint parent, List<Attribute.Compound> attrs) {
            this.initSyms();
            this.parent = parent;
            this.lint = null;
            for (Attribute.Compound a : attrs) {
                a.accept(this);
            }
            return this.lint == null ? parent : this.lint;
        }

        private void initSyms() {
            if (this.syms == null) {
                this.syms = Symtab.instance(this.context);
            }
        }

        private void suppress(LintCategory lc) {
            if (this.lint == null) {
                this.lint = new Lint(this.parent);
            }
            this.lint.suppressedValues.add(lc);
            this.lint.values.remove((Object)lc);
        }

        @Override
        public void visitConstant(Attribute.Constant value) {
            LintCategory lc;
            if (value.type.tsym == this.syms.stringType.tsym && (lc = LintCategory.get((String)value.value)) != null) {
                this.suppress(lc);
            }
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            if (compound.type.tsym == this.syms.suppressWarningsType.tsym) {
                List<Pair<Symbol.MethodSymbol, Attribute>> v = compound.values;
                while (v.nonEmpty()) {
                    Pair value = (Pair)v.head;
                    if (((Symbol.MethodSymbol)value.fst).name.toString().equals("value")) {
                        ((Attribute)value.snd).accept(this);
                    }
                    v = v.tail;
                }
            }
        }

        @Override
        public void visitArray(Attribute.Array array) {
            for (Attribute value : array.values) {
                value.accept(this);
            }
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
        }

        @Override
        public void visitError(Attribute.Error e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LintCategory {
        CAST("cast"),
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann"),
        DIVZERO("divzero"),
        EMPTY("empty"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        OVERRIDES("overrides"),
        PATH("path"),
        SERIAL("serial"),
        UNCHECKED("unchecked");

        private final String option;

        private LintCategory(String option) {
            this.option = option;
            map.put(option, this);
        }

        static LintCategory get(String option) {
            return (LintCategory)((Object)map.get(option));
        }
    }
}

