/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.SourceVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecognizedOptions {
    static Set<OptionName> javacOptions = EnumSet.of(OptionName.G, new OptionName[]{OptionName.G_NONE, OptionName.G_CUSTOM, OptionName.XLINT, OptionName.XLINT_CUSTOM, OptionName.NOWARN, OptionName.VERBOSE, OptionName.DEPRECATION, OptionName.CLASSPATH, OptionName.CP, OptionName.SOURCEPATH, OptionName.BOOTCLASSPATH, OptionName.XBOOTCLASSPATH_PREPEND, OptionName.XBOOTCLASSPATH_APPEND, OptionName.XBOOTCLASSPATH, OptionName.EXTDIRS, OptionName.DJAVA_EXT_DIRS, OptionName.ENDORSEDDIRS, OptionName.DJAVA_ENDORSED_DIRS, OptionName.PROC_CUSTOM, OptionName.PROCESSOR, OptionName.PROCESSORPATH, OptionName.D, OptionName.S, OptionName.IMPLICIT, OptionName.ENCODING, OptionName.SOURCE, OptionName.TARGET, OptionName.VERSION, OptionName.FULLVERSION, OptionName.HELP, OptionName.A, OptionName.X, OptionName.J, OptionName.MOREINFO, OptionName.WERROR, OptionName.PROMPT, OptionName.DOE, OptionName.PRINTSOURCE, OptionName.WARNUNCHECKED, OptionName.XMAXERRS, OptionName.XMAXWARNS, OptionName.XSTDOUT, OptionName.XPRINT, OptionName.XPRINTROUNDS, OptionName.XPRINTPROCESSORINFO, OptionName.XPREFER, OptionName.O, OptionName.XJCOV, OptionName.XD, OptionName.SOURCEFILE});
    static Set<OptionName> javacFileManagerOptions = EnumSet.of(OptionName.CLASSPATH, new OptionName[]{OptionName.CP, OptionName.SOURCEPATH, OptionName.BOOTCLASSPATH, OptionName.XBOOTCLASSPATH_PREPEND, OptionName.XBOOTCLASSPATH_APPEND, OptionName.XBOOTCLASSPATH, OptionName.EXTDIRS, OptionName.DJAVA_EXT_DIRS, OptionName.ENDORSEDDIRS, OptionName.DJAVA_ENDORSED_DIRS, OptionName.PROCESSORPATH, OptionName.D, OptionName.S, OptionName.ENCODING, OptionName.SOURCE});
    static Set<OptionName> javacToolOptions = EnumSet.of(OptionName.G, new OptionName[]{OptionName.G_NONE, OptionName.G_CUSTOM, OptionName.XLINT, OptionName.XLINT_CUSTOM, OptionName.NOWARN, OptionName.VERBOSE, OptionName.DEPRECATION, OptionName.PROC_CUSTOM, OptionName.PROCESSOR, OptionName.IMPLICIT, OptionName.SOURCE, OptionName.TARGET, OptionName.A, OptionName.MOREINFO, OptionName.WERROR, OptionName.PROMPT, OptionName.DOE, OptionName.PRINTSOURCE, OptionName.WARNUNCHECKED, OptionName.XMAXERRS, OptionName.XMAXWARNS, OptionName.XPRINT, OptionName.XPRINTROUNDS, OptionName.XPRINTPROCESSORINFO, OptionName.XPREFER, OptionName.O, OptionName.XJCOV, OptionName.XD});

    private RecognizedOptions() {
    }

    static JavacOption.Option[] getJavaCompilerOptions(OptionHelper helper) {
        return RecognizedOptions.getOptions(helper, javacOptions);
    }

    public static JavacOption.Option[] getJavacFileManagerOptions(OptionHelper helper) {
        return RecognizedOptions.getOptions(helper, javacFileManagerOptions);
    }

    public static JavacOption.Option[] getJavacToolOptions(OptionHelper helper) {
        return RecognizedOptions.getOptions(helper, javacToolOptions);
    }

    static JavacOption.Option[] getOptions(OptionHelper helper, Set<OptionName> desired) {
        ListBuffer<JavacOption.Option> options = new ListBuffer<JavacOption.Option>();
        for (JavacOption.Option option : RecognizedOptions.getAll(helper)) {
            if (!desired.contains((Object)option.getName())) continue;
            options.append(option);
        }
        return options.toArray(new JavacOption.Option[options.length()]);
    }

    public static JavacOption.Option[] getAll(final OptionHelper helper) {
        return new JavacOption.Option[]{new JavacOption.Option(OptionName.G, "opt.g"), new JavacOption.Option(OptionName.G_NONE, "opt.g.none"){

            public boolean process(Options options, String option) {
                options.put("-g:", "none");
                return false;
            }
        }, new JavacOption.Option(OptionName.G_CUSTOM, "opt.g.lines.vars.source"){

            public boolean matches(String s) {
                return s.startsWith("-g:");
            }

            public boolean process(Options options, String option) {
                String suboptions = option.substring(3);
                options.put("-g:", suboptions);
                StringTokenizer t = new StringTokenizer(suboptions, ",");
                while (t.hasMoreTokens()) {
                    String tok = t.nextToken();
                    String opt = "-g:" + tok;
                    options.put(opt, opt);
                }
                return false;
            }
        }, new JavacOption.XOption(OptionName.XLINT, "opt.Xlint"), new JavacOption.XOption(OptionName.XLINT_CUSTOM, "opt.Xlint.suboptlist"){

            public boolean matches(String s) {
                return s.startsWith("-Xlint:");
            }

            public boolean process(Options options, String option) {
                String suboptions = option.substring(7);
                options.put("-Xlint:", suboptions);
                StringTokenizer t = new StringTokenizer(suboptions, ",");
                while (t.hasMoreTokens()) {
                    String tok = t.nextToken();
                    String opt = "-Xlint:" + tok;
                    options.put(opt, opt);
                }
                return false;
            }
        }, new JavacOption.Option(OptionName.NOWARN, "opt.nowarn"){

            public boolean process(Options options, String option) {
                options.put("-Xlint:none", option);
                return false;
            }
        }, new JavacOption.Option(OptionName.VERBOSE, "opt.verbose"), new JavacOption.Option(OptionName.DEPRECATION, "opt.deprecation"){

            public boolean process(Options options, String option) {
                options.put("-Xlint:deprecation", option);
                return false;
            }
        }, new JavacOption.Option(OptionName.CLASSPATH, "opt.arg.path", "opt.classpath"), new JavacOption.Option(OptionName.CP, "opt.arg.path", "opt.classpath"){

            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-classpath", arg);
            }
        }, new JavacOption.Option(OptionName.SOURCEPATH, "opt.arg.path", "opt.sourcepath"), new JavacOption.Option(OptionName.BOOTCLASSPATH, "opt.arg.path", "opt.bootclasspath"){

            public boolean process(Options options, String option, String arg) {
                options.remove("-Xbootclasspath/p:");
                options.remove("-Xbootclasspath/a:");
                return super.process(options, option, arg);
            }
        }, new JavacOption.XOption(OptionName.XBOOTCLASSPATH_PREPEND, "opt.arg.path", "opt.Xbootclasspath.p"), new JavacOption.XOption(OptionName.XBOOTCLASSPATH_APPEND, "opt.arg.path", "opt.Xbootclasspath.a"), new JavacOption.XOption(OptionName.XBOOTCLASSPATH, "opt.arg.path", "opt.bootclasspath"){

            public boolean process(Options options, String option, String arg) {
                options.remove("-Xbootclasspath/p:");
                options.remove("-Xbootclasspath/a:");
                return super.process(options, "-bootclasspath", arg);
            }
        }, new JavacOption.Option(OptionName.EXTDIRS, "opt.arg.dirs", "opt.extdirs"), new JavacOption.XOption(OptionName.DJAVA_EXT_DIRS, "opt.arg.dirs", "opt.extdirs"){

            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-extdirs", arg);
            }
        }, new JavacOption.Option(OptionName.ENDORSEDDIRS, "opt.arg.dirs", "opt.endorseddirs"), new JavacOption.XOption(OptionName.DJAVA_ENDORSED_DIRS, "opt.arg.dirs", "opt.endorseddirs"){

            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-endorseddirs", arg);
            }
        }, new JavacOption.Option(OptionName.PROC_CUSTOM, "opt.proc.none.only"){

            public boolean matches(String s) {
                return s.equals("-proc:none") || s.equals("-proc:only");
            }

            public boolean process(Options options, String option) {
                if (option.equals("-proc:none")) {
                    options.remove("-proc:only");
                } else {
                    options.remove("-proc:none");
                }
                options.put(option, option);
                return false;
            }
        }, new JavacOption.Option(OptionName.PROCESSOR, "opt.arg.class.list", "opt.processor"), new JavacOption.Option(OptionName.PROCESSORPATH, "opt.arg.path", "opt.processorpath"), new JavacOption.Option(OptionName.D, "opt.arg.directory", "opt.d"), new JavacOption.Option(OptionName.S, "opt.arg.directory", "opt.sourceDest"), new JavacOption.Option(OptionName.IMPLICIT, "opt.implicit"){

            public boolean matches(String s) {
                return s.equals("-implicit:none") || s.equals("-implicit:class");
            }

            public boolean process(Options options, String option, String operand) {
                int sep = option.indexOf(":");
                options.put(option.substring(0, sep), option.substring(sep + 1));
                options.put(option, option);
                return false;
            }
        }, new JavacOption.Option(OptionName.ENCODING, "opt.arg.encoding", "opt.encoding"), new JavacOption.Option(OptionName.SOURCE, "opt.arg.release", "opt.source"){

            public boolean process(Options options, String option, String operand) {
                Source source = Source.lookup(operand);
                if (source == null) {
                    helper.error("err.invalid.source", operand);
                    return true;
                }
                return super.process(options, option, operand);
            }
        }, new JavacOption.Option(OptionName.TARGET, "opt.arg.release", "opt.target"){

            public boolean process(Options options, String option, String operand) {
                Target target = Target.lookup(operand);
                if (target == null) {
                    helper.error("err.invalid.target", operand);
                    return true;
                }
                return super.process(options, option, operand);
            }
        }, new JavacOption.Option(OptionName.VERSION, "opt.version"){

            public boolean process(Options options, String option) {
                helper.printVersion();
                return super.process(options, option);
            }
        }, new JavacOption.HiddenOption(OptionName.FULLVERSION){

            public boolean process(Options options, String option) {
                helper.printFullVersion();
                return super.process(options, option);
            }
        }, new JavacOption.Option(OptionName.HELP, "opt.help"){

            public boolean process(Options options, String option) {
                helper.printHelp();
                return super.process(options, option);
            }
        }, new JavacOption.Option(OptionName.A, "opt.arg.key.equals.value", "opt.A"){

            String helpSynopsis() {
                this.hasSuffix = true;
                return super.helpSynopsis();
            }

            public boolean matches(String arg) {
                return arg.startsWith("-A");
            }

            public boolean hasArg() {
                return false;
            }

            public boolean process(Options options, String option) {
                int argLength = option.length();
                if (argLength == 2) {
                    helper.error("err.empty.A.argument", new Object[0]);
                    return true;
                }
                int sepIndex = option.indexOf(61);
                String key = option.substring(2, sepIndex != -1 ? sepIndex : argLength);
                if (!JavacProcessingEnvironment.isValidOptionName(key)) {
                    helper.error("err.invalid.A.key", option);
                    return true;
                }
                return this.process(options, option, option);
            }
        }, new JavacOption.Option(OptionName.X, "opt.X"){

            public boolean process(Options options, String option) {
                helper.printXhelp();
                return super.process(options, option);
            }
        }, new JavacOption.Option(OptionName.J, "opt.arg.flag", "opt.J"){

            String helpSynopsis() {
                this.hasSuffix = true;
                return super.helpSynopsis();
            }

            public boolean process(Options options, String option) {
                throw new AssertionError((Object)"the -J flag should be caught by the launcher.");
            }
        }, new JavacOption.HiddenOption(OptionName.MOREINFO){

            public boolean process(Options options, String option) {
                Type.moreInfo = true;
                return super.process(options, option);
            }
        }, new JavacOption.HiddenOption(OptionName.WERROR), new JavacOption.HiddenOption(OptionName.COMPLEXINFERENCE), new JavacOption.HiddenOption(OptionName.PROMPT), new JavacOption.HiddenOption(OptionName.DOE), new JavacOption.HiddenOption(OptionName.PRINTSOURCE), new JavacOption.HiddenOption(OptionName.WARNUNCHECKED){

            public boolean process(Options options, String option) {
                options.put("-Xlint:unchecked", option);
                return false;
            }
        }, new JavacOption.XOption(OptionName.XMAXERRS, "opt.arg.number", "opt.maxerrs"), new JavacOption.XOption(OptionName.XMAXWARNS, "opt.arg.number", "opt.maxwarns"), new JavacOption.XOption(OptionName.XSTDOUT, "opt.arg.file", "opt.Xstdout"){

            public boolean process(Options options, String option, String arg) {
                try {
                    helper.setOut(new PrintWriter((Writer)new FileWriter(arg), true));
                }
                catch (IOException e) {
                    helper.error("err.error.writing.file", arg, e);
                    return true;
                }
                return super.process(options, option, arg);
            }
        }, new JavacOption.XOption(OptionName.XPRINT, "opt.print"), new JavacOption.XOption(OptionName.XPRINTROUNDS, "opt.printRounds"), new JavacOption.XOption(OptionName.XPRINTPROCESSORINFO, "opt.printProcessorInfo"), new JavacOption.XOption(OptionName.XPREFER, "opt.prefer"){

            public boolean matches(String s) {
                return s.equals("-Xprefer:source") || s.equals("-Xprefer:newer");
            }

            public boolean process(Options options, String option, String operand) {
                int sep = option.indexOf(":");
                options.put(option.substring(0, sep), option.substring(sep + 1));
                options.put(option, option);
                return false;
            }
        }, new JavacOption.HiddenOption(OptionName.O), new JavacOption.HiddenOption(OptionName.XJCOV), new JavacOption.HiddenOption(OptionName.XD){
            String s;

            public boolean matches(String s) {
                this.s = s;
                return s.startsWith(this.name.optionName);
            }

            public boolean process(Options options, String option) {
                this.s = this.s.substring(this.name.optionName.length());
                int eq = this.s.indexOf(61);
                String key = eq < 0 ? this.s : this.s.substring(0, eq);
                String value = eq < 0 ? this.s : this.s.substring(eq + 1);
                options.put(key, value);
                return false;
            }
        }, new JavacOption.HiddenOption(OptionName.SOURCEFILE){
            String s;

            public boolean matches(String s) {
                this.s = s;
                return s.endsWith(".java") || SourceVersion.isName(s);
            }

            public boolean process(Options options, String option) {
                if (this.s.endsWith(".java")) {
                    File f = new File(this.s);
                    if (!f.exists()) {
                        helper.error("err.file.not.found", f);
                        return true;
                    }
                    if (!f.isFile()) {
                        helper.error("err.file.not.file", f);
                        return true;
                    }
                    helper.addFile(f);
                } else {
                    helper.addClassName(this.s);
                }
                return false;
            }
        }};
    }

    public static class GrumpyHelper
    implements OptionHelper {
        public void setOut(PrintWriter out) {
            throw new IllegalArgumentException();
        }

        public void error(String key, Object ... args) {
            throw new IllegalArgumentException(Main.getLocalizedString(key, args));
        }

        public void printVersion() {
            throw new IllegalArgumentException();
        }

        public void printFullVersion() {
            throw new IllegalArgumentException();
        }

        public void printHelp() {
            throw new IllegalArgumentException();
        }

        public void printXhelp() {
            throw new IllegalArgumentException();
        }

        public void addFile(File f) {
            throw new IllegalArgumentException(f.getPath());
        }

        public void addClassName(String s) {
            throw new IllegalArgumentException(s);
        }
    }

    public static interface OptionHelper {
        public void setOut(PrintWriter var1);

        public void error(String var1, Object ... var2);

        public void printVersion();

        public void printFullVersion();

        public void printHelp();

        public void printXhelp();

        public void addFile(File var1);

        public void addClassName(String var1);
    }
}

