/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.Options;
import javax.tools.JavaFileObject;

public class DiagnosticFormatter {
    protected String posFormat;
    protected String classFormat = "%f: %t%m";
    protected String noPosFormat;
    protected boolean raw;
    protected static final Context.Key<DiagnosticFormatter> formatterKey = new Context.Key();
    public static final String DEFAULT_POS_FORMAT = "%f:%l: %t%m";
    public static final String DEFAULT_CLASS_FORMAT = "%f: %t%m";
    public static final String DEFAULT_NO_POS_FORMAT = "%p%m";

    public static DiagnosticFormatter instance(Context context) {
        DiagnosticFormatter instance = context.get(formatterKey);
        if (instance == null) {
            instance = new DiagnosticFormatter(context);
        }
        return instance;
    }

    protected DiagnosticFormatter(Context context) {
        Options options = Options.instance(context);
        this.raw = options.get("rawDiagnostics") != null;
        String fmt = options.get("diags");
        if (fmt != null) {
            int sep = fmt.indexOf(124);
            if (sep == -1) {
                this.posFormat = this.noPosFormat = fmt;
            } else {
                this.posFormat = fmt.substring(0, sep);
                this.noPosFormat = fmt.substring(sep + 1);
            }
        } else {
            this.posFormat = DEFAULT_POS_FORMAT;
            this.noPosFormat = DEFAULT_NO_POS_FORMAT;
        }
    }

    public DiagnosticFormatter() {
        this.posFormat = DEFAULT_POS_FORMAT;
        this.noPosFormat = DEFAULT_NO_POS_FORMAT;
        this.raw = false;
    }

    public DiagnosticFormatter(String pos, String noPos) {
        this.posFormat = pos;
        this.noPosFormat = noPos;
        this.raw = false;
    }

    String format(JCDiagnostic d) {
        return this.raw ? this.format_raw(d) : this.format_std(d);
    }

    private String format_raw(JCDiagnostic d) {
        JCDiagnostic.DiagnosticSource source = d.getDiagnosticSource();
        int position = d.getIntPosition();
        StringBuilder sb = new StringBuilder();
        if (position == -1) {
            sb.append("-");
        } else {
            sb.append(source.getName() + ":" + source.getLineNumber(position) + ":" + source.getColumnNumber(position) + ":");
        }
        sb.append(" ");
        sb.append(d.getCode());
        String sep = ": ";
        for (Object arg : d.getArgs()) {
            sb.append(sep);
            if (arg instanceof JCDiagnostic) {
                sb.append('(');
                sb.append(this.format_raw((JCDiagnostic)arg));
                sb.append(')');
            } else if (arg instanceof JavaFileObject) {
                sb.append(JavacFileManager.getJavacBaseFileName((JavaFileObject)arg));
            } else {
                sb.append(arg);
            }
            sep = ", ";
        }
        return sb.toString();
    }

    private String format_std(JCDiagnostic d) {
        JCDiagnostic.DiagnosticSource source = d.getDiagnosticSource();
        JCDiagnostic.DiagnosticType type = d.getType();
        int position = d.getIntPosition();
        String format = this.noPosFormat;
        if (source != null) {
            if (position != -1) {
                format = this.posFormat;
            } else if (source.getFile() != null && source.getFile().getKind() == JavaFileObject.Kind.CLASS) {
                format = this.classFormat;
            }
        }
        StringBuilder sb = new StringBuilder();
        block18: for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '%' && i < format.length() - 1) {
                c = format.charAt(++i);
                switch (c) {
                    case 'b': {
                        sb.append(source == null ? "-" : source.getName());
                        break;
                    }
                    case 'e': {
                        sb.append(position == -1 ? "-" : String.valueOf(d.getEndPosition()));
                        break;
                    }
                    case 'f': {
                        sb.append(source == null ? "-" : d.getSourceName());
                        break;
                    }
                    case 'l': {
                        sb.append(position == -1 ? "-" : String.valueOf(d.getLineNumber()));
                        break;
                    }
                    case 'c': {
                        sb.append(position == -1 ? "-" : String.valueOf(d.getColumnNumber()));
                        break;
                    }
                    case 'o': {
                        sb.append(position == -1 ? "-" : String.valueOf(position));
                        break;
                    }
                    case 'p': {
                        sb.append(d.getPrefix());
                        break;
                    }
                    case 's': {
                        sb.append(position == -1 ? "-" : String.valueOf(d.getStartPosition()));
                        break;
                    }
                    case 't': {
                        boolean usePrefix;
                        switch (type) {
                            case FRAGMENT: {
                                usePrefix = false;
                                break;
                            }
                            case ERROR: {
                                usePrefix = position == -1;
                                break;
                            }
                            default: {
                                usePrefix = true;
                            }
                        }
                        if (!usePrefix) continue block18;
                        sb.append(d.getPrefix());
                        break;
                    }
                    case 'm': {
                        sb.append(d.getMessage(null));
                        break;
                    }
                    case '_': {
                        sb.append(' ');
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

