/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.util.Iterator;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.NodeItem;

public class BalloonTreeLayout
extends TreeLayout {
    private int m_minRadius = 2;
    public static final String PARAMS = "_balloonTreeLayoutParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public BalloonTreeLayout(String group) {
        this(group, 2);
    }

    public BalloonTreeLayout(String group, int minRadius) {
        super(group);
    }

    public int getMinRadius() {
        return this.m_minRadius;
    }

    public void setMinRadius(int minRadius) {
        this.m_minRadius = minRadius;
    }

    public void run(double frac) {
        Graph g = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(g.getNodes());
        Point2D anchor = this.getLayoutAnchor();
        NodeItem n = this.getLayoutRoot();
        this.layout(n, anchor.getX(), anchor.getY());
    }

    private void layout(NodeItem n, double x, double y) {
        this.firstWalk(n);
        this.secondWalk(n, null, x, y, 1.0, 0.0);
    }

    private void firstWalk(NodeItem n) {
        Params np = this.getParams(n);
        np.d = 0;
        double s = 0.0;
        Iterator childIter = n.children();
        while (childIter.hasNext()) {
            NodeItem c = (NodeItem)childIter.next();
            if (!c.isVisible()) continue;
            this.firstWalk(c);
            Params cp = this.getParams(c);
            np.d = Math.max(np.d, cp.r);
            cp.a = Math.atan((double)cp.r / (double)(np.d + cp.r));
            s += cp.a;
        }
        this.adjustChildren(np, s);
        this.setRadius(np);
    }

    private void adjustChildren(Params np, double s) {
        if (s > Math.PI) {
            np.c = Math.PI / s;
            np.f = 0.0;
        } else {
            np.c = 1.0;
            np.f = Math.PI - s;
        }
    }

    private void setRadius(Params np) {
        np.r = Math.max(np.d, this.m_minRadius) + 2 * np.d;
    }

    private void secondWalk(NodeItem n, NodeItem r, double x, double y, double l, double t) {
        this.setX(n, r, x);
        this.setY(n, r, y);
        Params np = this.getParams(n);
        int numChildren = 0;
        Iterator childIter = n.children();
        while (childIter.hasNext()) {
            NodeItem c = (NodeItem)childIter.next();
            if (!c.isVisible()) continue;
            ++numChildren;
        }
        double dd = l * (double)np.d;
        double p = t + Math.PI;
        double fs = numChildren == 0 ? 0.0 : np.f / (double)numChildren;
        double pr = 0.0;
        childIter = n.children();
        while (childIter.hasNext()) {
            NodeItem c = (NodeItem)childIter.next();
            if (!c.isVisible()) continue;
            Params cp = this.getParams(c);
            double aa = np.c * cp.a;
            double rr = (double)np.d * Math.tan(aa) / (1.0 - Math.tan(aa));
            double xx = (l * rr + dd) * Math.cos(p += pr + aa + fs);
            double yy = (l * rr + dd) * Math.sin(p);
            pr = aa;
            this.secondWalk(c, n, x + xx, y + yy, l * np.c, p);
        }
    }

    private void initSchema(TupleSet ts) {
        try {
            ts.addColumns(PARAMS_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Params getParams(NodeItem n) {
        Params np = (Params)n.get(PARAMS);
        if (np == null) {
            np = new Params();
            n.set(PARAMS, np);
        }
        return np;
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params {
        public int d;
        public int r;
        public double rx;
        public double ry;
        public double a;
        public double c;
        public double f;
    }
}

