/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataprovider;

import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.BasicTableDataFilter;
import com.sun.data.provider.impl.CompareFilterCriteria;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.data.provider.impl.RegexFilterCriteria;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.visualweb.dataprovider.TestBean;

public class BasicTableDataFilterTest
extends NbTestCase {
    private ObjectListDataProvider tdp = null;
    private BasicTableDataFilter tdf = null;

    public BasicTableDataFilterTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tdp = new ObjectListDataProvider();
        this.tdf = new BasicTableDataFilter();
        for (int x = 0; x < 10; ++x) {
            for (int i = 0; i < 20; ++i) {
                TestBean tb = new TestBean("TestBean" + i);
                tb.setStringProperty("TestBean:" + i + tb.hashCode());
                tb.setLongProperty(System.currentTimeMillis());
                tb.setDoubleProperty(Math.random());
                tb.setIntProperty((int)Math.round(tb.getDoubleProperty() * 1000.0));
                this.tdp.addObject((Object)tb);
            }
        }
    }

    protected void tearDown() throws Exception {
        this.tdf = null;
        this.tdp = null;
        super.tearDown();
    }

    public void testFilter() {
        CompareFilterCriteria cfc1 = new CompareFilterCriteria(this.tdp.getFieldKey("intProperty"), (Object)new Integer(100));
        cfc1.setMatchLessThan(false);
        cfc1.setMatchEqualTo(true);
        cfc1.setMatchGreaterThan(true);
        cfc1.setInclude(true);
        CompareFilterCriteria cfc2 = new CompareFilterCriteria(this.tdp.getFieldKey("intProperty"), (Object)new Integer(200));
        cfc2.setMatchLessThan(true);
        cfc2.setMatchEqualTo(true);
        cfc2.setMatchGreaterThan(false);
        cfc2.setInclude(true);
        CompareFilterCriteria cfc3 = new CompareFilterCriteria(this.tdp.getFieldKey("intProperty"), (Object)new Integer(150));
        cfc3.setMatchLessThan(false);
        cfc3.setMatchEqualTo(true);
        cfc3.setMatchGreaterThan(false);
        cfc3.setInclude(false);
        RegexFilterCriteria rfc1 = new RegexFilterCriteria(this.tdp.getFieldKey("id"), ".9");
        rfc1.setInclude(false);
        this.tdf.setFilterCriteria(new FilterCriteria[]{cfc1, cfc2, cfc3});
        this.tdf.setMatchAllCriteria(true);
        FilterCriteria[] ca = this.tdf.getFilterCriteria();
        RowKey[] rks = this.tdp.getRowKeys(this.tdp.getRowCount(), null);
        RowKey[] fks = this.tdf.filter((TableDataProvider)this.tdp, rks);
    }
}

