/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataprovider;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.impl.CachedRowSetDataProvider;
import com.sun.sql.rowset.CachedRowSetXImpl;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.CachedRowSet;
import junit.framework.TestCase;

public class CachedRowSetDataProviderTest
extends TestCase {
    private static final Logger LOGGER = Logger.getLogger(CachedRowSetDataProviderTest.class.getName());
    private static final String DBURL = "jdbc:derby:mydb;create=true";
    private static final String TABLENAME = "mytable";
    private static final String IDNAME = "id";
    private static final String COL1NAME = "col1";
    private static final String COL2NAME = "col2";
    private static final int NUMROWS = 10;

    public CachedRowSetDataProviderTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        try {
            super.setUp();
            LOGGER.setLevel(Level.FINE);
            this.initDatabase();
        }
        catch (SQLException sqle) {
            this.reportSQLException(sqle);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Failed to set up test", t);
            throw new Exception(t);
        }
    }

    private void reportSQLException(SQLException sqle) {
        LOGGER.log(Level.SEVERE, null, sqle);
        if (sqle.getNextException() != null) {
            this.reportSQLException(sqle.getNextException());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        String userdir = System.getProperty("user.dir");
        File dbdir = new File(userdir + "/" + "mydb");
        LOGGER.log(Level.INFO, "userdir is " + userdir);
        this.deleteRecursively(dbdir);
        File logfile = new File(userdir + "/derby.log");
        if (logfile.exists()) {
            logfile.delete();
        }
    }

    private void deleteRecursively(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        File[] children = file.listFiles();
        for (int i = 0; i < children.length; ++i) {
            this.deleteRecursively(children[i]);
        }
        file.delete();
    }

    private void initDatabase() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        Connection conn = DriverManager.getConnection(DBURL);
        try {
            conn.prepareStatement("DROP TABLE mytable").execute();
        }
        catch (SQLException sqle) {
            LOGGER.log(Level.FINE, null, sqle);
        }
        String create = "CREATE TABLE mytable(id int primary key, col1 varchar(255),  col2 varchar(255))";
        conn.prepareStatement(create).execute();
        PreparedStatement insert = conn.prepareStatement("INSERT INTO mytable VALUES(?, ?, ?)");
        for (int i = 1; i <= 10; ++i) {
            insert.setInt(1, i);
            insert.setString(2, "col1_" + i);
            insert.setString(3, "col2_" + i);
            insert.execute();
        }
    }

    public void testCommandChange() throws Exception {
        CachedRowSetXImpl rowset = new CachedRowSetXImpl();
        CachedRowSetDataProvider provider = new CachedRowSetDataProvider();
        provider.setCachedRowSet((CachedRowSet)rowset);
        rowset.setUrl(DBURL);
        rowset.setCommand("SELECT id, col1 FROM mytable WHERE id = 2");
        rowset.setTableName(TABLENAME);
        this.checkRows(provider, 1, 2);
        rowset.setCommand("SELECT id FROM mytable");
        this.checkRows(provider, 10, 1);
        provider.close();
    }

    private void checkRows(CachedRowSetDataProvider provider, int expectedRows, int expectedFields) {
        int numrows = provider.getRowCount();
        assert (numrows == expectedRows);
        FieldKey[] keys = provider.getFieldKeys();
        int numkeys = keys.length;
        assert (numkeys == expectedFields);
        provider.cursorFirst();
        for (int i = 0; i < numrows; ++i) {
            for (int j = 0; j < numkeys; ++j) {
                Object value = provider.getValue(keys[j]);
                assert (value != null);
            }
        }
    }
}

