/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataprovider;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProvider;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.impl.ObjectDataProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.visualweb.dataprovider.TestBean;

public class ObjectDataProviderTest
extends NbTestCase {
    private TestBean bean = null;
    private ObjectDataProvider dp = null;
    private Listener listener = null;
    private static int[] intArray = new int[0];
    private static TestBean[] nestedArray = new TestBean[0];
    private static Descriptor[] fieldKeys = new Descriptor[]{new Descriptor("public1", String.class, false, "This is public1"), new Descriptor("public2", Integer.class, false, new Integer(8888))};
    private static Descriptor[] properties = new Descriptor[]{new Descriptor("booleanProperty", Boolean.class, false, Boolean.TRUE), new Descriptor("byteProperty", Byte.class, false, new Byte(123)), new Descriptor("doubleProperty", Double.class, false, new Double(654.321)), new Descriptor("floatProperty", Float.class, false, new Float(123.45f)), new Descriptor("id", String.class, false, null), new Descriptor("intArray", intArray.getClass(), false, null), new Descriptor("intList", List.class, false, null), new Descriptor("intProperty", Integer.class, false, new Integer(1234)), new Descriptor("longProperty", Long.class, false, new Long(54321L)), new Descriptor("nestedArray", nestedArray.getClass(), false, null), new Descriptor("nestedList", List.class, false, null), new Descriptor("nestedMap", Map.class, false, null), new Descriptor("nestedProperty", TestBean.class, false, null), new Descriptor("readOnly", String.class, true, null), new Descriptor("shortProperty", Short.class, false, new Short(321)), new Descriptor("stringProperty", String.class, false, "This is a String"), new Descriptor("nullString", String.class, true, null), new Descriptor("class", Class.class, true, null)};
    private static Update[] updates = new Update[]{new Update("booleanProperty", Boolean.FALSE), new Update("byteProperty", new Byte(-43)), new Update("doubleProperty", new Double(123.456)), new Update("floatProperty", new Float(111.22f)), new Update("intProperty", new Integer(23432)), new Update("longProperty", new Long(55555L)), new Update("shortProperty", new Short(123)), new Update("stringProperty", "Updated string value"), new Update("public1", "revised String1 value"), new Update("public2", new Integer(55555))};

    public ObjectDataProviderTest(String name) {
        super(name);
    }

    public void setUp() {
        this.bean = new TestBean("test");
        this.dp = new ObjectDataProvider((Object)this.bean, true);
    }

    public void tearDown() {
        this.dp = null;
        this.bean = null;
    }

    public void testBaseClassMethods() {
        for (int i = 0; i < properties.length; ++i) {
            String fieldId = ObjectDataProviderTest.properties[i].name;
            FieldKey fieldKey = this.dp.getFieldKey(fieldId);
            ObjectDataProviderTest.assertEquals((String)("type(" + fieldId + ")"), (Object)this.dp.getType(fieldKey), (Object)this.dp.getType(fieldId));
            ObjectDataProviderTest.assertEquals((String)("value(" + fieldId + ")"), (Object)this.dp.getValue(fieldKey), (Object)this.dp.getValue(fieldId));
            ObjectDataProviderTest.assertEquals((String)("readOnly(" + fieldId + ")"), (boolean)this.dp.isReadOnly(fieldKey), (boolean)this.dp.isReadOnly(fieldId));
        }
    }

    public void testEvents() {
        ObjectDataProviderTest.assertNotNull((Object)this.dp.getFieldKey("intProperty"));
        ObjectDataProviderTest.assertNotNull((Object)this.dp.getFieldKey("public1"));
        this.listener = new Listener();
        this.dp.addDataListener((DataListener)this.listener);
        DataListener[] listeners = this.dp.getDataListeners();
        ObjectDataProviderTest.assertEquals((int)1, (int)listeners.length);
        ObjectDataProviderTest.assertTrue((this.listener == listeners[0] ? 1 : 0) != 0);
        this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)new Integer(23432));
        this.dp.setValue(this.dp.getFieldKey("public1"), (Object)"new public1");
        ObjectDataProviderTest.assertEquals((String)"intProperty/1234/23432//public1/This is public1/new public1//", (String)this.listener.getLog());
        this.dp.removeDataListener((DataListener)this.listener);
        listeners = this.dp.getDataListeners();
        ObjectDataProviderTest.assertEquals((int)0, (int)listeners.length);
    }

    public void testNegative() {
        try {
            this.dp.getFieldKey("unknown id value");
            ObjectDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.dp.setValue(this.dp.getFieldKey("readOnly"), (Object)"xyz");
            ObjectDataProviderTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)"string value");
            ObjectDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoFields() {
        this.dp = new ObjectDataProvider((Object)this.bean, false);
        try {
            this.dp.getFieldKey("public1");
            ObjectDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.dp.getFieldKey("public2");
            ObjectDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.checkProperties();
        this.checkExtras();
    }

    public void testPristine() {
        ObjectDataProviderTest.assertEquals((String)"test", (String)((TestBean)this.dp.getObject()).getId());
        this.checkFields();
        this.checkProperties();
        this.checkExtras();
    }

    public void testUpdates() {
        this.checkUpdates();
    }

    public void testSerializable() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.dp);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.dp = (ObjectDataProvider)ois.readObject();
        ois.close();
        this.testPristine();
    }

    private void checkExtras() {
        FieldKey[] keys = this.dp.getFieldKeys();
        ObjectDataProviderTest.assertNotNull((Object)keys);
        for (int i = 0; i < keys.length; ++i) {
            int j;
            String name = keys[i].getFieldId();
            boolean found = false;
            for (j = 0; j < properties.length; ++j) {
                if (!name.equals(ObjectDataProviderTest.properties[j].name)) continue;
                found = true;
                break;
            }
            if (!found && this.dp.isIncludeFields()) {
                for (j = 0; j < fieldKeys.length; ++j) {
                    if (!name.equals(ObjectDataProviderTest.fieldKeys[j].name)) continue;
                    found = true;
                    break;
                }
            }
            ObjectDataProviderTest.assertTrue((String)("Id '" + name + "' is valid"), (boolean)found);
        }
    }

    private void checkFields() {
        FieldKey dk = null;
        String name = null;
        for (int i = 0; i < fieldKeys.length; ++i) {
            name = ObjectDataProviderTest.fieldKeys[i].name;
            dk = this.dp.getFieldKey(name);
            ObjectDataProviderTest.assertNotNull((String)("FieldKey for '" + name + "'"), (Object)dk);
            ObjectDataProviderTest.assertTrue((String)("Type for '" + name + "'"), (boolean)this.isAssignableFrom(this.dp.getType(dk), ObjectDataProviderTest.fieldKeys[i].type));
            ObjectDataProviderTest.assertEquals((String)("ReadOnly for '" + name + "'"), (boolean)ObjectDataProviderTest.fieldKeys[i].canSetValue, (boolean)this.dp.isReadOnly(dk));
            if (ObjectDataProviderTest.fieldKeys[i].defaultValue == null) continue;
            ObjectDataProviderTest.assertEquals((String)("Value for '" + name + "'"), (Object)ObjectDataProviderTest.fieldKeys[i].defaultValue, (Object)this.dp.getValue(dk));
        }
    }

    private void checkProperties() {
        FieldKey dk = null;
        String name = null;
        for (int i = 0; i < properties.length; ++i) {
            name = ObjectDataProviderTest.properties[i].name;
            dk = this.dp.getFieldKey(name);
            ObjectDataProviderTest.assertNotNull((String)("FieldKey for '" + name + "'"), (Object)dk);
            ObjectDataProviderTest.assertTrue((String)("Type for '" + name + "'"), (boolean)this.isAssignableFrom(this.dp.getType(dk), ObjectDataProviderTest.properties[i].type));
            ObjectDataProviderTest.assertEquals((String)("ReadOnly for '" + name + "'"), (boolean)ObjectDataProviderTest.properties[i].canSetValue, (boolean)this.dp.isReadOnly(dk));
            if (ObjectDataProviderTest.properties[i].defaultValue == null) continue;
            ObjectDataProviderTest.assertEquals((String)("Value for '" + name + "'"), (Object)ObjectDataProviderTest.properties[i].defaultValue, (Object)this.dp.getValue(dk));
        }
    }

    private boolean isAssignableFrom(Class to, Class from) {
        if (to.isPrimitive()) {
            if (to == Boolean.TYPE) {
                to = Boolean.class;
            } else if (to == Character.TYPE) {
                to = Character.class;
            } else if (to == Byte.TYPE) {
                to = Byte.class;
            } else if (to == Short.TYPE) {
                to = Short.class;
            } else if (to == Integer.TYPE) {
                to = Integer.class;
            } else if (to == Long.TYPE) {
                to = Long.class;
            } else if (to == Float.TYPE) {
                to = Float.class;
            } else if (to == Double.TYPE) {
                to = Double.class;
            }
        }
        return to.isAssignableFrom(from);
    }

    private void checkUpdates() {
        Object dk = null;
        String name = null;
        for (int i = 0; i < updates.length; ++i) {
            name = ObjectDataProviderTest.updates[i].name;
            try {
                this.dp.setValue(this.dp.getFieldKey(name), ObjectDataProviderTest.updates[i].value);
            }
            catch (Exception e) {
                ObjectDataProviderTest.fail((String)("Cannot set value for '" + name + "':" + e));
            }
            ObjectDataProviderTest.assertEquals((String)("Updated value for '" + name + "'"), (Object)ObjectDataProviderTest.updates[i].value, (Object)this.dp.getValue(this.dp.getFieldKey(name)));
        }
    }

    static class Update {
        public String name;
        public Object value;

        public Update(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    static class Listener
    implements DataListener {
        String log = "";

        Listener() {
        }

        public String getLog() {
            return this.log;
        }

        public void clear() {
            this.log = "";
        }

        public void valueChanged(DataProvider dp, FieldKey dk, Object oldValue, Object newValue) {
            this.log = this.log + dk.getFieldId() + "/" + oldValue + "/" + newValue + "//";
        }

        public void providerChanged(DataProvider dp) {
            this.log = this.log + "providerChanged//";
        }
    }

    static class Descriptor {
        public String name;
        public Class type;
        public boolean canSetValue;
        public Object defaultValue;

        public Descriptor(String name, Class type, boolean canSetValue, Object defaultValue) {
            this.name = name;
            this.type = type;
            this.canSetValue = canSetValue;
            this.defaultValue = defaultValue;
        }
    }
}

