/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataprovider;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProvider;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorListener;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataListener;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TransactionalDataListener;
import com.sun.data.provider.TransactionalDataProvider;
import com.sun.data.provider.impl.IndexRowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.visualweb.dataprovider.TestBean;

public class ObjectListDataProviderTest
extends NbTestCase {
    private TestBean[] beans = null;
    private ObjectListDataProvider dp = null;
    private List list = null;
    private Listener listener = null;
    private MyCursorListener tdcListener = null;
    private MyDataListener tdpListener = null;
    private static int[] intArray = new int[0];
    private static TestBean[] nestedArray = new TestBean[0];
    private static Descriptor[] fieldKeys = new Descriptor[]{new Descriptor("public1", String.class, false, "This is public1"), new Descriptor("public2", Integer.class, false, new Integer(8888))};
    private static Descriptor[] properties = new Descriptor[]{new Descriptor("booleanProperty", Boolean.class, false, Boolean.TRUE), new Descriptor("byteProperty", Byte.class, false, new Byte(123)), new Descriptor("doubleProperty", Double.class, false, new Double(654.321)), new Descriptor("floatProperty", Float.class, false, new Float(123.45f)), new Descriptor("id", String.class, false, null), new Descriptor("intArray", intArray.getClass(), false, null), new Descriptor("intList", List.class, false, null), new Descriptor("intProperty", Integer.class, false, new Integer(1234)), new Descriptor("longProperty", Long.class, false, new Long(54321L)), new Descriptor("nestedArray", nestedArray.getClass(), false, null), new Descriptor("nestedList", List.class, false, null), new Descriptor("nestedMap", Map.class, false, null), new Descriptor("nestedProperty", TestBean.class, false, null), new Descriptor("readOnly", String.class, true, null), new Descriptor("shortProperty", Short.class, false, new Short(321)), new Descriptor("stringProperty", String.class, false, "This is a String"), new Descriptor("nullString", String.class, true, null), new Descriptor("class", Class.class, true, null)};
    private static Update[] updates = new Update[]{new Update("booleanProperty", Boolean.FALSE), new Update("byteProperty", new Byte(-43)), new Update("doubleProperty", new Double(123.456)), new Update("floatProperty", new Float(111.22f)), new Update("intProperty", new Integer(23432)), new Update("longProperty", new Long(55555L)), new Update("shortProperty", new Short(123)), new Update("stringProperty", "Updated string value"), new Update("public1", "revised String1 value"), new Update("public2", new Integer(55555))};

    public ObjectListDataProviderTest(String testName) {
        super(testName);
        new ObjectListDataProvider();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.beans = new TestBean[5];
        this.list = new ArrayList();
        for (int i = 0; i < this.beans.length; ++i) {
            this.beans[i] = new TestBean("test" + i);
            this.list.add(this.beans[i]);
        }
        this.dp = new ObjectListDataProvider(this.list, true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.dp = null;
        this.beans = null;
        this.list = null;
        this.listener = null;
        this.tdcListener = null;
        this.tdpListener = null;
    }

    public void testBaseClassMethods() {
        for (int i = 0; i < properties.length; ++i) {
            String fieldId = ObjectListDataProviderTest.properties[i].name;
            FieldKey fieldKey = this.dp.getFieldKey(fieldId);
            ObjectListDataProviderTest.assertEquals((String)("type(" + fieldId + ")"), (Object)this.dp.getType(fieldKey), (Object)this.dp.getType(fieldId));
            ObjectListDataProviderTest.assertEquals((String)("value(" + fieldId + ")"), (Object)this.dp.getValue(fieldKey), (Object)this.dp.getValue(fieldId));
            ObjectListDataProviderTest.assertEquals((String)("readOnly(" + fieldId + ")"), (boolean)this.dp.isReadOnly(fieldKey), (boolean)this.dp.isReadOnly(fieldId));
        }
    }

    public void testEventsAppend() {
        MyTransactionalListener tListener = new MyTransactionalListener();
        this.dp.addTransactionalDataListener((TransactionalDataListener)tListener);
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.canAppendRow());
        RowKey rk1 = this.dp.appendRow();
        ObjectListDataProviderTest.assertNull((Object)this.dp.getValue("id", rk1));
        this.dp.setValue("id", rk1, (Object)"testA");
        ObjectListDataProviderTest.assertEquals((Object)"testA", (Object)this.dp.getValue("id", rk1));
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.canAppendRow());
        TestBean beanB = new TestBean("testB");
        RowKey rk2 = this.dp.appendRow((Object)beanB);
        this.dp.commitChanges();
        ObjectListDataProviderTest.assertEquals((String)"rowAdded/RowKey[5]//FieldKey[id]/RowKey[5]/null/testA//FieldKey[id]/null/testA//rowAdded/RowKey[6]//changesCommitted//", (String)tListener.getLog());
    }

    public void testEventsBasic() {
        ObjectListDataProviderTest.assertNotNull((Object)this.dp.getFieldKey("intProperty"));
        ObjectListDataProviderTest.assertNotNull((Object)this.dp.getFieldKey("public1"));
        this.listener = new Listener();
        this.dp.addDataListener((DataListener)this.listener);
        DataListener[] listeners = this.dp.getDataListeners();
        ObjectListDataProviderTest.assertEquals((int)1, (int)listeners.length);
        ObjectListDataProviderTest.assertTrue((this.listener == listeners[0] ? 1 : 0) != 0);
        this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)new Integer(23432));
        this.dp.setValue(this.dp.getFieldKey("public1"), (Object)"new public1");
        ObjectListDataProviderTest.assertEquals((String)"intProperty/1234/23432//public1/This is public1/new public1//", (String)this.listener.getLog());
        this.dp.removeDataListener((DataListener)this.listener);
        listeners = this.dp.getDataListeners();
        ObjectListDataProviderTest.assertEquals((int)0, (int)listeners.length);
    }

    public void testEventsCursor() throws Exception {
        this.tdcListener = new MyCursorListener();
        this.dp.addTableCursorListener((TableCursorListener)this.tdcListener);
        TableCursorListener[] listeners = this.dp.getTableCursorListeners();
        ObjectListDataProviderTest.assertEquals((int)1, (int)listeners.length);
        ObjectListDataProviderTest.assertTrue((this.tdcListener == listeners[0] ? 1 : 0) != 0);
        ObjectListDataProviderTest.assertEquals((Object)new IndexRowKey(0), (Object)this.dp.getCursorRow());
        this.dp.setCursorRow((RowKey)new IndexRowKey(2));
        ObjectListDataProviderTest.assertEquals((Object)new IndexRowKey(2), (Object)this.dp.getCursorRow());
        this.dp.setCursorRow((RowKey)new IndexRowKey(1));
        ObjectListDataProviderTest.assertEquals((Object)new IndexRowKey(1), (Object)this.dp.getCursorRow());
        ObjectListDataProviderTest.assertEquals((String)"cursorChanging/RowKey[0]/RowKey[2]//cursorChanged/RowKey[0]/RowKey[2]//cursorChanging/RowKey[2]/RowKey[1]//cursorChanged/RowKey[2]/RowKey[1]//", (String)this.tdcListener.getLog());
        this.tdcListener.clear();
        this.tdcListener.setVeto(true);
        try {
            this.dp.setCursorRow((RowKey)new IndexRowKey(3));
            ObjectListDataProviderTest.fail((String)"Should have thrown TableCursorVetoException");
        }
        catch (TableCursorVetoException tableCursorVetoException) {
            // empty catch block
        }
        ObjectListDataProviderTest.assertEquals((Object)new IndexRowKey(1), (Object)this.dp.getCursorRow());
        ObjectListDataProviderTest.assertEquals((String)"cursorChanging/RowKey[1]/RowKey[3]//cursorVetoed/RowKey[1]/RowKey[3]//", (String)this.tdcListener.getLog());
        this.dp.removeTableCursorListener((TableCursorListener)this.tdcListener);
        listeners = this.dp.getTableCursorListeners();
        ObjectListDataProviderTest.assertEquals((int)0, (int)listeners.length);
    }

    public void testEventsData() {
        this.tdpListener = new MyDataListener();
        this.dp.addTableDataListener((TableDataListener)this.tdpListener);
        TableDataListener[] listeners = this.dp.getTableDataListeners();
        ObjectListDataProviderTest.assertEquals((int)1, (int)listeners.length);
        ObjectListDataProviderTest.assertTrue((this.tdpListener == listeners[0] ? 1 : 0) != 0);
        this.dp.cursorFirst();
        this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)new Integer(23432));
        Object value = this.dp.getValue(this.dp.getFieldKey("stringProperty"));
        this.dp.setValue(this.dp.getFieldKey("stringProperty"), value);
        ObjectListDataProviderTest.assertEquals((String)"FieldKey[intProperty]/RowKey[0]/1234/23432//FieldKey[intProperty]/1234/23432//", (String)this.tdpListener.getLog());
        this.tdpListener.clear();
        this.dp.setList(this.dp.getList());
        ObjectListDataProviderTest.assertEquals((String)"providerChanged//", (String)this.tdpListener.getLog());
        this.dp.removeTableDataListener((TableDataListener)this.tdpListener);
        listeners = this.dp.getTableDataListeners();
        ObjectListDataProviderTest.assertEquals((int)0, (int)listeners.length);
    }

    public void testEventsInsert() {
        ObjectListDataProviderTest.assertTrue((!this.dp.canInsertRow(this.dp.getCursorRow()) ? 1 : 0) != 0);
    }

    public void testEventsRemovesAscending() {
        MyTransactionalListener tListener = new MyTransactionalListener();
        this.dp.addTransactionalDataListener((TransactionalDataListener)tListener);
        RowKey rk = null;
        rk = this.dp.findFirst("id", (Object)"test1");
        ObjectListDataProviderTest.assertNotNull((Object)rk);
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.canRemoveRow(rk));
        this.dp.removeRow(rk);
        rk = this.dp.findFirst("id", (Object)"test3");
        ObjectListDataProviderTest.assertNotNull((Object)rk);
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.canRemoveRow(rk));
        this.dp.removeRow(rk);
        this.dp.commitChanges();
        ObjectListDataProviderTest.assertEquals((String)"rowRemoved/RowKey[1]//rowRemoved/RowKey[3]//changesCommitted//", (String)tListener.getLog());
        ObjectListDataProviderTest.assertEquals((int)(this.beans.length - 2), (int)this.list.size());
        ObjectListDataProviderTest.assertEquals((String)"test0", (String)((TestBean)this.list.get(0)).getId());
        ObjectListDataProviderTest.assertEquals((String)"test2", (String)((TestBean)this.list.get(1)).getId());
        ObjectListDataProviderTest.assertEquals((String)"test4", (String)((TestBean)this.list.get(2)).getId());
    }

    public void testEventsRemovesDescending() {
        MyTransactionalListener tListener = new MyTransactionalListener();
        this.dp.addTransactionalDataListener((TransactionalDataListener)tListener);
        RowKey rk = null;
        rk = this.dp.findFirst("id", (Object)"test3");
        ObjectListDataProviderTest.assertNotNull((Object)rk);
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.canRemoveRow(rk));
        this.dp.removeRow(rk);
        rk = this.dp.findFirst("id", (Object)"test1");
        ObjectListDataProviderTest.assertNotNull((Object)rk);
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.canRemoveRow(rk));
        this.dp.removeRow(rk);
        this.dp.commitChanges();
        ObjectListDataProviderTest.assertEquals((String)"rowRemoved/RowKey[3]//rowRemoved/RowKey[1]//changesCommitted//", (String)tListener.getLog());
        ObjectListDataProviderTest.assertEquals((int)(this.beans.length - 2), (int)this.list.size());
        ObjectListDataProviderTest.assertEquals((String)"test0", (String)((TestBean)this.list.get(0)).getId());
        ObjectListDataProviderTest.assertEquals((String)"test2", (String)((TestBean)this.list.get(1)).getId());
        ObjectListDataProviderTest.assertEquals((String)"test4", (String)((TestBean)this.list.get(2)).getId());
    }

    public void testEventsUpdates() {
        MyDataListener aListener = new MyDataListener();
        MyTransactionalListener tListener = new MyTransactionalListener();
        this.dp.addTableDataListener((TableDataListener)aListener);
        TableDataListener[] aListeners = this.dp.getTableDataListeners();
        ObjectListDataProviderTest.assertEquals((int)1, (int)aListeners.length);
        ObjectListDataProviderTest.assertTrue((aListener == aListeners[0] ? 1 : 0) != 0);
        this.dp.addTransactionalDataListener((TransactionalDataListener)tListener);
        aListeners = this.dp.getTableDataListeners();
        ObjectListDataProviderTest.assertEquals((int)2, (int)aListeners.length);
        ObjectListDataProviderTest.assertTrue((aListener == aListeners[0] ? 1 : 0) != 0);
        ObjectListDataProviderTest.assertTrue((tListener == aListeners[1] ? 1 : 0) != 0);
        TransactionalDataListener[] tListeners = this.dp.getTransactionalDataListeners();
        ObjectListDataProviderTest.assertEquals((int)1, (int)tListeners.length);
        ObjectListDataProviderTest.assertTrue((tListener == tListeners[0] ? 1 : 0) != 0);
        this.dp.cursorFirst();
        this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)new Integer(23432));
        ObjectListDataProviderTest.assertEquals((String)"FieldKey[intProperty]/RowKey[0]/1234/23432//FieldKey[intProperty]/1234/23432//", (String)tListener.getLog());
        ObjectListDataProviderTest.assertEquals((Object)new Integer(23432), (Object)((Integer)this.dp.getValue(this.dp.getFieldKey("intProperty"))));
        tListener.clear();
        this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)new Integer(23432));
        ObjectListDataProviderTest.assertEquals((String)"", (String)tListener.getLog());
        ObjectListDataProviderTest.assertEquals((Object)new Integer(23432), (Object)((Integer)this.dp.getValue(this.dp.getFieldKey("intProperty"))));
        tListener.clear();
        this.dp.revertChanges();
        ObjectListDataProviderTest.assertEquals((String)"changesReverted//", (String)tListener.getLog());
        ObjectListDataProviderTest.assertEquals((Object)new Integer(1234), (Object)((Integer)this.dp.getValue(this.dp.getFieldKey("intProperty"))));
        tListener.clear();
        this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)new Integer(43234));
        ObjectListDataProviderTest.assertEquals((String)"FieldKey[intProperty]/RowKey[0]/1234/43234//FieldKey[intProperty]/1234/43234//", (String)tListener.getLog());
        ObjectListDataProviderTest.assertEquals((Object)new Integer(43234), (Object)((Integer)this.dp.getValue(this.dp.getFieldKey("intProperty"))));
        tListener.clear();
        this.dp.commitChanges();
        ObjectListDataProviderTest.assertEquals((Object)new Integer(43234), (Object)((Integer)this.dp.getValue(this.dp.getFieldKey("intProperty"))));
        this.dp.revertChanges();
        ObjectListDataProviderTest.assertEquals((Object)new Integer(43234), (Object)((Integer)this.dp.getValue(this.dp.getFieldKey("intProperty"))));
        ObjectListDataProviderTest.assertEquals((String)"changesCommitted//changesReverted//", (String)tListener.getLog());
    }

    public void testNegative() {
        try {
            this.dp.getFieldKey("unknown id value");
            ObjectListDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.dp.setValue(this.dp.getFieldKey("readOnly"), (Object)"xyz");
            ObjectListDataProviderTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.dp.setValue(this.dp.getFieldKey("intProperty"), (Object)"string value");
            ObjectListDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoFields() {
        this.dp = new ObjectListDataProvider(this.list, false);
        try {
            this.dp.getFieldKey("public1");
            ObjectListDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.dp.getFieldKey("public2");
            ObjectListDataProviderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.checkProperties();
        this.checkExtras();
    }

    public void testPristine() throws Exception {
        int i;
        ObjectListDataProviderTest.assertTrue((boolean)this.dp.isIncludeFields());
        ObjectListDataProviderTest.assertEquals((int)this.beans.length, (int)this.dp.getRowCount());
        for (i = 0; i < this.beans.length; ++i) {
            this.dp.setCursorRow(this.dp.getRowKey("" + i));
            ObjectListDataProviderTest.assertEquals((Object)("test" + i), (Object)this.dp.getValue(this.dp.getFieldKey("id")));
            this.checkFields();
            this.checkProperties();
            this.checkExtras();
        }
        for (i = 0; i < this.beans.length; ++i) {
            ObjectListDataProviderTest.assertEquals((Object)("test" + i), (Object)this.dp.getValue(this.dp.getFieldKey("id"), this.dp.getRowKey("" + i)));
        }
    }

    public void testSerializable() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.dp);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.dp = (ObjectListDataProvider)ois.readObject();
        ois.close();
        this.testPristine();
    }

    public void testUpdates() {
        this.checkUpdates();
    }

    private void checkExtras() {
        FieldKey[] keys = this.dp.getFieldKeys();
        ObjectListDataProviderTest.assertNotNull((Object)keys);
        for (int i = 0; i < keys.length; ++i) {
            int j;
            String name = keys[i].getFieldId();
            boolean found = false;
            for (j = 0; j < properties.length; ++j) {
                if (!name.equals(ObjectListDataProviderTest.properties[j].name)) continue;
                found = true;
                break;
            }
            if (!found && this.dp.isIncludeFields()) {
                for (j = 0; j < fieldKeys.length; ++j) {
                    if (!name.equals(ObjectListDataProviderTest.fieldKeys[j].name)) continue;
                    found = true;
                    break;
                }
            }
            ObjectListDataProviderTest.assertTrue((String)("Id '" + name + "' is valid"), (boolean)found);
        }
    }

    private void checkFields() {
        FieldKey dk = null;
        String name = null;
        for (int i = 0; i < fieldKeys.length; ++i) {
            name = ObjectListDataProviderTest.fieldKeys[i].name;
            dk = this.dp.getFieldKey(name);
            ObjectListDataProviderTest.assertNotNull((String)("FieldKey for '" + name + "'"), (Object)dk);
            ObjectListDataProviderTest.assertTrue((String)("Type for '" + name + "'"), (boolean)this.isAssignableFrom(this.dp.getType(dk), ObjectListDataProviderTest.fieldKeys[i].type));
            ObjectListDataProviderTest.assertEquals((String)("ReadOnly for '" + name + "'"), (boolean)ObjectListDataProviderTest.fieldKeys[i].canSetValue, (boolean)this.dp.isReadOnly(dk));
            if (ObjectListDataProviderTest.fieldKeys[i].defaultValue == null) continue;
            ObjectListDataProviderTest.assertEquals((String)("Value for '" + name + "'"), (Object)ObjectListDataProviderTest.fieldKeys[i].defaultValue, (Object)this.dp.getValue(dk));
        }
    }

    private void checkProperties() {
        FieldKey dk = null;
        String name = null;
        for (int i = 0; i < properties.length; ++i) {
            name = ObjectListDataProviderTest.properties[i].name;
            dk = this.dp.getFieldKey(name);
            ObjectListDataProviderTest.assertNotNull((String)("FieldKey for '" + name + "'"), (Object)dk);
            ObjectListDataProviderTest.assertTrue((String)("Type for '" + name + "'"), (boolean)this.isAssignableFrom(this.dp.getType(dk), ObjectListDataProviderTest.properties[i].type));
            ObjectListDataProviderTest.assertEquals((String)("ReadOnly for '" + name + "'"), (boolean)ObjectListDataProviderTest.properties[i].canSetValue, (boolean)this.dp.isReadOnly(dk));
            if (ObjectListDataProviderTest.properties[i].defaultValue == null) continue;
            ObjectListDataProviderTest.assertEquals((String)("Value for '" + name + "'"), (Object)ObjectListDataProviderTest.properties[i].defaultValue, (Object)this.dp.getValue(dk));
        }
    }

    private boolean isAssignableFrom(Class to, Class from) {
        if (to.isPrimitive()) {
            if (to == Boolean.TYPE) {
                to = Boolean.class;
            } else if (to == Character.TYPE) {
                to = Character.class;
            } else if (to == Byte.TYPE) {
                to = Byte.class;
            } else if (to == Short.TYPE) {
                to = Short.class;
            } else if (to == Integer.TYPE) {
                to = Integer.class;
            } else if (to == Long.TYPE) {
                to = Long.class;
            } else if (to == Float.TYPE) {
                to = Float.class;
            } else if (to == Double.TYPE) {
                to = Double.class;
            }
        }
        return to.isAssignableFrom(from);
    }

    private void checkUpdates() {
        Object dk = null;
        String name = null;
        for (int i = 0; i < updates.length; ++i) {
            name = ObjectListDataProviderTest.updates[i].name;
            try {
                this.dp.setValue(this.dp.getFieldKey(name), ObjectListDataProviderTest.updates[i].value);
            }
            catch (Exception e) {
                ObjectListDataProviderTest.fail((String)("Cannot set value for '" + name + "':" + e));
            }
            ObjectListDataProviderTest.assertEquals((String)("Updated value for '" + name + "'"), (Object)ObjectListDataProviderTest.updates[i].value, (Object)this.dp.getValue(this.dp.getFieldKey(name)));
        }
    }

    static class Update {
        public String name;
        public Object value;

        public Update(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    class MyTransactionalListener
    implements TransactionalDataListener,
    TableDataListener {
        String log = "";

        MyTransactionalListener() {
        }

        public String getLog() {
            return this.log;
        }

        public void clear() {
            this.log = "";
        }

        public void changesCommitted(TransactionalDataProvider tdp) {
            this.log = this.log + "changesCommitted//";
        }

        public void changesReverted(TransactionalDataProvider tdp) {
            this.log = this.log + "changesReverted//";
        }

        public void providerChanged(DataProvider dp) {
            this.log = this.log + "providerChanged//";
        }

        public void rowAdded(TableDataProvider dp, RowKey rk) {
            this.log = this.log + "rowAdded/" + rk + "//";
        }

        public void rowRemoved(TableDataProvider dp, RowKey rk) {
            this.log = this.log + "rowRemoved/" + rk + "//";
        }

        public void valueChanged(DataProvider dp, FieldKey fk, Object oldValue, Object newValue) {
            this.log = this.log + fk + "/" + oldValue + "/" + newValue + "//";
        }

        public void valueChanged(TableDataProvider dp, FieldKey fk, RowKey rk, Object oldValue, Object newValue) {
            this.log = this.log + fk + "/" + rk + "/" + oldValue + "/" + newValue + "//";
        }
    }

    class MyDataListener
    implements TableDataListener {
        String log = "";

        MyDataListener() {
        }

        public String getLog() {
            return this.log;
        }

        public void clear() {
            this.log = "";
        }

        public void valueChanged(DataProvider dp, FieldKey fk, Object oldValue, Object newValue) {
            this.log = this.log + fk + "/" + oldValue + "/" + newValue + "//";
        }

        public void providerChanged(DataProvider dp) {
            this.log = this.log + "providerChanged//";
        }

        public void rowAdded(TableDataProvider dp, RowKey rk) {
            this.log = this.log + "rowAdded/" + rk + "//";
        }

        public void rowRemoved(TableDataProvider dp, RowKey rk) {
            this.log = this.log + "rowRemoved/" + rk + "//";
        }

        public void valueChanged(TableDataProvider dp, FieldKey fk, RowKey rk, Object oldValue, Object newValue) {
            this.log = this.log + fk + "/" + rk + "/" + oldValue + "/" + newValue + "//";
        }
    }

    static class MyCursorListener
    implements TableCursorListener {
        boolean veto = false;
        String log = "";

        MyCursorListener() {
        }

        public String getLog() {
            return this.log;
        }

        public void clear() {
            this.log = "";
        }

        public void cursorChanged(TableDataProvider dp, RowKey oldRow, RowKey newRow) {
            this.log = this.log + "cursorChanged/" + oldRow + "/" + newRow + "//";
        }

        public void cursorChanging(TableDataProvider dp, RowKey oldRow, RowKey newRow) throws TableCursorVetoException {
            this.log = this.log + "cursorChanging/" + oldRow + "/" + newRow + "//";
            if (this.veto) {
                this.log = this.log + "cursorVetoed/" + oldRow + "/" + newRow + "//";
                throw new TableCursorVetoException("No way, Jose");
            }
        }

        public boolean isVeto() {
            return this.veto;
        }

        public void setVeto(boolean veto) {
            this.veto = veto;
        }
    }

    static class Listener
    implements DataListener {
        String log = "";

        Listener() {
        }

        public String getLog() {
            return this.log;
        }

        public void clear() {
            this.log = "";
        }

        public void valueChanged(DataProvider dp, FieldKey dk, Object oldValue, Object newValue) {
            this.log = this.log + dk.getFieldId() + "/" + oldValue + "/" + newValue + "//";
        }

        public void providerChanged(DataProvider dp) {
            this.log = this.log + "providerChanged//";
        }
    }

    static class Descriptor {
        public String name;
        public Class type;
        public boolean canSetValue;
        public Object defaultValue;

        public Descriptor(String name, Class type, boolean canSetValue, Object defaultValue) {
            this.name = name;
            this.type = type;
            this.canSetValue = canSetValue;
            this.defaultValue = defaultValue;
        }
    }
}

