/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.F21Format;
import com.sun.tdk.signaturetest.sigfile.F40Format;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Converter
extends Result {
    private static PrintWriter log = new PrintWriter(System.err, true);
    private String oldFileName;
    private String newFileName;
    public static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Converter.class);
    private static final String OLDFILE_OPTION = "-OldFile";
    private static final String NEWFILE_OPTION = "-NewFile";
    private static final String HELP_OPTION = "-Help";
    private static final String QUESTIONMARK = "-?";

    public static void main(String[] args) throws IOException {
        Converter converter = new Converter();
        System.err.println(i18n.getString("Converter.message.startup"));
        if (converter.parseParameters(args)) {
            converter.run();
        }
        log.flush();
    }

    private void run() throws IOException {
        ClassDescription currentClass;
        F21Format oldFormat = new F21Format();
        F40Format newFormat = new F40Format();
        Reader reader = ((Format)oldFormat).getReader();
        reader.readSignatureFile(new File(this.oldFileName).toURL());
        Writer writer = ((Format)newFormat).getWriter();
        writer.init(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.newFileName), "UTF8")));
        writer.setApiVersion(reader.getApiVersion());
        if (reader.hasFeature(FeaturesHolder.ConstInfo)) {
            writer.addFeature(FeaturesHolder.ConstInfo);
        }
        writer.writeHeader();
        while ((currentClass = reader.readNextClass()) != null) {
            writer.write(currentClass);
        }
        reader.close();
        writer.close();
        System.err.println(i18n.getString("Converter.message.success_conversion"));
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], HELP_OPTION) || parser.isOptionSpecified(args[0], QUESTIONMARK))) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption(OLDFILE_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(NEWFILE_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            Converter.usage();
            log.println(e.getMessage());
            return false;
        }
        return this.passed();
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(OLDFILE_OPTION)) {
            this.oldFileName = args[0];
        } else if (optionName.equalsIgnoreCase(NEWFILE_OPTION)) {
            this.newFileName = args[0];
        }
    }

    private static void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(i18n.getString("Converter.usage.start"));
        sb.append(nl).append(i18n.getString("Converter.usage.oldfilename", OLDFILE_OPTION));
        sb.append(nl).append(i18n.getString("Converter.usage.newfilename", NEWFILE_OPTION));
        System.err.println(sb.toString());
    }
}

