/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.merge.JSR68Merger;
import com.sun.tdk.signaturetest.merge.MergedSigFile;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Merge
extends SigTest
implements Log {
    private static final String FILES_OPTION = "-Files";
    private static final String WRITE_OPTION = "-Write";
    private static final String BINARY_OPTION = "-Binary";
    private static final String HELP_OPTION = "-Help";
    public static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Merge.class);
    private boolean binary = false;
    private String resultedFile;
    private String[] signatureFiles;

    public static void main(String[] args) {
        Merge m = Merge.getInstance();
        m.run(args, new PrintWriter(System.err, true), null);
        m.exit();
    }

    protected static Merge getInstance() {
        return new Merge();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        log = pw;
        if (this.parseParameters(args)) {
            this.perform();
            log.flush();
        } else {
            this.usage();
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        this.initErrors();
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], HELP_OPTION) || parser.isOptionSpecified(args[0], "-?"))) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption(FILES_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(WRITE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(BINARY_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(HELP_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-TestURL", OptionInfo.option(1), "decodeOptions");
        try {
            parser.processArgs(args);
            if (this.resultedFile != null) {
                this.checkValidWriteFile();
            }
        }
        catch (CommandLineParserException e) {
            log.println(e.getMessage());
            return this.failed(e.getMessage());
        }
        return this.passed();
    }

    private void checkValidWriteFile() throws CommandLineParserException {
        File canonicalFile = null;
        try {
            canonicalFile = new File(this.resultedFile).getCanonicalFile();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.resultedFile));
        }
        for (int i = 0; i < this.signatureFiles.length; ++i) {
            try {
                File sigFile = new File(this.signatureFiles[i]).getCanonicalFile();
                if (!canonicalFile.equals(sigFile)) continue;
                throw new CommandLineParserException(i18n.getString("Merge.notunique.writefile"));
            }
            catch (IOException ex) {
                throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.signatureFiles[i]));
            }
        }
        try {
            FileOutputStream f = new FileOutputStream(this.resultedFile);
            f.close();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.create.write.file"));
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(FILES_OPTION)) {
            StringTokenizer st = new StringTokenizer(args[0], File.pathSeparator);
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreElements()) {
                list.add(st.nextToken());
            }
            this.signatureFiles = list.toArray(new String[0]);
        } else if (optionName.equalsIgnoreCase(WRITE_OPTION)) {
            this.resultedFile = args[0];
        } else if (optionName.equalsIgnoreCase(BINARY_OPTION)) {
            this.binary = true;
        } else if (optionName.equalsIgnoreCase("-TestURL")) {
            this.testURL = args[0];
        }
    }

    void perform() {
        MergedSigFile[] files = new MergedSigFile[this.signatureFiles.length];
        for (int i = 0; i < this.signatureFiles.length; ++i) {
            PrintWriter log = new PrintWriter(System.out);
            MultipleFileReader in = new MultipleFileReader(log, MultipleFileReader.CLASSPATH_MODE);
            String sigFiles = this.signatureFiles[i];
            if (!in.readSignatureFiles(this.testURL, sigFiles)) {
                String msg = i18n.getString("SignatureTest.error.sigfile.invalid", sigFiles);
                in.close();
                this.error(msg);
            }
            files[i] = new MergedSigFile(in, this);
            MemberCollectionBuilder builder = new MemberCollectionBuilder(new SilentLog());
            for (ClassDescription c : files[i].getClassSet().values()) {
                c.setHierarchy(files[i].getClassHierarchy());
                try {
                    if (in.hasFeature(FeaturesHolder.BuildMembers)) {
                        builder.createMembers(c, true, true, false);
                    }
                    this.normalizer.normThrows(c, true);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        JSR68Merger merger = new JSR68Merger(this, this);
        VirtualClassDescriptionLoader result = merger.merge(files, this.binary ? 1 : 0);
        if (!this.isPassed()) {
            this.printErrors();
            return;
        }
        ClassHierarchyImpl ch = new ClassHierarchyImpl(result, 2);
        Iterator i = result.getClassIterator();
        while (i.hasNext()) {
            ClassDescription c = (ClassDescription)i.next();
            c.setHierarchy(ch);
        }
        MemberCollectionBuilder builder = new MemberCollectionBuilder(new SilentLog());
        Iterator i2 = result.getClassIterator();
        while (i2.hasNext()) {
            ClassDescription c = (ClassDescription)i2.next();
            try {
                builder.createMembers(c, false, true, false);
                this.normalizer.normThrows(c, true);
            }
            catch (ClassNotFoundException e) {
                this.storeError(i18n.getString("Merge.warning.message.classnotfound", e.getMessage()));
            }
        }
        try {
            Writer writer = FileManager.getDefaultFormat().getWriter();
            writer.setApiVersion("");
            if (this.resultedFile != null) {
                writer.init(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.resultedFile), "UTF8")));
            } else {
                writer.init(new PrintWriter(System.out));
            }
            writer.setAllFeatures(merger);
            writer.writeHeader();
            Iterator i3 = result.getClassIterator();
            while (i3.hasNext()) {
                ClassDescription c;
                c = (ClassDescription)i3.next();
                writer.write(c);
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error(e.getMessage());
        }
        this.printErrors();
    }

    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(i18n.getString("Setup.usage.start"));
        sb.append(nl).append(i18n.getString("Merge.usage.files", FILES_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.write", WRITE_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.binary", BINARY_OPTION));
        sb.append(nl).append(i18n.getString("Setup.usage.help", HELP_OPTION));
        sb.append(nl).append(i18n.getString("Setup.usage.end"));
        System.err.println(sb.toString());
    }

    class SilentLog
    implements Log {
        SilentLog() {
        }

        public void storeError(String s) {
        }

        public void storeWarning(String s) {
        }
    }
}

