/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.Setup;
import com.sun.tdk.signaturetest.SignatureTest;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SetupAndTest
extends Result {
    public static final String REFERENCE_OPTION = "-reference";
    public static final String TEST_OPTION = "-test";
    private final List setupOptions = new ArrayList();
    private final List testOptions = new ArrayList();

    public static void main(String[] args) {
        SetupAndTest t = new SetupAndTest();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    public boolean run(String[] args, PrintWriter log, PrintWriter ref) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?"))) {
            SetupAndTest.usage();
            return true;
        }
        this.addFlag(this.setupOptions, "-Static");
        this.addFlag(this.testOptions, "-Static");
        String optionsDecoder = "decodeOptions";
        parser.addOption(REFERENCE_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(TEST_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption("-Package", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-FileName", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-PackageWithoutSubpackages", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Exclude", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-out", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-FormatPlain", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-CheckValue", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-NoCheckValue", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-?", OptionInfo.optionalFlag(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            SetupAndTest.usage();
            log.println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (!parser.isOptionSpecified("-FileName")) {
            String tmpsigfile = null;
            try {
                File f = File.createTempFile("tmpsigfile", ".sig");
                f.deleteOnExit();
                tmpsigfile = f.getPath();
                this.addOption(this.setupOptions, "-FileName", tmpsigfile);
                this.addOption(this.testOptions, "-FileName", tmpsigfile);
            }
            catch (IOException ioe) {
                return this.failed(i18n.getString("SetupAndTest.error.message.tempfile", tmpsigfile));
            }
        }
        log.println(i18n.getString("SetupAndTest.message.invoke.setup"));
        Setup setup = new Setup();
        setup.run(this.setupOptions.toArray(new String[this.setupOptions.size()]), log, ref);
        if (setup.isPassed()) {
            log.println(i18n.getString("SetupAndTest.message.invoke.sigtest"));
            SignatureTest sigtest = new SignatureTest();
            sigtest.run(this.testOptions.toArray(new String[this.testOptions.size()]), log, ref);
            sigtest.exit();
        } else {
            setup.exit();
        }
        return false;
    }

    private void addOption(List options, String optionName, String optionValue) {
        options.add(optionName);
        options.add(optionValue);
    }

    private void addFlag(List options, String flag) {
        options.add(flag);
    }

    public void decodeOptions(String optionName, String[] args) {
        if (optionName.equalsIgnoreCase("-Help") || optionName.equals("-?")) {
            SetupAndTest.usage();
        } else if (optionName.equalsIgnoreCase(REFERENCE_OPTION)) {
            this.addOption(this.setupOptions, "-Classpath", args[0]);
        } else if (optionName.equalsIgnoreCase(TEST_OPTION)) {
            this.addOption(this.testOptions, "-Classpath", args[0]);
        } else if (optionName.equalsIgnoreCase("-FileName") || optionName.equalsIgnoreCase("-Package") || optionName.equalsIgnoreCase("-PackageWithoutSubpackages") || optionName.equalsIgnoreCase("-Exclude") || optionName.equalsIgnoreCase("-ApiVersion") || optionName.equalsIgnoreCase("-ClassCacheSize")) {
            this.addOption(this.setupOptions, optionName, args[0]);
            this.addOption(this.testOptions, optionName, args[0]);
        } else if (optionName.equalsIgnoreCase("-Verbose")) {
            this.addFlag(this.setupOptions, optionName);
            this.addFlag(this.testOptions, optionName);
        } else if (optionName.equalsIgnoreCase("-out")) {
            this.addOption(this.testOptions, optionName, args[0]);
        } else if (optionName.equalsIgnoreCase("-FormatPlain") || optionName.equalsIgnoreCase("-CheckValue")) {
            this.addFlag(this.testOptions, optionName);
        }
    }

    public static void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(i18n.getString("SetupAndTest.usage.version", "1.5.2"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.start"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.reference", REFERENCE_OPTION));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.test", TEST_OPTION));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.filename", "-FileName"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.package", "-Package"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.packagewithoutsubpackages", "-PackageWithoutSubpackages"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.exclude", "-Exclude"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.verbose", "-Verbose"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.checkvalue", "-CheckValue"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.out", "-out"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.formatplain", "-FormatPlain"));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.classcachesize", new Object[]{"-ClassCacheSize", new Integer(1024)}));
        sb.append(nl).append(i18n.getString("SetupAndTest.usage.help", "-Help"));
        System.err.println(sb.toString());
    }
}

