/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.ThrowsNormalizer;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.plugin.Context;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.Plugin;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class SigTest
extends Result
implements PluginAPI,
Log {
    public static final String ALLPUBLIC_OPTION = "-AllPublic";
    public static final String CLASSPATH_OPTION = "-Classpath";
    public static final String PACKAGE_OPTION = "-Package";
    public static final String WITHOUTSUBPACKAGES_OPTION = "-PackageWithoutSubpackages";
    public static final String EXCLUDE_OPTION = "-Exclude";
    public static final String STATIC_OPTION = "-Static";
    public static final String APIVERSION_OPTION = "-ApiVersion";
    public static final String VERSION_OPTION = "-Version";
    public static final String DEBUG_OPTION = "-Debug";
    public static final String HELP_OPTION = "-Help";
    public static final String QUESTIONMARK = "-?";
    public static final String CLASSCACHESIZE_OPTION = "-ClassCacheSize";
    public static final String VERBOSE_OPTION = "-Verbose";
    public static final String XVERBOSE_OPTION = "-Xverbose";
    public static final String XNOTIGER_OPTION = "-XnoTiger";
    public static final String OUT_OPTION = "-out";
    public static final String FORMATPLAIN_OPTION = "-FormatPlain";
    public static final String FILENAME_OPTION = "-FileName";
    public static final String TESTURL_OPTION = "-TestURL";
    public static final String PLUGIN_OPTION = "-Plugin";
    public static final String ERRORALL_OPTION = "-ErrorAll";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SigTest.class);
    protected String testURL = "";
    protected String sigFileNameList = null;
    protected String sigFileName = null;
    protected int trackMode;
    protected PackageGroup packages = new PackageGroup(true);
    protected PackageGroup purePackages = new PackageGroup(false);
    protected PackageGroup excludedPackages = new PackageGroup(true);
    protected String classpathStr = null;
    protected static ErrorFormatter errorManager;
    protected String apiVersion = "";
    protected MemberCollectionBuilder builder;
    protected ThrowsNormalizer normalizer = new ThrowsNormalizer();
    protected boolean isStatic = false;
    public static boolean isConstantValuesTracked;
    public static final int DefaultCacheSize = 1024;
    protected int cacheSize = 1024;
    public static PrintWriter log;
    public static boolean debug;
    protected ClasspathImpl classpath;
    public static boolean isTigerFeaturesTracked;
    protected Plugin pluginClass = null;
    static boolean Xverbose;
    protected ClassHierarchy classHierarchy;
    protected Set errorMessages = new HashSet();
    private ClassDescriptionLoader loader;
    protected boolean reportWarningAsError = false;
    protected int errors;

    public void initErrors() {
        this.errorMessages.clear();
    }

    public void storeError(String s) {
        this.errorMessages.add(s);
    }

    public void storeWarning(String s) {
        if (this.reportWarningAsError) {
            this.storeError(s);
            return;
        }
        log.println(s);
    }

    public void printErrors() {
        Iterator it = this.errorMessages.iterator();
        while (it.hasNext()) {
            this.setupProblem((String)it.next());
        }
        this.initErrors();
    }

    protected void setupProblem(String msg) {
        log.println(msg);
        ++this.errors;
    }

    protected void setLog(PrintWriter w) {
        log = w;
    }

    protected void decodeCommonOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(TESTURL_OPTION)) {
            this.testURL = args[0];
        } else if (optionName.equalsIgnoreCase(FILENAME_OPTION)) {
            this.sigFileName = args[0];
        } else if (optionName.equalsIgnoreCase(PACKAGE_OPTION)) {
            this.packages.addPackages(args);
        } else if (optionName.equalsIgnoreCase(WITHOUTSUBPACKAGES_OPTION)) {
            this.purePackages.addPackages(args);
        } else if (optionName.equalsIgnoreCase(EXCLUDE_OPTION)) {
            this.excludedPackages.addPackages(args);
        } else if (optionName.equalsIgnoreCase(CLASSPATH_OPTION)) {
            this.classpathStr = args[0];
        } else if (optionName.equalsIgnoreCase(VERSION_OPTION) || optionName.equalsIgnoreCase(APIVERSION_OPTION)) {
            this.apiVersion = args[0];
        } else if (optionName.equalsIgnoreCase(STATIC_OPTION)) {
            this.isStatic = true;
        } else if (optionName.equalsIgnoreCase(CLASSCACHESIZE_OPTION)) {
            this.cacheSize = 0;
            try {
                this.cacheSize = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                if (debug) {
                    ex.printStackTrace();
                }
                this.cacheSize = 0;
            }
            if (this.cacheSize <= 0) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.arg.invalid", optionName));
            }
        } else if (optionName.equalsIgnoreCase(ALLPUBLIC_OPTION)) {
            this.trackMode = 2;
        } else if (optionName.equalsIgnoreCase(DEBUG_OPTION)) {
            debug = true;
        } else if (optionName.equalsIgnoreCase(ERRORALL_OPTION)) {
            this.reportWarningAsError = true;
        } else if (optionName.equalsIgnoreCase(XNOTIGER_OPTION)) {
            isTigerFeaturesTracked = false;
        } else if (optionName.equalsIgnoreCase(XVERBOSE_OPTION)) {
            Xverbose = true;
        } else if (optionName.equalsIgnoreCase(PLUGIN_OPTION)) {
            this.pluginClass = this.loadPlugin(args[0]);
            if (this.pluginClass == null) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.cant_load.plugin", args[0]));
            }
        } else if (optionName.equalsIgnoreCase(HELP_OPTION) || optionName.equalsIgnoreCase(QUESTIONMARK)) {
            this.usage();
        }
    }

    public int getNumErrors() {
        return errorManager.getNumErrors();
    }

    protected boolean isPackageMember(String name) {
        return !this.excludedPackages.checkName(name) && (this.packages.checkName(name) || this.purePackages.checkName(name));
    }

    public void setClassDescrLoader(ClassDescriptionLoader loader) {
        this.loader = loader;
    }

    protected ClassDescriptionLoader getClassDescrLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.isStatic) {
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.BinaryClassDescrLoader", new Class[]{Classpath.class, Integer.class}, new Object[]{this.classpath, new Integer(this.cacheSize)});
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadstatic"));
            }
        } else {
            if (isTigerFeaturesTracked) {
                this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.TigerRefgClassDescrLoader", new Class[0], new Object[0]);
                if (this.loader != null) {
                    return this.loader;
                }
                isTigerFeaturesTracked = false;
            }
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.ReflClassDescrLoader", new Class[0], new Object[0]);
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadreflect"));
            }
        }
        return this.loader;
    }

    protected ClassDescription load(String name) {
        try {
            return this.classHierarchy.load(name);
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                e.printStackTrace();
            }
            this.storeError(i18n.getString("SigTest.error.class.missing", name));
        }
        catch (LinkageError e) {
            if (debug) {
                e.printStackTrace();
            }
            this.storeError(i18n.getString("SigTest.error.class.notlinked", e.getMessage()));
        }
        return null;
    }

    private static ClassDescriptionLoader getLoader(String name, Class[] pars, Object[] args) {
        try {
            Constructor<?> ctor = Class.forName(name).getConstructor(pars);
            return (ClassDescriptionLoader)ctor.newInstance(args);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
    }

    public boolean useErasurator() {
        return !isTigerFeaturesTracked;
    }

    protected abstract void usage();

    protected Plugin loadPlugin(String pluginClassName) {
        try {
            Constructor<?> ctor = Class.forName(pluginClassName).getConstructor(new Class[0]);
            return (Plugin)ctor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
    }

    public Filter getFilter(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getFilter();
    }

    public void setFilter(PluginAPI.InjectionPoint injectionPoint, Filter filter) {
        injectionPoint.setFilter(filter);
    }

    public Transformer getTransformer(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getTransformer();
    }

    public void setTransformer(PluginAPI.InjectionPoint injectionPoint, Transformer transformer) {
        injectionPoint.setTransformer(transformer);
    }

    public Context getContext() {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public void addFormat(Format format, boolean useByDefault) {
        FileManager.addFormat(format, useByDefault);
    }

    static {
        isConstantValuesTracked = true;
        debug = false;
        isTigerFeaturesTracked = false;
        try {
            String specVersion = System.getProperty("java.specification.version");
            if ("1.5".compareTo(specVersion) <= 0) {
                isTigerFeaturesTracked = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Xverbose = false;
    }
}

