/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassCorrector;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.DefaultAfterBuildMembersTransformer;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MethodOverridingChecker;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MemberCollectionBuilder {
    private ClassCorrector cc;
    private Erasurator erasurator = new Erasurator();
    private Transformer defaultTransformer = new DefaultAfterBuildMembersTransformer();
    private Log log;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MemberCollectionBuilder.class);

    public MemberCollectionBuilder(Log log) {
        this.cc = new ClassCorrector(log);
        this.log = log;
    }

    public void createMembers(ClassDescription cl, boolean addInherited, boolean fixClass, boolean checkHidding) throws ClassNotFoundException {
        MemberCollection members = this.getMembers(cl, addInherited, checkHidding);
        SuperClass spr = cl.getSuperClass();
        if (spr != null) {
            members.addMember(spr);
        }
        ConstructorDescr[] constr = cl.getDeclaredConstructors();
        for (int i = 0; i < constr.length; ++i) {
            members.addMember(constr[i]);
        }
        cl.setMembers(members);
        Transformer t = PluginAPI.AFTER_BUILD_MEMBERS.getTransformer();
        if (t == null) {
            t = this.defaultTransformer;
        }
        t.transform(cl);
        if (fixClass) {
            t = PluginAPI.CLASS_CORRECTOR.getTransformer();
            if (t == null) {
                t = this.cc;
            }
            t.transform(cl);
        }
        if ((t = PluginAPI.AFTER_CLASS_CORRECTOR.getTransformer()) != null) {
            t.transform(cl);
        }
    }

    private MemberCollection getMembers(ClassDescription cl, boolean addInherited, boolean checkHidding) throws ClassNotFoundException {
        return this.getMembers(cl, null, true, false, addInherited, checkHidding);
    }

    private MemberCollection getMembers(ClassDescription cl, String actualTypeParams, boolean skipRawTypes, boolean callErasurator, boolean addInherited, boolean checkHidding) throws ClassNotFoundException {
        int i;
        assert (cl != null);
        this.erasurator.parseTypeParameters(cl);
        ArrayList paramList = null;
        MemberCollection retVal = new MemberCollection();
        MemberDescription[] methods = cl.getDeclaredMethods();
        MemberDescription[] fields = cl.getDeclaredFields();
        MemberDescription[] classes = cl.getDeclaredClasses();
        String clsName = cl.getQualifiedName();
        ClassHierarchy hierarchy = cl.getClassHierarchy();
        if (actualTypeParams != null) {
            paramList = Erasurator.splitParameters(actualTypeParams);
            methods = Erasurator.replaceFormalParameters(clsName, methods, (List)paramList, skipRawTypes);
            fields = Erasurator.replaceFormalParameters(clsName, fields, (List)paramList, skipRawTypes);
            classes = Erasurator.replaceFormalParameters(clsName, classes, (List)paramList, skipRawTypes);
        } else if (callErasurator && cl.getTypeParameters() != null) {
            ArrayList boundsList = cl.getTypeBounds();
            methods = Erasurator.replaceFormalParameters(clsName, methods, (List)boundsList, false);
            fields = Erasurator.replaceFormalParameters(clsName, fields, (List)boundsList, false);
            classes = Erasurator.replaceFormalParameters(clsName, classes, (List)boundsList, false);
        }
        MethodOverridingChecker overridingChecker = new MethodOverridingChecker(this.erasurator);
        overridingChecker.addMethods(methods);
        for (i = 0; i < methods.length; ++i) {
            retVal.addMember(methods[i]);
        }
        for (i = 0; i < fields.length; ++i) {
            retVal.addMember(fields[i]);
        }
        for (i = 0; i < classes.length; ++i) {
            retVal.addMember(classes[i]);
        }
        MemberDescription[] intrfs = cl.getInterfaces();
        if (paramList != null) {
            intrfs = Erasurator.replaceFormalParameters(clsName, intrfs, (List)paramList, skipRawTypes);
        }
        for (int i2 = 0; i2 < intrfs.length; ++i2) {
            SuperInterface s = (SuperInterface)intrfs[i2];
            s.setDirect(true);
            retVal.addMember(s);
        }
        if (addInherited) {
            Set internalClasses = Collections.EMPTY_SET;
            if (checkHidding) {
                internalClasses = cl.getInternalClasses();
            }
            HashMap<String, MemberDescription> inheritedFields = new HashMap<String, MemberDescription>();
            SuperClass superClassDescr = cl.getSuperClass();
            if (superClassDescr != null) {
                ClassDescription superClass = hierarchy.load(superClassDescr.getQualifiedName());
                MemberCollection superMembers = this.getMembers(superClass, superClassDescr.getTypeParameters(), false, true, addInherited, checkHidding);
                this.findInheritableAnnotations(cl, superClass);
                superMembers = this.getAccessibleMembers(superMembers, cl, superClass);
                Collection coll = superMembers.getAllMembers();
                if (paramList != null) {
                    coll = Erasurator.replaceFormalParameters(clsName, coll, (List)paramList, skipRawTypes);
                }
                for (MemberDescription fid : coll) {
                    if (fid.isMethod()) {
                        MethodDescr m = (MethodDescr)fid;
                        MethodDescr overriden = overridingChecker.getOverridingMethod(m, true);
                        MemberDescription erased = this.erasurator.processMember(fid);
                        if (overriden == null) {
                            retVal.addMember(m);
                            continue;
                        }
                        if (PrimitiveTypes.isPrimitive(m.getType()) || m.getType().endsWith("]")) continue;
                        try {
                            String newReturnType;
                            String existReturnType = overriden.getType();
                            if (existReturnType.equals(newReturnType = erased.getType()) || !cl.getClassHierarchy().getSuperClasses(newReturnType).contains(existReturnType) && !cl.getClassHierarchy().getAllImplementedInterfaces(newReturnType).contains(existReturnType)) continue;
                            retVal.updateMember(fid);
                        }
                        catch (ClassNotFoundException e) {
                            this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", m.getType()));
                        }
                        continue;
                    }
                    if (fid.isField()) {
                        fid.unmark();
                        inheritedFields.put(fid.getName(), fid);
                        continue;
                    }
                    if (fid.isSuperInterface()) {
                        SuperInterface si = (SuperInterface)fid.clone();
                        si.setDirect(false);
                        retVal.addMember(si);
                        continue;
                    }
                    if (fid.isInner()) {
                        if (internalClasses.contains(fid.getName())) continue;
                        retVal.addMember(fid);
                        continue;
                    }
                    retVal.addMember(fid);
                }
            }
            SuperInterface[] interfaces = cl.getInterfaces();
            for (int i3 = 0; i3 < interfaces.length; ++i3) {
                ClassDescription intf = hierarchy.load(interfaces[i3].getQualifiedName());
                MemberCollection h = this.getMembers(intf, interfaces[i3].getTypeParameters(), false, true, addInherited, checkHidding);
                Collection coll = h.getAllMembers();
                if (paramList != null) {
                    coll = Erasurator.replaceFormalParameters(clsName, coll, (List)paramList, skipRawTypes);
                }
                for (MemberDescription fid : coll) {
                    if (fid.isMethod()) {
                        MethodDescr m = (MethodDescr)fid;
                        MethodDescr overriden = overridingChecker.getOverridingMethod(m, true);
                        MemberDescription erased = this.erasurator.processMember(fid);
                        if (overriden == null) {
                            retVal.addMember(m);
                            continue;
                        }
                        if (PrimitiveTypes.isPrimitive(m.getType()) || m.getType().endsWith("]")) continue;
                        try {
                            String newReturnType;
                            String existReturnType = overriden.getType();
                            if (existReturnType.equals(newReturnType = erased.getType()) || !cl.getClassHierarchy().getSuperClasses(newReturnType).contains(existReturnType) && !cl.getClassHierarchy().getAllImplementedInterfaces(newReturnType).contains(existReturnType)) continue;
                            retVal.updateMember(fid);
                        }
                        catch (ClassNotFoundException e) {
                            this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", m.getType()));
                        }
                        continue;
                    }
                    if (fid.isField()) {
                        MemberDescription storedFid = (MemberDescription)inheritedFields.get(fid.getName());
                        if (storedFid != null) {
                            if (storedFid.getQualifiedName().equals(fid.getQualifiedName())) continue;
                            storedFid.mark();
                            continue;
                        }
                        fid.unmark();
                        inheritedFields.put(fid.getName(), fid);
                        continue;
                    }
                    if (fid.isSuperInterface()) {
                        SuperInterface si = (SuperInterface)fid.clone();
                        si.setDirect(false);
                        retVal.addMember(si);
                        continue;
                    }
                    if (fid.isInner()) {
                        if (internalClasses.contains(fid.getName())) continue;
                        retVal.addMember(fid);
                        continue;
                    }
                    retVal.addMember(fid);
                }
            }
            Set internalFields = Collections.EMPTY_SET;
            if (checkHidding) {
                internalFields = cl.getInternalFields();
            }
            for (MemberDescription field : inheritedFields.values()) {
                if (field.isMarked() || internalFields.contains(field.getName())) continue;
                retVal.addMember(field);
            }
        } else {
            SuperClass superClassDescr = cl.getSuperClass();
            if (superClassDescr != null) {
                ClassDescription superClass = hierarchy.load(superClassDescr.getQualifiedName());
                this.findInheritableAnnotations(cl, superClass);
            }
        }
        return retVal;
    }

    private MemberCollection getAccessibleMembers(MemberCollection members, ClassDescription subclass, ClassDescription superClass) {
        String pkg = subclass.getPackageName();
        boolean isSamePackage = pkg.equals(superClass.getPackageName());
        MemberCollection retVal = new MemberCollection();
        Iterator e = members.iterator();
        while (e.hasNext()) {
            MemberDescription mbr = (MemberDescription)e.next();
            if (!mbr.isPublic() && !mbr.isProtected() && !isSamePackage && !mbr.isSuperInterface() || mbr.isPrivate()) continue;
            retVal.addMember(mbr);
        }
        return retVal;
    }

    private void findInheritableAnnotations(ClassDescription subclass, ClassDescription superClass) {
        AnnotationItem[] superClassAnnoList = superClass.getAnnoList();
        if (superClassAnnoList.length != 0) {
            int i;
            TreeSet<AnnotationItem> tmp = new TreeSet<AnnotationItem>();
            AnnotationItem[] subClassAnnoList = subclass.getAnnoList();
            for (i = 0; i < superClassAnnoList.length; ++i) {
                if (!superClassAnnoList[i].isInheritable()) continue;
                tmp.add(superClassAnnoList[i]);
            }
            for (i = 0; i < subClassAnnoList.length; ++i) {
                tmp.add(subClassAnnoList[i]);
            }
            if (tmp.size() != subClassAnnoList.length) {
                AnnotationItem[] newAnnoList = new AnnotationItem[tmp.size()];
                tmp.toArray(newAnnoList);
                subclass.setAnnoList(newAnnoList);
            }
        }
    }
}

