/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import java.io.PrintWriter;

public class ErrorFormatter {
    public static final String annoAdded = "Added Annotations";
    public static final String annoMissed = "Missed Annotations";
    PrintWriter out;
    int size;

    public ErrorFormatter(PrintWriter out) {
        this.out = out;
    }

    public void addError(MessageType kind, String className, MemberType type, String def, MemberDescription errorObject) {
        this.addError(kind, className, type, def, null, errorObject);
    }

    public void addError(MessageType kind, String className, MemberType type, String def, String tail, MemberDescription errorObject) {
        this.out.println(this.createError(kind, className, type, def, tail, errorObject));
        if (!kind.isWarning()) {
            ++this.size;
        }
    }

    protected Message createError(MessageType kind, String className, MemberType type, String def, String tail, MemberDescription errorObject) {
        return new Message(kind, className, def, tail, errorObject);
    }

    public void printErrors() {
    }

    public int getNumErrors() {
        return this.size;
    }

    public static class Message
    implements Comparable {
        public MemberDescription errorObject;
        public String className;
        public String definition;
        public String tail;
        public MessageType messageType;

        public Message(MessageType error, String className, String definition, String tail, MemberDescription errorObject) {
            this.messageType = error;
            this.className = className;
            this.definition = definition == null ? "" : definition;
            this.tail = tail == null ? "" : tail;
            this.errorObject = errorObject;
        }

        public int compareTo(Object o) {
            Message ob = (Message)o;
            int comp = 0;
            if (ob.messageType == this.messageType && (comp = this.className.compareTo(ob.className)) == 0) {
                comp = this.getShortName(this.definition).compareTo(this.getShortName(ob.definition));
            }
            return comp;
        }

        public String getShortName(String def) {
            String retVal = def;
            int pos = def.lastIndexOf(" throws ");
            if (pos >= 0) {
                retVal = def.substring(0, pos);
            }
            return retVal.substring(retVal.lastIndexOf(32) + 1);
        }

        public String toString() {
            String retVal = this.messageType.getLocMessage();
            return retVal + " " + this.className + "\n    " + this.definition + this.tail;
        }
    }
}

