/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MemberCollection {
    private Set members = new HashSet();

    public void addMember(MemberDescription member) {
        if (MemberType.CLASS == member.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        this.members.add(member);
    }

    public void updateMember(MemberDescription member) {
        if (MemberType.CLASS == member.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        this.members.remove(member);
        this.members.add(member);
    }

    public Collection getAllMembers() {
        return this.members;
    }

    public boolean contains(MemberDescription newMember) {
        return this.members.contains(newMember);
    }

    public Iterator iterator() {
        return this.members.iterator();
    }

    public MemberDescription find(MemberDescription mr) {
        for (MemberDescription member : this.members) {
            if (!member.equals(mr)) continue;
            return member;
        }
        return null;
    }

    public int getMembersCount(MemberType memberType, String fqname) {
        int count = 0;
        for (MemberDescription member : this.members) {
            if (memberType != null && memberType != member.getMemberType() || !fqname.equals(member.getQualifiedName())) continue;
            ++count;
        }
        return count;
    }
}

