/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import java.util.ArrayList;
import java.util.List;

public class PackageDescr {
    private List classes;
    private List subpackages;
    private String fqname;
    private String name = "";

    public String getQualifiedName() {
        return this.fqname;
    }

    public String getName() {
        return this.name;
    }

    public PackageDescr(String fqname) {
        this.fqname = fqname;
        this.name = fqname.lastIndexOf(".") > 0 ? fqname.substring(fqname.lastIndexOf(".") + 1) : fqname;
        this.classes = new ArrayList();
        this.subpackages = new ArrayList();
    }

    public void add(ClassDescription cd) {
        for (int i = 0; i < this.classes.size(); ++i) {
            if (((ClassDescription)this.classes.get(i)).getQualifiedName().compareTo(cd.getQualifiedName()) <= 0) continue;
            this.classes.add(i, cd);
            return;
        }
        this.classes.add(cd);
    }

    public void add(PackageDescr pd) {
        for (int i = 0; i < this.subpackages.size(); ++i) {
            if (((PackageDescr)this.subpackages.get(i)).getQualifiedName().compareTo(pd.getQualifiedName()) <= 0) continue;
            this.subpackages.add(i, pd);
            return;
        }
        this.subpackages.add(pd);
    }

    public void addAll(List list) {
        this.classes.addAll(list);
    }

    public void clear() {
        this.classes.clear();
    }

    public List getDeclaredClasses() {
        return this.classes;
    }

    public List getDeclaredPackages() {
        return this.subpackages;
    }

    public String toString() {
        return this.fqname;
    }

    public boolean equals(Object arg) {
        return arg instanceof PackageDescr && this.fqname.equals(((PackageDescr)arg).getQualifiedName());
    }

    public boolean isCompatible(MemberDescription m) {
        return this.equals(m);
    }
}

