/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class MultipleFileReader
extends VirtualClassDescriptionLoader {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MultipleFileReader.class);
    public static int CLASSPATH_MODE = 1;
    public static int MERGE_MODE = 2;
    private Set features = new HashSet();
    private Iterator classIterator = null;
    private PrintWriter log;
    private int mode;
    private String apiVersion;

    public MultipleFileReader(PrintWriter log, int mode) {
        assert (mode == CLASSPATH_MODE);
        this.log = log;
        this.mode = mode;
        this.features.add(FeaturesHolder.ConstInfo);
        this.features.add(FeaturesHolder.TigerInfo);
        this.features.add(FeaturesHolder.BuildMembers);
    }

    public boolean hasFeature(FeaturesHolder.Feature feature) {
        return this.features.contains(feature);
    }

    public boolean readSignatureFiles(String testURL, String sigFileList) {
        assert (testURL != null);
        assert (sigFileList != null);
        boolean result = true;
        StringTokenizer st = new StringTokenizer(sigFileList, File.pathSeparator);
        while (st.hasMoreElements() && result) {
            String fileName = st.nextToken();
            result = this.readSignatureFile(testURL, fileName);
        }
        return result;
    }

    public boolean readSignatureFile(String testURL, String sigFileName) {
        boolean result;
        assert (testURL != null);
        assert (sigFileName != null);
        try {
            URL fileURL = FileManager.getURL(testURL, sigFileName);
            result = this.readFile(fileURL);
        }
        catch (MalformedURLException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            Object[] invargs = new String[]{testURL, e.getMessage()};
            this.log.println(i18n.getString("MultipleFileReader.error.url.threwerror", invargs));
            return false;
        }
        catch (IOException er) {
            if (SigTest.debug) {
                er.printStackTrace();
            }
            this.log.println(er);
            return false;
        }
        this.rewind();
        return result;
    }

    private boolean readFile(URL fileURL) {
        String msg = null;
        Reader in = FileManager.getReader(fileURL);
        if (in == null) {
            msg = i18n.getString("MultipleFileReader.error.sigreader.missing", fileURL);
            return false;
        }
        try {
            ClassDescription cl;
            if (!in.readSignatureFile(fileURL)) {
                msg = i18n.getString("MultipleFileReader.error.sigfile.invalid", fileURL);
            }
            if (this.mode == MERGE_MODE && !in.hasFeature(FeaturesHolder.MergeModeSupported)) {
                throw new IOException(i18n.getString("MultipleFileReader.error.cannt_merge_old_files") + fileURL);
            }
            if (!in.hasFeature(FeaturesHolder.ConstInfo)) {
                this.features.remove(FeaturesHolder.ConstInfo);
            }
            if (!in.hasFeature(FeaturesHolder.TigerInfo)) {
                this.features.remove(FeaturesHolder.TigerInfo);
            }
            if (!in.hasFeature(FeaturesHolder.BuildMembers)) {
                this.features.remove(FeaturesHolder.BuildMembers);
            }
            this.apiVersion = in.getApiVersion();
            while ((cl = in.readNextClass()) != null) {
                String name = cl.getQualifiedName();
                if (this.mode == CLASSPATH_MODE) {
                    ClassDescription old_cl = (ClassDescription)this.classDescriptions.get(name);
                    if (old_cl != null) continue;
                    this.classDescriptions.put(name, cl);
                    continue;
                }
                assert (this.mode == MERGE_MODE);
            }
        }
        catch (IOException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("MultipleFileReader.error.sigfile.prob") + "\n" + e;
        }
        catch (SecurityException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("MultipleFileReader.error.sigfile.sec") + "\n" + e;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (msg != null) {
            this.log.println(msg);
            return false;
        }
        return true;
    }

    public void close() {
        this.classIterator = null;
        this.classDescriptions.clear();
    }

    public void rewind() {
        this.classIterator = this.getClassIterator();
    }

    public ClassDescription nextClass() throws IOException {
        ClassDescription cl = null;
        if (this.classIterator != null && this.classIterator.hasNext()) {
            cl = (ClassDescription)this.classIterator.next();
        }
        return cl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

