/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.Reader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.netbeans.apitest.ClassSignatureReader;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.SignatureConstants;
import org.netbeans.apitest.TableOfClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassSignatureFromSigtests
extends ClassSignatureReader
implements SignatureConstants {
    private Vector definitions;
    private Reader reader;
    private DefinitionFormat converter;
    private Iterator<TableOfClass> allClasses;

    public ClassSignatureFromSigtests(Reader reader, URL url) throws IOException {
        this.reader = reader;
        reader.readSignatureFile(url);
    }

    private Iterator<TableOfClass> iterator() throws IOException {
        ClassDescription descr;
        if (this.allClasses != null) {
            return this.allClasses;
        }
        Erasurator erasurator = new Erasurator();
        HashMap<String, ClassDescription> all = new HashMap<String, ClassDescription>();
        while ((descr = this.reader.readNextClass()) != null) {
            descr = erasurator.fullErasure(descr);
            all.put(descr.getQualifiedName(), descr);
        }
        HashSet<TableOfClass> classes = new HashSet<TableOfClass>();
        for (Map.Entry entry : all.entrySet()) {
            TableOfClass retClass = new TableOfClass((ClassDescription)entry.getValue(), this.converter, all);
            classes.add(retClass);
        }
        this.allClasses = classes.iterator();
        return this.allClasses;
    }

    @Override
    String getJavaVersion() {
        return this.reader.getApiVersion();
    }

    @Override
    public void setDefinitionConverter(DefinitionFormat converter) {
        this.converter = converter;
    }

    @Override
    public TableOfClass nextClass() throws IOException {
        return this.iterator().hasNext() ? this.iterator().next() : null;
    }

    @Override
    public TableOfClass nextAPIClass() throws IOException {
        return this.nextClass();
    }
}

