/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.SignatureConstants;
import org.netbeans.apitest.TableOfClass;

class ClassSignatureReader
implements SignatureConstants {
    private BufferedReader in;
    private String currentLine;
    private Vector definitions;
    private DefinitionFormat converter;
    String javaVersion = " N/A";
    boolean isThrowsTracked = true;

    public ClassSignatureReader(String fileURL) throws IOException {
        this.in = new BufferedReader(new FileReader(fileURL));
        this.definitions = new Vector();
        this.currentLine = null;
        while ((this.currentLine = this.in.readLine()) != null && !this.currentLine.startsWith("CLSS ")) {
            if (this.currentLine.startsWith("#Version")) {
                this.javaVersion = this.currentLine.substring("#Version ".length());
            }
            if (!this.currentLine.startsWith("#Throws clause not tracked.")) continue;
            this.isThrowsTracked = false;
        }
    }

    ClassSignatureReader() {
    }

    public void setDefinitionConverter(DefinitionFormat converter) {
        this.converter = converter;
    }

    public TableOfClass nextClass() throws IOException {
        if (this.in == null || this.currentLine == null) {
            return null;
        }
        TableOfClass retClass = new TableOfClass(this.currentLine, this.converter);
        this.definitions = new Vector();
        while ((this.currentLine = this.in.readLine()) != null && !this.currentLine.startsWith("CLSS ")) {
            this.definitions.addElement(this.currentLine);
        }
        retClass.createMembers(this.definitions.elements());
        return retClass;
    }

    public TableOfClass nextAPIClass() throws IOException {
        if (this.in == null || this.currentLine == null) {
            return null;
        }
        TableOfClass retClass = new TableOfClass(this.currentLine, this.converter);
        this.definitions = new Vector();
        while ((this.currentLine = this.in.readLine()) != null && !this.currentLine.startsWith("CLSS ")) {
            this.definitions.addElement(this.currentLine);
        }
        retClass.createMembers(this.definitions.elements());
        return retClass;
    }

    String getJavaVersion() {
        return this.javaVersion;
    }

    private void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }
}

