/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Reader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import org.netbeans.apitest.APISortedErrorFormatter;
import org.netbeans.apitest.ClassCollection;
import org.netbeans.apitest.ClassFinder;
import org.netbeans.apitest.ClassSignatureFromSigtests;
import org.netbeans.apitest.ClassSignatureReader;
import org.netbeans.apitest.ClassSorter;
import org.netbeans.apitest.ClassesFromClasspath;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.ErrorFormatter;
import org.netbeans.apitest.ErrorMessage;
import org.netbeans.apitest.MemberDefinition;
import org.netbeans.apitest.MemberEntry;
import org.netbeans.apitest.PrimitiveConstantsChecker;
import org.netbeans.apitest.PrimitiveConstantsCheckerFromSigtests;
import org.netbeans.apitest.SignatureClass;
import org.netbeans.apitest.SortedErrorFormatter;
import org.netbeans.apitest.Status;
import org.netbeans.apitest.TableOfClass;

final class Main {
    PrintWriter log;
    private ClassesFromClasspath classIterator;
    private PrimitiveConstantsChecker converter;
    private ErrorFormatter errorWriter;
    private Pattern[] packages;
    private String[] excludedElements;
    private Vector<String> nonLinkedClasses = new Vector();
    private Vector<String> trackedClassNames = new Vector();
    private boolean isIgnorableReported = false;
    private boolean isMaintenanceMode = false;
    private boolean extensibleInterfaces;
    private boolean isReflectUsed = false;
    private int allClassesSize = 0;
    private int scanedClassesSize = 0;
    private int errors;
    private ClassFinder loader;
    private String version = System.getProperty("java.version");
    protected Properties details = new Properties();

    Main() {
    }

    public static void main(String[] args) {
        Status s = Main.run(args);
        if (s.getType() != 0) {
            System.err.println(s.getReason());
            System.exit(s.getType());
        }
    }

    static Status run(String[] args) {
        PrintWriter log = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
        PrintWriter ref = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        return Main.run(args, log, ref);
    }

    static Status run(String[] args, PrintWriter log, PrintWriter ref) {
        Main t = new Main();
        return t.doRun(args, log, ref);
    }

    private Status doRun(String[] args, PrintWriter log, PrintWriter ref) {
        int i;
        this.log = log;
        boolean setup = false;
        boolean isOrdering = true;
        String fileName = null;
        Vector<Pattern> tempPackages = new Vector<Pattern>();
        Vector<String> tempExcludedElements = new Vector<String>();
        String classpath = null;
        for (i = 0; i < args.length; ++i) {
            String pkg;
            if (args[i].equals("-FormatPlain")) {
                isOrdering = false;
                continue;
            }
            if (args[i].equals("-FileName") && args.length > i + 1) {
                fileName = args[++i];
                continue;
            }
            if (args[i].equals("-Version") && args.length > i + 1) {
                this.version = args[++i];
                continue;
            }
            if (args[i].equals("-Package") && args.length > i + 1) {
                pkg = args[++i];
                tempPackages.addElement(Pattern.compile(pkg + "\\..*"));
                continue;
            }
            if (args[i].equals("-PackageWithoutSubpackages") && args.length > i + 1) {
                pkg = args[++i];
                tempPackages.addElement(Pattern.compile(pkg + "\\.[^\\.]*"));
                continue;
            }
            if (args[i].equals("-Exclude") && args.length > i + 1) {
                tempExcludedElements.addElement(args[++i]);
                continue;
            }
            if (args[i].equals("-setup")) {
                setup = true;
                continue;
            }
            if (args[i].equals("-maintenance")) {
                this.isMaintenanceMode = true;
                continue;
            }
            if (args[i].equals("-extensibleinterfaces")) {
                this.extensibleInterfaces = true;
                continue;
            }
            if (args[i].equals("-UseReflect")) {
                this.isReflectUsed = true;
                continue;
            }
            if (args[i].equals("-Classpath") && args.length > i + 1) {
                classpath = args[++i];
                continue;
            }
            if (args[i].equals("-Verbose")) {
                this.isIgnorableReported = true;
                continue;
            }
            return Status.failed("Unknown option: " + args[i]);
        }
        if (fileName == null) {
            return Status.failed("Need to specify --FileName");
        }
        if (tempPackages.isEmpty()) {
            return Status.failed("Specify some packages to test");
        }
        this.packages = tempPackages.toArray(new Pattern[0]);
        if (tempExcludedElements.isEmpty()) {
            this.excludedElements = new String[0];
        } else {
            this.excludedElements = new String[tempExcludedElements.size()];
            for (i = 0; i < tempExcludedElements.size(); ++i) {
                this.excludedElements[i] = (String)tempExcludedElements.elementAt(i);
            }
        }
        this.errorWriter = !isOrdering ? (this.isMaintenanceMode ? new ErrorFormatter(log) : new ErrorFormatter(log, new String[]{"Required class not found in implementation: ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Incompatible change is found in ", "Incompatible change is found in ", "Incompatible change is found in ", "Incompatible change is found in ", "Incompatible change is found in ", "Incompatible change is found in ", "LinkageError does not allow to track definition in "})) : (this.isMaintenanceMode ? new SortedErrorFormatter(log) : new APISortedErrorFormatter(log));
        if (classpath == null) {
            return Status.failed("Specify --Classpath");
        }
        this.classIterator = new ClassesFromClasspath(classpath, this.isIgnorableReported);
        if (setup) {
            return this.setup(fileName);
        }
        return this.verify(fileName);
    }

    Status setup(String outFileName) {
        ClassCollection nestedErrors = new ClassCollection();
        boolean isThrowsTracked = this.classIterator.isThrowsTracked();
        this.converter = new PrimitiveConstantsChecker(true, isThrowsTracked);
        Vector packageClasses = new Vector();
        try {
            String name;
            PrintWriter out = new PrintWriter(new FileOutputStream(outFileName));
            out.println("#API master signature file");
            out.println("#Version " + this.version);
            if (!isThrowsTracked) {
                out.println("#Throws clause not tracked.");
            }
            this.loader = new ClassFinder(this.converter, this.details, this.classIterator.getClassLoader());
            Vector<String> duplicateClasses = new Vector<String>();
            while ((name = this.classIterator.nextClassName()) != null) {
                ++this.allClassesSize;
                try {
                    if (name.indexOf(36) >= 0) {
                        if (!this.isAccessible(TableOfClass.addNestedClass(name, this.loader)) || !this.isPackageMember(name)) continue;
                        packageClasses.addElement(name);
                        continue;
                    }
                    if (!this.isPackageMember(name) || !this.isAccessible(this.loader.loadClass(name))) continue;
                    packageClasses.addElement(name);
                }
                catch (ClassNotFoundException ex) {
                    nestedErrors.addUniqueElement(name, "Class not found: " + name);
                }
                catch (LinkageError ex1) {
                    nestedErrors.addUniqueElement(name, "Class not linked: " + name + " throw  " + ex1);
                }
            }
            ClassSorter temp = new ClassSorter(packageClasses, this.isReflectUsed, this.loader);
            packageClasses = temp.getSortedClasses(nestedErrors);
            this.classIterator.clear();
            while ((name = this.classIterator.nextClassName()) != null) {
                try {
                    if (!packageClasses.contains(name)) {
                        this.ignore(name);
                    }
                    if (!temp.isAccessible(name)) continue;
                    if (duplicateClasses.contains(name)) {
                        this.setupProblem("The class " + name + " is found twice.");
                        continue;
                    }
                    duplicateClasses.addElement(name);
                    InputStream classStream = this.classIterator.getCurrentClass();
                    this.converter.checkPrimitiveConstants(name, classStream);
                }
                catch (IOException t) {
                    this.setupProblem("The primitive constans of the class " + name + " can not be tracked throw " + t);
                }
                catch (ClassFormatError er) {
                    this.setupProblem("The primitive constans of the class " + name + " can not be tracked throw " + er);
                }
                catch (LinkageError er2) {}
            }
            duplicateClasses = null;
            this.classIterator.clear();
            for (int i = 0; i < packageClasses.size(); ++i) {
                name = (String)packageClasses.elementAt(i);
                try {
                    this.scanClass(out, this.loader.loadClass(name));
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    nestedErrors.addUniqueElement(name, "Class not found: " + name);
                    continue;
                }
                catch (LinkageError ex1) {
                    nestedErrors.addUniqueElement(name, "Class not linked: " + name + " throw " + ex1);
                }
            }
            Enumeration e = nestedErrors.keys();
            while (e.hasMoreElements()) {
                int tempPos;
                String tempName = (String)e.nextElement();
                if (!temp.isAccessible(tempName.substring(0, tempPos = tempName.lastIndexOf(36) + 1)) && !temp.isAccessible(tempName)) continue;
                Vector<Object> h = nestedErrors.get(tempName);
                for (int i = 0; i < h.size(); ++i) {
                    this.setupProblem((String)h.elementAt(i));
                }
            }
            out.close();
        }
        catch (IOException e) {
            this.log.println("problem creating definitions file");
            this.log.println(e);
            return Status.failed("problem creating definitions file");
        }
        this.errors += this.classIterator.printErrors(this.log);
        this.log.println("\n  Found classes   : " + this.allClassesSize);
        this.log.println("  Scanned classes : " + this.scanedClassesSize);
        if (this.errors == 0) {
            return Status.passed("");
        }
        return Status.failed(this.errors + " errors");
    }

    private void scanClass(PrintWriter out, SignatureClass c) throws ClassNotFoundException {
        int m = c.getModifiers();
        if (Modifier.isPublic(m) || Modifier.isProtected(m)) {
            ++this.scanedClassesSize;
            TableOfClass cl = new TableOfClass(c, this.isReflectUsed);
            cl.createMembers();
            cl.writeDefinitions(out);
        }
    }

    private Status verify(String sigFileURL) {
        this.trackedClassNames = new Vector();
        ClassSignatureReader in = null;
        try {
            TableOfClass currentClass;
            boolean isThrowsTracked;
            URL url = new File(sigFileURL).toURI().toURL();
            Reader r = FileManager.getReader(url);
            in = r != null ? new ClassSignatureFromSigtests(r, url) : new ClassSignatureReader(sigFileURL);
            in.isThrowsTracked = isThrowsTracked = this.classIterator.isThrowsTracked() && in.isThrowsTracked;
            if (this.isMaintenanceMode) {
                String[][] tempModifiers = new String[][]{{"fld  ", "constant"}};
                this.converter = new PrimitiveConstantsCheckerFromSigtests(true, isThrowsTracked, tempModifiers);
            } else {
                this.converter = new PrimitiveConstantsCheckerFromSigtests(true, isThrowsTracked);
            }
            this.loader = new ClassFinder(this.converter, this.details, this.classIterator.getClassLoader());
            in.setDefinitionConverter(this.converter);
            while ((currentClass = in.nextAPIClass()) != null) {
                String name = currentClass.getName();
                this.verifyClass(currentClass);
            }
        }
        catch (IOException e) {
            this.log.println("problem with definitions file");
            this.log.println(e);
            return Status.failed("problem with definitions file");
        }
        catch (SecurityException ex) {
            this.log.println("The security constraints does not allowto read from file.");
            this.log.println(ex);
            return Status.failed("The security constraints does not allow to read from file.");
        }
        block9: while (true) {
            try {
                String name;
                while (this.isMaintenanceMode && (name = this.classIterator.nextClassName()) != null) {
                    int pos = name.lastIndexOf(36);
                    try {
                        SignatureClass c = this.loader.loadClass(name);
                        if (!this.isAccessible(c) || !this.isPackageMember(name) || this.trackedClassNames.contains(c.getName()) || this.nonLinkedClasses.contains(c.getName())) continue block9;
                        this.errorWriter.addError("Added", c.getName(), null, null);
                        continue block9;
                    }
                    catch (ClassNotFoundException ex) {
                    }
                    catch (LinkageError ex1) {
                    }
                }
                break;
            }
            catch (SecurityException ex) {
                this.log.println("The security constraints does not allow to inspect CLASSPATH.");
                break;
            }
        }
        this.log.println("APIChangeTest Report\n");
        if (in != null) {
            this.log.println("Base version:   " + in.getJavaVersion());
        }
        String javaVersion = this.version;
        this.log.println("Tested version: " + javaVersion);
        this.log.println("");
        this.errors = this.errorWriter.printErrors();
        if (this.errors == 0) {
            return Status.passed("");
        }
        return Status.failed(this.errors + " errors");
    }

    private void verifyClass(TableOfClass required) {
        String name = required.getName();
        if (this.isPackageMember(name)) {
            try {
                SignatureClass c = this.loader.loadClass(name);
                TableOfClass cl = new TableOfClass(c, this.isReflectUsed);
                if (this.isMaintenanceMode) {
                    this.verifyMaintenanceClass(required, cl);
                } else {
                    this.verifyClass(required, cl);
                }
            }
            catch (ClassNotFoundException ex) {
                this.errorWriter.addError("Missing", name, null, null);
            }
            catch (LinkageError er) {
                this.errorWriter.addError("LinkageError", name, name + " throw " + er, null);
                this.nonLinkedClasses.addElement(name);
            }
        }
    }

    private void verifyMaintenanceClass(TableOfClass required, TableOfClass found) throws ClassNotFoundException {
        throw new ClassNotFoundException("Not implemented");
    }

    private void trackMember(String name, Vector required, Vector found, boolean onlyAbstract) {
        int i;
        Vector req = (Vector)required.clone();
        Vector fou = (Vector)found.clone();
        Vector retVal = new Vector();
        for (i = 0; i < req.size() && i >= 0; ++i) {
            int pos = fou.indexOf(req.elementAt(i));
            if (pos < 0) continue;
            req.removeElementAt(i--);
            fou.removeElementAt(pos);
        }
        for (i = 0; i < req.size(); ++i) {
            this.errorWriter.addError("Missing", name, (String)req.elementAt(i), null);
        }
        for (i = 0; i < fou.size(); ++i) {
            String m = (String)fou.elementAt(i);
            if (onlyAbstract && !m.contains(" abstract ")) continue;
            this.errorWriter.addError("Added", name, m, null);
        }
    }

    private void verifyClass(TableOfClass required, TableOfClass found) throws ClassNotFoundException {
        if (this.trackedClassNames.contains(found.getClassName())) {
            return;
        }
        this.trackedClassNames.addElement(found.getClassName());
        found.createMembers();
        this.trackClassDefinition(required.getName(), required.classDef, found.classDef, required.isFinal());
        boolean isProtectedTracked = !required.isFinal();
        boolean isNewAbstractAllowed = required.isFinal();
        Enumeration eReq = required.keys();
        while (eReq.hasMoreElements()) {
            String name = (String)eReq.nextElement();
            Vector requiredMembers = required.get(name);
            Vector existingMembers = found.get(name);
            if (existingMembers == null) {
                existingMembers = new Vector();
                existingMembers.add(null);
            }
            if (name.startsWith("innr ")) continue;
            if (name.startsWith("supr ")) {
                if (requiredMembers == null || requiredMembers.isEmpty()) continue;
                SignatureClass c = found.getClassObject();
                if (c != null) {
                    c = c.getSuperclass();
                }
                String superName = (String)requiredMembers.elementAt(0);
                superName = superName.substring(superName.lastIndexOf(32) + 1);
                while (c != null && !superName.equals(c.getName())) {
                    c = c.getSuperclass();
                }
                if (c != null || superName.equals("null")) continue;
                this.errorWriter.addError("Missing", required.getName(), (String)requiredMembers.elementAt(0), null);
                continue;
            }
            block2: for (int i = 0; i < requiredMembers.size(); ++i) {
                String tempReq = (String)requiredMembers.elementAt(i);
                String clName = required.getName();
                ErrorMessage error = null;
                for (Object objMember : existingMembers) {
                    String tempFou = (String)objMember;
                    if (tempFou == null && (tempReq.startsWith("meth ") || tempReq.startsWith("fld  ") || name.startsWith("intf ") || tempReq.startsWith("cons "))) {
                        this.errorWriter.addError("Missing", clName, tempReq, null);
                        continue block2;
                    }
                    if (tempReq.startsWith("meth ")) {
                        error = tempReq.indexOf(" static ") < 0 ? this.trackMethodDefinition(clName, required.classDef, tempReq, tempFou, isNewAbstractAllowed) : this.trackMethodDefinition(clName, required.classDef, tempReq);
                    } else if (tempReq.startsWith("fld  ")) {
                        this.trackFieldDefinition(clName, tempReq);
                    } else if (tempReq.startsWith("cons ")) {
                        this.trackConstructorDefinition(clName, tempReq, tempFou);
                    }
                    if (error != null) continue;
                    continue block2;
                }
                assert (error != null);
                this.errorWriter.addError(error);
            }
        }
        this.trackedClassNames.addElement(found.getClassName());
        found.createMembers();
        String modReq = required.classDef;
        modReq = modReq.substring(0, modReq.lastIndexOf(32));
        String modFou = found.classDef;
        modFou = modFou.substring(0, modFou.lastIndexOf(32));
        if (!this.isMaintenanceMode && !modFou.endsWith(" final") && modReq.endsWith(" final")) {
            modReq = modReq.replaceAll(" final", "");
            modFou = modFou.replaceAll(" abstract", "");
        }
        if (required.isInterface()) {
            modFou = modFou.replaceAll(" static", "");
            modReq = modReq.replaceAll(" static", "");
        }
        if (required.isFinal()) {
            modFou = modFou.replaceAll(" abstract", "").replaceAll(" final", "");
            modReq = modReq.replaceAll(" abstract", "").replaceAll(" final", "");
        }
        if (!modReq.equals(modFou)) {
            this.errorWriter.addError("Missing", required.getName(), required.classDef, null);
            this.errorWriter.addError("Added", found.getName(), found.classDef, null);
        }
        if (this.extensibleInterfaces && required.isInterface()) {
            return;
        }
        if (required.isFinal()) {
            return;
        }
        Enumeration eFou = found.keys();
        while (eFou.hasMoreElements()) {
            String name = (String)eFou.nextElement();
            Vector mReq = required.get(name);
            Vector mFou = found.get(name);
            if (mReq != null) continue;
            mReq = new Vector();
            this.trackMember(found.getName(), mReq, mFou, true);
        }
    }

    private void trackFieldDefinition(String name, String def) {
        if (this.converter.isPrimitiveConstant(def)) {
            return;
        }
        MemberDefinition required = new MemberDefinition(name, def);
        String className = required.getDeclaringClass();
        String fieldName = required.getShortSignature();
        try {
            Class<?> c = Class.forName(className, false, this.classIterator.getClassLoader());
            Field field = null;
            for (Class<?> current = c; current != null && field == null; current = current.getSuperclass()) {
                try {
                    field = current.getDeclaredField(fieldName);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            if (field != null) {
                MemberEntry entry = new MemberEntry(field, (DefinitionFormat)this.converter);
                this.trackFieldDefinition(name, def, entry.getEntry());
                return;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError er) {
            this.errorWriter.addError("LinkageError", name, "Can't link " + def + " throw " + er, null);
            return;
        }
        this.errorWriter.addError("Missing", name, def, null);
    }

    private ErrorMessage trackMethodDefinition(String clName, String clDef, String definition) {
        MemberDefinition def = new MemberDefinition("", definition);
        String name = def.getShortSignature();
        Object meth = null;
        try {
            Class<?> c = Class.forName(def.getDeclaringClass(), false, this.classIterator.getClassLoader());
            String methodName = name.substring(0, name.indexOf("("));
            for (Class<?> current = c; current != null; current = current.getSuperclass()) {
                Method[] methods = current.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    String temp = new MemberEntry(methods[i], (DefinitionFormat)this.converter).getKey();
                    temp = temp.substring("meth ".length());
                    if (!methodName.equals(methods[i].getName()) || !name.equals(temp)) continue;
                    MemberEntry t = new MemberEntry(methods[i], (DefinitionFormat)this.converter);
                    return this.trackMethodDefinition(clName, clDef, definition, t.getEntry(), false);
                }
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError er) {
            this.errorWriter.addError("LinkageError", clName, definition + " throw " + er, null);
        }
        this.errorWriter.addError("Missing", clName, definition, null);
        return null;
    }

    private void trackClassDefinition(String name, String before, String after, boolean wasFinal) {
        ErrorMessage em;
        String[][] tempModifs;
        MemberDefinition beforeDef = new MemberDefinition(name, before);
        MemberDefinition afterDef = new MemberDefinition(name, after);
        String[][] modifs = new String[][]{{null, "final"}, {null, wasFinal ? null : "abstract"}, {"interface", "interface"}};
        if (before.indexOf(" interface ") >= 0) {
            tempModifs = new String[][]{{"interface", "interface"}};
            modifs = tempModifs;
        }
        if (before.indexOf(" final ") >= 0) {
            tempModifs = new String[][]{{"interface", "interface"}};
            modifs = tempModifs;
        }
        if ((em = this.trackModifiers(name, modifs, beforeDef, afterDef)) != null) {
            this.errorWriter.addError(em);
        }
    }

    private void trackConstructorDefinition(String name, String before, String after) {
        MemberDefinition beforeDef = new MemberDefinition(name, before);
        MemberDefinition afterDef = new MemberDefinition(name, after);
        ErrorMessage em = this.trackModifiers(name, new String[0][0], beforeDef, afterDef);
        if (em != null) {
            this.errorWriter.addError(em);
        }
    }

    private void trackFieldDefinition(String name, String before, String after) {
        MemberDefinition beforeDef = new MemberDefinition(name, before);
        MemberDefinition afterDef = new MemberDefinition(name, after);
        String[][] modifs = new String[][]{{null, "final"}, {"static", "static"}, {"volatile", "volatile"}};
        ErrorMessage em = this.trackModifiers(name, modifs, beforeDef, afterDef);
        if (em != null) {
            this.errorWriter.addError(em);
        }
        if (!beforeDef.getType().equals(afterDef.getType())) {
            this.errorWriter.addError("Change type.", name, before, "of the " + beforeDef.getType() + " type.");
        }
    }

    private ErrorMessage trackMethodDefinition(String name, String clDef, String before, String after, boolean isNewAbstractAllowed) {
        MemberDefinition afterDef;
        MemberDefinition beforeDef;
        String[][] temp;
        String[][] modifs = isNewAbstractAllowed ? (temp = new String[][]{{"static", "static"}}) : (clDef.indexOf(" final ") < 0 ? (temp = new String[][]{{null, "final"}, {"static", "static"}, {null, "abstract"}}) : (temp = new String[][]{{"static", "static"}, {null, "abstract"}}));
        ErrorMessage em = this.trackModifiers(name, modifs, beforeDef = new MemberDefinition(name, before), afterDef = new MemberDefinition(name, after));
        if (em != null) {
            return em;
        }
        if (!beforeDef.getType().equals(afterDef.getType())) {
            return this.errorWriter.createError("Change type.", name, before, " return value of " + afterDef.getType());
        }
        return null;
    }

    private boolean isPackageMember(String name) {
        for (int j = 0; j < this.excludedElements.length; ++j) {
            if (!name.startsWith(this.excludedElements[j] + ".") && !name.equals(this.excludedElements[j])) continue;
            return false;
        }
        for (int i = 0; i < this.packages.length; ++i) {
            if (!this.packages[i].matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private void setupProblem(String msg) {
        this.log.println(msg);
        ++this.errors;
    }

    boolean isAccessible(SignatureClass c) {
        int m = c.getModifiers();
        return Modifier.isPublic(m) || Modifier.isProtected(m);
    }

    private ErrorMessage trackModifiers(String name, String[][] modifiers, MemberDefinition beforeDef, MemberDefinition afterDef) {
        int nBefore = beforeDef.getAccesModifier();
        int nAfter = afterDef.getAccesModifier();
        if (nAfter < nBefore) {
            if (nBefore == 3) {
                return this.errorWriter.createError("is not public", name, beforeDef.stringDefinition, "is not public in the new implementation");
            }
            if (nBefore == 2) {
                return this.errorWriter.createError("is not protected", name, beforeDef.stringDefinition, "is not protected in the new implementation");
            }
            return this.errorWriter.createError("less accessible", name, beforeDef.stringDefinition, "less accessible in the new implementation");
        }
        for (int i = 0; i < modifiers.length; ++i) {
            String before = modifiers[i][0];
            String after = modifiers[i][1];
            if (before != null && beforeDef.definitions.contains(before) && !afterDef.definitions.contains(before)) {
                return this.errorWriter.createError("is not " + before, name, beforeDef.stringDefinition, "is not " + before + " in the new implementation");
            }
            if (after == null || beforeDef.definitions.contains(after) || !afterDef.definitions.contains(after)) continue;
            return this.errorWriter.createError("is " + after, name, beforeDef.stringDefinition, "is " + after + " in the new implementation");
        }
        return null;
    }

    private void ignore(String message) {
        if (this.isIgnorableReported) {
            this.log.println("Ignoring " + message);
        }
    }
}

