/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.netbeans.apitest.ClassConstants;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.SignatureClass;
import org.netbeans.apitest.SignatureConstants;

final class MemberEntry
implements SignatureConstants,
ClassConstants {
    private String entry;
    private String key;
    protected Object object;
    protected boolean isSynthetic = false;
    private int modifiers;
    private String declaringClass = "";

    public MemberEntry(SignatureClass cl, DefinitionFormat converter, boolean isNestedClass) {
        String name = cl.getName();
        String s = MemberEntry.printClassAccess(cl.getModifiers());
        if (isNestedClass) {
            this.entry = converter.getDefinition("innr " + s + name);
            this.key = "innr " + name.substring(name.lastIndexOf(36) + 1);
            int k = name.lastIndexOf(36);
            this.declaringClass = k < 0 ? "" : name.substring(0, k);
        } else {
            this.entry = converter.getDefinition("CLSS " + s + name);
            this.key = "CLSS " + name;
        }
        this.object = cl;
        this.modifiers = cl.getModifiers();
    }

    public MemberEntry(Field field, DefinitionFormat converter) {
        boolean isQualifiedNames = converter.isQualifiedNamesUsed();
        String mod = "fld  " + MemberEntry.printAccess(field.getModifiers()) + field.getType().getName() + " ";
        if (isQualifiedNames) {
            mod = mod + field.getDeclaringClass().getName() + ".";
        }
        mod = mod + field.getName();
        this.entry = converter.getDefinition(mod);
        this.key = "fld  " + field.getName();
        this.object = field;
        this.modifiers = field.getModifiers();
        this.declaringClass = field.getDeclaringClass().getName();
    }

    public MemberEntry(Method meth, DefinitionFormat converter) {
        boolean isQualifiedNames = converter.isQualifiedNamesUsed();
        boolean startIndex = false;
        String modifiers = MemberEntry.printAccess(meth.getModifiers());
        String retVal = "meth ";
        Class<?> returnType = meth.getReturnType();
        Class<?>[] exceptions = meth.getExceptionTypes();
        Class<?>[] args = meth.getParameterTypes();
        String signature = meth.getName() + "(";
        if (args.length > 0) {
            signature = signature + args[0].getName();
        }
        for (int j = 1; j < args.length; ++j) {
            signature = signature + "," + args[j].getName();
        }
        signature = signature + ")";
        this.key = "meth " + signature;
        if (isQualifiedNames) {
            signature = meth.getDeclaringClass().getName() + "." + signature;
        }
        retVal = retVal + modifiers + returnType.getName() + " " + signature;
        String[] ExceptionName = new String[exceptions.length];
        for (int j = 0; j < exceptions.length; ++j) {
            ExceptionName[j] = exceptions[j].getName();
        }
        MemberEntry.sort(ExceptionName);
        if (ExceptionName.length > 0) {
            retVal = retVal + " throws " + ExceptionName[0];
        }
        for (int i = 1; i < ExceptionName.length; ++i) {
            retVal = retVal + "," + ExceptionName[i];
        }
        this.entry = converter.getDefinition(retVal);
        this.object = meth;
        this.modifiers = meth.getModifiers();
        this.declaringClass = meth.getDeclaringClass().getName();
    }

    public MemberEntry(Constructor ctor, DefinitionFormat converter) {
        boolean startIndex = false;
        String modifiers = MemberEntry.printAccess(ctor.getModifiers());
        String retVal = "cons ";
        Class<?>[] exceptions = ctor.getExceptionTypes();
        Class<?>[] args = ctor.getParameterTypes();
        String name = ctor.getDeclaringClass().getName();
        int pos = Math.max(name.lastIndexOf("."), name.lastIndexOf("$"));
        String signature = name.substring(pos + 1) + "(";
        if (args.length > 0) {
            signature = signature + args[0].getName();
        }
        for (int j = 1; j < args.length; ++j) {
            signature = signature + "," + args[j].getName();
        }
        signature = signature + ")";
        retVal = retVal + modifiers + signature;
        String[] ExceptionName = new String[exceptions.length];
        for (int j = 0; j < exceptions.length; ++j) {
            ExceptionName[j] = exceptions[j].getName();
        }
        MemberEntry.sort(ExceptionName);
        if (ExceptionName.length > 0) {
            retVal = retVal + " throws " + ExceptionName[0];
        }
        for (int i = 1; i < ExceptionName.length; ++i) {
            retVal = retVal + "," + ExceptionName[i];
        }
        this.entry = converter.getDefinition(retVal);
        this.key = "cons " + signature;
        this.object = ctor;
        this.modifiers = ctor.getModifiers();
        this.declaringClass = ctor.getDeclaringClass().getName();
    }

    public MemberEntry(String definition, DefinitionFormat converter) {
        this.setData(definition, converter);
    }

    protected MemberEntry() {
    }

    protected void setData(String definition, DefinitionFormat converter) {
        String currentDef;
        this.entry = currentDef = converter.getDefinition(definition);
        String type = currentDef.substring(0, "CLSS ".length());
        int pos = currentDef.lastIndexOf(" throws ");
        pos = pos < 0 ? currentDef.length() : pos;
        int namePos = currentDef.lastIndexOf(40, pos - 1);
        namePos = namePos < 0 ? pos : namePos;
        int localNamePos = currentDef.lastIndexOf(46, namePos - 1) + 1;
        if (localNamePos < (namePos = currentDef.lastIndexOf(32, namePos - 1) + 1)) {
            localNamePos = namePos;
        }
        String key = currentDef.substring(localNamePos, pos);
        if (currentDef.startsWith("intf ") || currentDef.startsWith("supr ")) {
            this.key = type;
            this.entry = currentDef;
        } else if (currentDef.startsWith("innr ")) {
            this.key = type + key.substring(key.lastIndexOf(36) + 1);
            this.entry = currentDef;
        } else if (currentDef.startsWith("CLSS ")) {
            this.key = type + key.substring(key.lastIndexOf(32) + 1);
            this.entry = currentDef;
        } else {
            String shortDef;
            this.key = type + key;
            this.entry = converter.isQualifiedNamesUsed() ? currentDef : (shortDef = currentDef.substring(0, namePos) + currentDef.substring(localNamePos));
        }
        this.object = definition;
        this.declaringClass = definition.substring(definition.lastIndexOf(32) + 1);
        pos = this.declaringClass.lastIndexOf(46);
        this.declaringClass = pos < 0 ? "" : this.declaringClass.substring(pos);
    }

    private static String[] sort(String[] arr) {
        for (int j = 0; j < arr.length; ++j) {
            int pos = j;
            for (int i = j + 1; i < arr.length; ++i) {
                if (arr[i].compareTo(arr[pos]) >= 0) continue;
                pos = i;
            }
            String temp = arr[j];
            arr[j] = arr[pos];
            arr[pos] = temp;
        }
        return arr;
    }

    protected static String printAccess(int access) {
        return ((access & 1) != 0 ? "public " : "") + ((access & 2) != 0 ? "private " : "") + ((access & 4) != 0 ? "protected " : "") + ((access & 8) != 0 ? "static " : "") + ((access & 0x80) != 0 ? "transient " : "") + ((access & 0x20) != 0 ? "synchronized " : "") + ((access & 0x400) != 0 ? "abstract " : "") + ((access & 0x100) != 0 ? "native " : "") + ((access & 0x10) != 0 ? "final " : "") + ((access & 0x200) != 0 ? "interface " : "") + ((access & 0x40) != 0 ? "volatile " : "");
    }

    protected static String printClassAccess(int access) {
        return ((access & 1) != 0 ? "public " : "") + ((access & 2) != 0 ? "private " : "") + ((access & 4) != 0 ? "protected " : "") + ((access & 8) != 0 ? "static " : "") + ((access & 0x80) != 0 ? "transient " : "") + ((access & 0x20) != 0 ? "flag_super " : "") + ((access & 0x400) != 0 || (access & 0x200) != 0 ? "abstract " : "") + ((access & 0x100) != 0 ? "native " : "") + ((access & 0x10) != 0 ? "final " : "") + ((access & 0x200) != 0 ? "interface " : "") + ((access & 0x40) != 0 ? "volatile " : "");
    }

    public String getKey() {
        return this.key;
    }

    public String getEntry() {
        return this.entry;
    }

    public boolean equals(Object o) {
        if (o instanceof MemberEntry) {
            return this.object.equals(((MemberEntry)o).object);
        }
        return super.equals(o);
    }

    public boolean isProtected() {
        if (this.object instanceof String) {
            return ((String)this.object).indexOf(" protected ") >= 0;
        }
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPublic() {
        if (this.object instanceof String) {
            return ((String)this.object).indexOf(" public ") >= 0;
        }
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isAbstract() {
        if (this.object instanceof String) {
            return ((String)this.object).indexOf(" abstract ") >= 0;
        }
        return Modifier.isAbstract(this.modifiers);
    }

    public String toString() {
        return this.entry;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isSynthetic() {
        String ts;
        if (this.entry.startsWith("meth ") && this.isProtected() && (ts = this.key.substring(Math.max(this.key.lastIndexOf(32), this.key.lastIndexOf(46)) + 1)).startsWith("access$")) {
            boolean retVal = ts.length() > 7;
            for (int k = 7; k < ts.length(); ++k) {
                if (ts.charAt(k) >= '0' && ts.charAt(k) <= '9') continue;
                retVal = false;
            }
            return retVal;
        }
        return false;
    }
}

