/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.apitest.PrimitiveConstantsChecker;

class PrimitiveConstantsCheckerFromSigtests
extends PrimitiveConstantsChecker {
    private Map<Integer, String> genericTypes = new HashMap<Integer, String>();
    private static Pattern BOUND = Pattern.compile("[^%]*%([0-9]*) (extends ([0-9a-zA-Z\\.]*))");
    private static Pattern ARRAY = Pattern.compile("[^\\p{Alnum}]((byte|short|int|long|float|double|char)\\[\\])");

    public PrimitiveConstantsCheckerFromSigtests(boolean isQualifiedName, boolean isThrowsTracked) {
        super(isQualifiedName, isThrowsTracked);
    }

    public PrimitiveConstantsCheckerFromSigtests(boolean isQualifiedName, boolean isThrowsTracked, String[][] removedModif) {
        super(isQualifiedName, isThrowsTracked, removedModif);
    }

    private static String replace(String definition, String prefix, String with) {
        if (definition.startsWith(prefix)) {
            definition = with + definition.substring(prefix.length());
        }
        return definition;
    }

    public String getDefinition(String definition) {
        int array;
        Matcher primitiveArray;
        int newLine;
        int eqsign;
        String orig = definition;
        definition = PrimitiveConstantsCheckerFromSigtests.replace(definition, "CLASS ", "CLSS ");
        definition = PrimitiveConstantsCheckerFromSigtests.replace(definition, "method ", "meth ");
        definition = PrimitiveConstantsCheckerFromSigtests.replace(definition, "field ", "fld  ");
        definition = PrimitiveConstantsCheckerFromSigtests.replace(definition, "constructor ", "cons ");
        if ((definition = definition.replace("!enum ", "")).startsWith("fld  ") && (eqsign = definition.indexOf(61)) >= 0) {
            definition = definition.substring(0, eqsign).trim();
        }
        if ((newLine = definition.indexOf(10)) >= 0) {
            definition = definition.substring(0, newLine);
        }
        while ((primitiveArray = ARRAY.matcher(definition)).find()) {
            String pa;
            String match = primitiveArray.group(2);
            switch (match.charAt(0)) {
                case 'b': {
                    pa = "[B";
                    break;
                }
                case 's': {
                    pa = "[S";
                    break;
                }
                case 'i': {
                    pa = "[I";
                    break;
                }
                case 'l': {
                    pa = "[J";
                    break;
                }
                case 'f': {
                    pa = "[F";
                    break;
                }
                case 'd': {
                    pa = "[D";
                    break;
                }
                case 'c': {
                    pa = "[C";
                    break;
                }
                default: {
                    throw new IllegalStateException(match);
                }
            }
            definition = definition.substring(0, primitiveArray.start(1)) + pa + definition.substring(primitiveArray.end(1));
        }
        while ((array = definition.indexOf("[]")) != -1) {
            char ch;
            int pos;
            for (pos = array - 1; pos >= 0 && ((ch = definition.charAt(pos)) == '.' || Character.isJavaIdentifierPart(ch)); --pos) {
            }
            String arrName = definition.substring(++pos, array);
            String beg = definition.substring(0, pos);
            String end = definition.substring(array + 2);
            definition = beg + "[L" + arrName + ";" + end;
        }
        return super.getDefinition(definition);
    }
}

