/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Properties;
import org.netbeans.apitest.ClassConstants;
import org.netbeans.apitest.ClassFinder;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.MemberEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SignatureClass
implements ClassConstants {
    Class classObject;
    protected DefinitionFormat filter;
    protected Properties details;
    private ClassFinder loader;

    SignatureClass(Class classObject, DefinitionFormat filter, ClassFinder loader, Properties details) {
        this.details = details;
        this.classObject = classObject;
        this.filter = filter;
        this.loader = loader;
    }

    protected SignatureClass() {
    }

    public MemberEntry getMemberEntry(boolean isNestedClass) {
        return new MemberEntry(this, this.filter, isNestedClass);
    }

    public MemberEntry[] getDeclaredMethods() {
        Method[] methods = this.classObject.getDeclaredMethods();
        MemberEntry[] retVal = new MemberEntry[methods.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(methods[i], this.filter);
            if (!SignatureClass.isVisible(methods[i])) continue;
            boolean bad = false;
            if (!SignatureClass.isVisible(methods[i].getReturnType())) {
                bad = true;
            }
            if (!SignatureClass.isVisible(methods[i].getParameterTypes())) {
                bad = true;
            }
            if (!SignatureClass.isVisible(methods[i].getGenericExceptionTypes())) {
                bad = true;
            }
            if (!SignatureClass.isVisible(methods[i].getGenericParameterTypes())) {
                bad = true;
            }
            if (!SignatureClass.isVisible(methods[i].getGenericReturnType())) {
                bad = true;
            }
            if (!bad) continue;
            throw new IllegalStateException("Hidden class in " + retVal[i]);
        }
        return retVal;
    }

    private static boolean isVisible(Member m) {
        return (m.getModifiers() & 5) != 0;
    }

    private static boolean isVisible(Class<?> ... classes) {
        for (Class<?> c : classes) {
            if ((c.getModifiers() & 5) != 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isVisible(Type ... types) {
        for (Type t : types) {
            if (t instanceof Class) {
                return SignatureClass.isVisible((Class)t);
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                if (!SignatureClass.isVisible(pt.getActualTypeArguments())) {
                    return false;
                }
                if (!SignatureClass.isVisible(pt.getRawType())) {
                    return false;
                }
            }
            if (!(t instanceof WildcardType)) continue;
            WildcardType wt = (WildcardType)t;
            if (!SignatureClass.isVisible(wt.getLowerBounds())) {
                return false;
            }
            if (SignatureClass.isVisible(wt.getUpperBounds())) continue;
            return false;
        }
        return true;
    }

    public MemberEntry[] getDeclaredFields() {
        Field[] fields = this.classObject.getDeclaredFields();
        MemberEntry[] retVal = new MemberEntry[fields.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(fields[i], this.filter);
            if (!SignatureClass.isVisible(fields[i]) || SignatureClass.isVisible(fields[i].getType()) && SignatureClass.isVisible(fields[i].getGenericType())) continue;
            throw new IllegalStateException("Hidden class in " + retVal[i]);
        }
        return retVal;
    }

    public SignatureClass[] getDeclaredClasses() {
        Class<?>[] nested = this.classObject.getDeclaredClasses();
        SignatureClass[] retVal = new SignatureClass[nested.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new SignatureClass(nested[i], this.filter, this.loader, this.details);
        }
        return retVal;
    }

    public MemberEntry[] getDeclaredConstructors() {
        Constructor<?>[] ctors = this.classObject.getDeclaredConstructors();
        MemberEntry[] retVal = new MemberEntry[ctors.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(ctors[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass[] getInterfaces() {
        Class<?>[] interfaces = this.classObject.getInterfaces();
        SignatureClass[] retVal = new SignatureClass[interfaces.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new SignatureClass(interfaces[i], this.filter, this.loader, this.details);
        }
        return retVal;
    }

    public MemberEntry[] getMethods() {
        Method[] methods = this.classObject.getMethods();
        MemberEntry[] retVal = new MemberEntry[methods.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(methods[i], this.filter);
        }
        return retVal;
    }

    public MemberEntry[] getFields() {
        Field[] fields = this.classObject.getFields();
        MemberEntry[] retVal = new MemberEntry[fields.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(fields[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass[] getClasses() {
        Class<?>[] nested = this.classObject.getClasses();
        SignatureClass[] retVal = new SignatureClass[nested.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new SignatureClass(nested[i], this.filter, this.loader, this.details);
        }
        return retVal;
    }

    public MemberEntry[] getConstructors() {
        Constructor<?>[] ctors = this.classObject.getConstructors();
        MemberEntry[] retVal = new MemberEntry[ctors.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(ctors[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass getSuperclass() {
        Class spr = this.classObject.getSuperclass();
        if (spr == null) {
            return null;
        }
        return new SignatureClass(spr, this.filter, this.loader, this.details);
    }

    public SignatureClass getDeclaringClass() {
        Class<?> declClass = this.classObject.getDeclaringClass();
        if (declClass == null) {
            return null;
        }
        return new SignatureClass(this.classObject.getDeclaringClass(), this.filter, this.loader, this.details);
    }

    public String getName() {
        return this.classObject.getName();
    }

    public int getModifiers() {
        String value = this.details.getProperty("NestedProtected");
        int m = 1585;
        m = value == null ? m + 4 : m;
        value = this.details.getProperty("NestedStatic");
        m = value == null ? m + 8 : m;
        return this.classObject.getModifiers() & m;
    }

    public boolean equals(Object o) {
        if (o instanceof SignatureClass) {
            return this.classObject.equals(((SignatureClass)o).classObject);
        }
        return super.equals(o);
    }

    public SignatureClass loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }
}

