/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import com.sun.tdk.signaturetest.Setup;
import com.sun.tdk.signaturetest.SignatureTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.apitest.Main;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Sigtest
extends Task {
    File fileName;
    Path classpath;
    String version;
    String packages;
    ActionType action;
    Boolean failOnError;
    File report;
    String failureProperty;

    public void setFileName(File f) {
        this.fileName = f;
    }

    public void setPackages(String s) {
        this.packages = s;
    }

    public void setAction(ActionType s) {
        this.action = s;
    }

    public void setClasspath(Path p) {
        if (this.classpath == null) {
            this.classpath = p;
        } else {
            this.classpath.append(p);
        }
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setFailureProperty(String p) {
        this.failureProperty = p;
    }

    public void setReport(File report) {
        this.report = report;
    }

    public void execute() throws BuildException {
        boolean fail;
        int returnCode;
        if (this.fileName == null) {
            throw new BuildException("FileName has to filed", this.getLocation());
        }
        if (this.packages == null) {
            throw new BuildException("Packages has to filed", this.getLocation());
        }
        if (this.action == null) {
            throw new BuildException("Action has to filed", this.getLocation());
        }
        if (this.classpath == null) {
            throw new BuildException("Classpath has to filed", this.getLocation());
        }
        if (this.packages.equals("-")) {
            this.log("No public packages, skipping");
            return;
        }
        boolean generate = false;
        boolean strictcheck = false;
        boolean addBootCP = false;
        boolean onlySameVersion = false;
        ArrayList<String> arg = new ArrayList<String>();
        arg.add("-FileName");
        arg.add(this.fileName.getAbsolutePath());
        if (this.action.getValue().equals("generate")) {
            generate = true;
            addBootCP = true;
            arg.add("-static");
        } else if (!this.action.getValue().equals("check")) {
            if (this.action.getValue().equals("binarycheck")) {
                arg.add("-extensibleinterfaces");
            } else if (this.action.getValue().equals("strictcheck")) {
                addBootCP = true;
                strictcheck = true;
                arg.add("-static");
            } else if (this.action.getValue().equals("versioncheck")) {
                addBootCP = true;
                strictcheck = true;
                arg.add("-static");
                onlySameVersion = true;
            } else {
                throw new BuildException("Unknown action: " + (Object)((Object)this.action));
            }
        }
        if (this.version != null) {
            arg.add("-Version");
            arg.add(this.version);
        }
        this.log("Packages: " + this.packages);
        StringTokenizer packagesTokenizer = new StringTokenizer(this.packages, ",");
        while (packagesTokenizer.hasMoreTokens()) {
            String p = packagesTokenizer.nextToken().trim();
            String prefix = "-PackageWithoutSubpackages ";
            int idx = p.lastIndexOf(".*");
            if (idx > 0) {
                p = p.substring(0, idx);
            } else {
                idx = p.lastIndexOf(".**");
                if (idx > 0) {
                    prefix = "-Package ";
                    p = p.substring(0, idx);
                }
            }
            arg.add(prefix.trim());
            arg.add(p);
        }
        if (this.classpath != null) {
            StringBuffer sb = new StringBuffer();
            String pref = "";
            for (String e : this.classpath.list()) {
                sb.append(pref);
                sb.append(e);
                pref = File.pathSeparator;
            }
            if (addBootCP) {
                boolean rtJAR = false;
                File lib = new File(System.getProperty("java.home"), "lib");
                if (!lib.exists()) {
                    throw new BuildException("Missing " + lib + "/rt.jar");
                }
                for (File f : lib.listFiles()) {
                    if (f.getName().endsWith(".jar")) {
                        sb.append(File.pathSeparator).append(f);
                    }
                    if (!"rt.jar".equals(f.getName())) continue;
                    rtJAR = true;
                }
                if (!rtJAR) {
                    this.log("Missing " + lib + "/rt.jar");
                }
            }
            arg.add("-Classpath");
            arg.add(sb.toString());
        }
        String[] args = arg.toArray(new String[0]);
        StringWriter output = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)output, true);
        if (generate) {
            Setup t = new Setup();
            t.run(args, w, null);
            returnCode = t.isPassed() ? 0 : 1;
        } else if (strictcheck) {
            SignatureTest t = new SignatureTest();
            t.run(args, w, null);
            int n = returnCode = t.isPassed() ? 0 : 1;
            if (onlySameVersion && !t.isPassed()) {
                String prefix = "Base version: ";
                int index = output.toString().indexOf("Base version: ");
                if (index < 0) {
                    throw new BuildException("Missing Base version:  in:\n" + output.toString());
                }
                int end = output.toString().indexOf(10, index);
                String base = output.toString().substring(index + "Base version: ".length(), end);
                this.log("versioncheck.TestedVersion: " + this.version, 3);
                this.log("versioncheck.BaseVersion: " + base, 3);
                if (!this.version.equals(base)) {
                    this.log("versioncheck. clearing the return status.", 3);
                    returnCode = 0;
                }
            }
        } else {
            returnCode = Main.run(args, w, w).getType();
        }
        String mail = this.getProject().getProperty("sigtest.mail");
        String out = mail != null ? "\nemail: " + mail + "\n" + output : output.toString();
        this.log(out);
        if (this.report != null) {
            this.writeReport(this.report, out, returnCode == 0 || Boolean.FALSE.equals(this.failOnError));
            fail = Boolean.TRUE.equals(this.failOnError);
        } else {
            boolean bl = fail = !Boolean.FALSE.equals(this.failOnError);
        }
        if (returnCode != 0) {
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, "true");
            } else if (fail) {
                throw new BuildException("Signature tests return code is wrong (" + returnCode + "), check the messages above", this.getLocation());
            }
            this.log("Signature tests return code is wrong (" + returnCode + "), check the messages above");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReport(File reportFile, String msg, boolean success) throws BuildException {
        assert (reportFile != null);
        try {
            String apiName = this.fileName.getName().replace(".sig", "").replace("-", ".");
            StringBuilder name = new StringBuilder();
            name.append(apiName).append('.').append(this.action.getValue());
            if (this.version != null) {
                name.append("_Version_").append(this.version.replace('.', '_'));
            }
            Document reportDoc = Sigtest.createDocument("testsuite");
            Element testsuite = reportDoc.getDocumentElement();
            int failures = 0;
            testsuite.setAttribute("errors", "0");
            testsuite.setAttribute("time", "0.0");
            testsuite.setAttribute("name", name.toString());
            Element testcase = reportDoc.createElement("testcase");
            testsuite.appendChild(testcase);
            testcase.setAttribute("classname", name.toString());
            testcase.setAttribute("name", this.action.getValue());
            testcase.setAttribute("time", "0.0");
            if (!success) {
                ++failures;
                Element failure = reportDoc.createElement("failure");
                testcase.appendChild(failure);
                failure.setAttribute("type", "junit.framework.AssertionFailedError");
                failure.setAttribute("message", "Failed " + this.action.getValue() + " for " + apiName + " in version " + this.version);
            }
            testsuite.setAttribute("failures", Integer.toString(failures));
            testsuite.setAttribute("tests", Integer.toString(1));
            Element systemerr = reportDoc.createElement("system-err");
            systemerr.appendChild(reportDoc.createCDATASection(msg));
            testsuite.appendChild(systemerr);
            FileOutputStream os = new FileOutputStream(reportFile);
            try {
                DOMSource dom = new DOMSource(reportDoc);
                StreamResult res = new StreamResult(os);
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.transform(dom, res);
            }
            finally {
                ((OutputStream)os).close();
            }
            this.log(reportFile + ": " + failures + " failures in " + this.fileName);
        }
        catch (TransformerException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException x) {
            throw new BuildException("Could not write " + reportFile + ": " + x, (Throwable)x, this.getLocation());
        }
    }

    private static Document createDocument(String rootQName) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation().createDocument(null, rootQName, null);
        }
        catch (ParserConfigurationException ex) {
            throw (DOMException)new IOException("Cannot create parser").initCause(ex);
        }
    }

    public static final class ActionType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"generate", "check", "strictcheck", "versioncheck", "binarycheck"};
        }
    }
}

